/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;

public class SqlAbstractTimeFunction
extends SqlFunction {
    private static final SqlOperandTypeChecker OTC_CUSTOM = OperandTypes.or(OperandTypes.POSITIVE_INTEGER_LITERAL, OperandTypes.NILADIC);
    private final SqlTypeName typeName;

    protected SqlAbstractTimeFunction(String name, SqlTypeName typeName) {
        super(name, SqlKind.OTHER_FUNCTION, null, null, OTC_CUSTOM, SqlFunctionCategory.TIMEDATE);
        this.typeName = typeName;
    }

    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION_ID;
    }

    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType type;
        int precision = 0;
        if (opBinding.getOperandCount() == 1 && SqlTypeUtil.isNumeric(type = opBinding.getOperandType(0))) {
            precision = opBinding.getIntLiteralOperand(0);
        }
        assert (precision >= 0);
        if (precision > 3) {
            throw opBinding.newError(Static.RESOURCE.argumentMustBeValidPrecision(opBinding.getOperator().getName(), 0, 3));
        }
        return opBinding.getTypeFactory().createSqlType(this.typeName, precision);
    }

    public SqlMonotonicity getMonotonicity(SqlCall call, SqlValidatorScope scope) {
        return SqlMonotonicity.INCREASING;
    }

    public boolean isDynamicFunction() {
        return true;
    }
}

