/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.SqlPrefixOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectiveSqlOperatorTable
implements SqlOperatorTable {
    public static final String IS_NAME = "INFORMATION_SCHEMA";
    private final Multimap<String, SqlOperator> operators = HashMultimap.create();
    private final Map<Pair<String, SqlSyntax>, SqlOperator> mapNameToOp = new HashMap<Pair<String, SqlSyntax>, SqlOperator>();

    protected ReflectiveSqlOperatorTable() {
    }

    public final void init() {
        for (Field field : this.getClass().getFields()) {
            try {
                SqlOperator op;
                if (SqlFunction.class.isAssignableFrom(field.getType())) {
                    op = (SqlFunction)field.get(this);
                    if (op == null) continue;
                    this.register((SqlFunction)op);
                    continue;
                }
                if (!SqlOperator.class.isAssignableFrom(field.getType())) continue;
                op = (SqlOperator)field.get(this);
                this.register(op);
            }
            catch (IllegalArgumentException e) {
                throw Util.newInternal(e, "Error while initializing operator table");
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal(e, "Error while initializing operator table");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList) {
        String simpleName;
        if (opName.names.size() > 1) {
            if (!((String)opName.names.get(opName.names.size() - 2)).equals(IS_NAME)) return;
            simpleName = Util.last(opName.names);
        } else {
            simpleName = opName.getSimple();
        }
        Collection list = this.operators.get((Object)simpleName.toUpperCase());
        if (list.isEmpty()) {
            return;
        }
        for (SqlOperator op : list) {
            if (op.getSyntax() == syntax) {
                operatorList.add(op);
                continue;
            }
            if (syntax != SqlSyntax.FUNCTION || !(op instanceof SqlFunction)) continue;
            operatorList.add(op);
        }
        switch (syntax) {
            case BINARY: 
            case PREFIX: 
            case POSTFIX: {
                SqlOperator extra = this.mapNameToOp.get(Pair.of(simpleName, syntax));
                if (extra == null || operatorList.contains(extra)) return;
                operatorList.add(extra);
            }
        }
    }

    public void register(SqlOperator op) {
        this.operators.put((Object)op.getName(), (Object)op);
        if (op instanceof SqlBinaryOperator) {
            this.mapNameToOp.put(Pair.of(op.getName(), SqlSyntax.BINARY), op);
        } else if (op instanceof SqlPrefixOperator) {
            this.mapNameToOp.put(Pair.of(op.getName(), SqlSyntax.PREFIX), op);
        } else if (op instanceof SqlPostfixOperator) {
            this.mapNameToOp.put(Pair.of(op.getName(), SqlSyntax.POSTFIX), op);
        }
    }

    public void register(SqlFunction function) {
        this.operators.put((Object)function.getName(), (Object)function);
        SqlFunctionCategory funcType = function.getFunctionType();
        assert (funcType != null) : "Function type for " + function.getName() + " not set";
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        return ImmutableList.copyOf((Collection)this.operators.values());
    }
}

