/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.function.Predicate1;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.SchemaNamespace;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonikerType;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CatalogScope
extends DelegatingScope {
    final ImmutableList<String> names;
    private final Set<List<String>> schemaNames;

    CatalogScope(SqlValidatorScope parent, List<String> names) {
        super(parent);
        this.names = ImmutableList.copyOf(names);
        this.schemaNames = (Set)Linq4j.asEnumerable(this.validator.getCatalogReader().getAllSchemaObjectNames((List<String>)ImmutableList.of())).where((Predicate1)new Predicate1<SqlMoniker>(){

            public boolean apply(SqlMoniker input) {
                return input.getType() == SqlMonikerType.SCHEMA;
            }
        }).select((Function1)new Function1<SqlMoniker, List<String>>(){

            public List<String> apply(SqlMoniker input) {
                return input.getFullyQualifiedNames();
            }
        }).into((Collection)Sets.newHashSet());
    }

    @Override
    public SqlNode getNode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlValidatorNamespace resolve(List<String> names, SqlValidatorScope[] ancestorOut, int[] offsetOut) {
        ImmutableList nameList = ImmutableList.builder().addAll(this.names).addAll(names).build();
        if (this.schemaNames.contains(nameList)) {
            return new SchemaNamespace(this.validator, (ImmutableList<String>)nameList);
        }
        return null;
    }
}

