/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

public class SetopNamespace
extends AbstractNamespace {
    private final SqlCall call;

    protected SetopNamespace(SqlValidatorImpl validator, SqlCall call, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.call = call;
    }

    public SqlNode getNode() {
        return this.call;
    }

    public RelDataType validateImpl() {
        switch (this.call.getKind()) {
            case UNION: 
            case INTERSECT: 
            case EXCEPT: {
                SqlValidatorScope scope = this.validator.scopes.get(this.call);
                for (SqlNode operand : this.call.getOperandList()) {
                    if (!operand.isA(SqlKind.QUERY)) {
                        throw this.validator.newValidationError(operand, Static.RESOURCE.needQueryOp(operand.toString()));
                    }
                    this.validator.validateQuery(operand, scope);
                }
                return this.call.getOperator().validateOperands(this.validator, scope, this.call);
            }
        }
        throw Util.newInternal("Not a query: " + (Object)((Object)this.call.getKind()));
    }
}

