/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.validate.SqlMonikerType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface SqlMoniker {
    public static final Comparator<SqlMoniker> COMPARATOR = new Comparator<SqlMoniker>(){
        final Ordering<Iterable<String>> listOrdering = Ordering.natural().lexicographical();

        @Override
        public int compare(SqlMoniker o1, SqlMoniker o2) {
            int c = o1.getType().compareTo(o2.getType());
            if (c == 0) {
                c = this.listOrdering.compare(o1.getFullyQualifiedNames(), o2.getFullyQualifiedNames());
            }
            return c;
        }
    };

    public SqlMonikerType getType();

    public List<String> getFullyQualifiedNames();

    public SqlIdentifier toIdentifier();

    public String id();
}

