/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkList<E>
extends AbstractSequentialList<E> {
    private static final int HEADER_SIZE = 3;
    private int size;
    private Object[] first;
    private Object[] last;
    private static final int CHUNK_SIZE = 64;
    private static final Integer[] INTEGERS = new Integer[67];

    public ChunkList() {
    }

    public ChunkList(Collection<E> collection) {
        this.addAll(collection);
    }

    boolean isValid(boolean fail) {
        if (this.first == null != (this.last == null)) {
            assert (!fail);
            return false;
        }
        if (this.first == null != (this.size == 0)) {
            assert (!fail);
            return false;
        }
        int n = 0;
        for (Object e : this) {
            if (n++ <= this.size) continue;
            assert (!fail);
            return false;
        }
        if (n != this.size) {
            assert (!fail);
            return false;
        }
        Object[] prev = null;
        Object[] chunk = this.first;
        while (chunk != null) {
            if (ChunkList.prev(chunk) != prev) {
                assert (!fail);
                return false;
            }
            prev = chunk;
            if (ChunkList.occupied(chunk) == 0) {
                assert (!fail);
                return false;
            }
            chunk = ChunkList.next(chunk);
        }
        return true;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.locate(index);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(E element) {
        int occupied;
        Object[] chunk = this.last;
        if (chunk == null) {
            this.last = new Object[67];
            this.first = this.last;
            chunk = this.last;
            occupied = 0;
        } else {
            occupied = ChunkList.occupied(chunk);
            if (occupied == 64) {
                chunk = new Object[67];
                ChunkList.setNext(this.last, chunk);
                ChunkList.setPrev(chunk, this.last);
                occupied = 0;
                this.last = chunk;
            }
        }
        ChunkList.setOccupied(chunk, occupied + 1);
        ChunkList.setElement(chunk, 3 + occupied, element);
        ++this.size;
        return true;
    }

    @Override
    public void add(int index, E element) {
        if (index == this.size) {
            this.add(element);
        } else {
            super.add(index, element);
        }
    }

    private static Object[] prev(Object[] chunk) {
        return (Object[])chunk[0];
    }

    private static void setPrev(Object[] chunk, Object[] prev) {
        chunk[0] = prev;
    }

    private static Object[] next(Object[] chunk) {
        return (Object[])chunk[1];
    }

    private static void setNext(Object[] chunk, Object[] next) {
        assert (chunk != next);
        chunk[1] = next;
    }

    private static int occupied(Object[] chunk) {
        return (Integer)chunk[2];
    }

    private static void setOccupied(Object[] chunk, int size) {
        chunk[2] = INTEGERS[size];
    }

    private static Object element(Object[] chunk, int index) {
        return chunk[index];
    }

    private static void setElement(Object[] chunk, int index, Object element) {
        chunk[index] = element;
    }

    private ChunkListIterator locate(int index) {
        if (index == 0) {
            return new ChunkListIterator();
        }
        int n = 0;
        Object[] chunk = this.first;
        while (true) {
            int occupied = ChunkList.occupied(chunk);
            int nextN = n + occupied;
            Object[] next = ChunkList.next(chunk);
            if (nextN > index || next == null) {
                return new ChunkListIterator(chunk, n, index - n - 1 + 3, occupied + 3);
            }
            n = nextN;
            chunk = next;
        }
    }

    static /* synthetic */ Object[] access$502(ChunkList x0, Object[] x1) {
        x0.last = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$002(ChunkList x0, Object[] x1) {
        x0.first = x1;
        return x1;
    }

    static {
        for (int i = 0; i < INTEGERS.length; ++i) {
            ChunkList.INTEGERS[i] = i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChunkListIterator
    implements ListIterator<E> {
        private Object[] chunk;
        private int startIndex;
        private int offset;
        private int end;

        ChunkListIterator() {
            this(null, 0, -1, 0);
        }

        ChunkListIterator(Object[] chunk, int startIndex, int offset, int end) {
            this.chunk = chunk;
            this.startIndex = startIndex;
            this.offset = offset;
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            return this.offset + 1 < this.end || (this.chunk == null ? ChunkList.this.first != null : ChunkList.next(this.chunk) != null);
        }

        @Override
        public E next() {
            ++this.offset;
            assert (this.offset <= this.end);
            if (this.offset == this.end) {
                if (this.chunk == null) {
                    this.chunk = ChunkList.this.first;
                } else {
                    this.chunk = ChunkList.next(this.chunk);
                    this.startIndex += this.end - 3;
                }
                if (this.chunk == null) {
                    throw new NoSuchElementException();
                }
                this.offset = 3;
                this.end = ChunkList.occupied(this.chunk) + 3;
            }
            return ChunkList.element(this.chunk, this.offset);
        }

        @Override
        public boolean hasPrevious() {
            return this.offset >= 3 || ChunkList.prev(this.chunk) != null;
        }

        @Override
        public E previous() {
            --this.offset;
            if (this.offset == 2) {
                Object[] objectArray = this.chunk = this.chunk == null ? ChunkList.this.last : ChunkList.prev(this.chunk);
                if (this.chunk == null) {
                    throw new NoSuchElementException();
                }
                this.end = ChunkList.occupied(this.chunk);
                this.startIndex -= this.end;
                this.offset = this.end - 1;
            }
            return ChunkList.element(this.chunk, this.offset);
        }

        @Override
        public int nextIndex() {
            return this.startIndex + (this.offset - 3) + 1;
        }

        @Override
        public int previousIndex() {
            return this.startIndex + (this.offset - 3);
        }

        @Override
        public void remove() {
            Object[] next;
            --ChunkList.this.size;
            if (this.end == 4) {
                Object[] prev = ChunkList.prev(this.chunk);
                Object[] next2 = ChunkList.next(this.chunk);
                if (next2 == null) {
                    ChunkList.access$502(ChunkList.this, prev);
                    if (prev == null) {
                        ChunkList.access$002(ChunkList.this, null);
                    } else {
                        ChunkList.setNext(prev, null);
                    }
                    this.chunk = null;
                    this.end = 3;
                    this.offset = this.end - 1;
                } else {
                    if (prev == null) {
                        ChunkList.access$002(ChunkList.this, next2);
                        ChunkList.setPrev(next2, null);
                    } else {
                        ChunkList.setNext(prev, next2);
                        ChunkList.setPrev(next2, prev);
                    }
                    this.chunk = next2;
                    this.offset = 3;
                    this.end = 3 + ChunkList.occupied(next2);
                }
                return;
            }
            System.arraycopy(this.chunk, this.offset + 1, this.chunk, this.offset, this.end - this.offset - 1);
            --this.end;
            ChunkList.setElement(this.chunk, this.end, null);
            ChunkList.setOccupied(this.chunk, this.end - 3);
            if (this.offset == this.end && (next = ChunkList.next(this.chunk)) != null) {
                this.startIndex += this.end - 3;
                this.chunk = next;
                this.offset = 2;
                this.end = 3 + ChunkList.occupied(next);
            }
        }

        @Override
        public void set(E e) {
            ChunkList.setElement(this.chunk, this.offset, e);
        }

        @Override
        public void add(E e) {
            if (this.chunk == null || this.end == 67) {
                Object[] newChunk = new Object[67];
                if (this.chunk == null) {
                    if (ChunkList.this.first != null) {
                        ChunkList.setNext(newChunk, ChunkList.this.first);
                        ChunkList.setPrev(ChunkList.this.first, newChunk);
                    }
                    ChunkList.access$002(ChunkList.this, newChunk);
                    if (ChunkList.this.last == null) {
                        ChunkList.access$502(ChunkList.this, newChunk);
                    }
                } else {
                    Object[] next = ChunkList.next(this.chunk);
                    ChunkList.setPrev(newChunk, this.chunk);
                    ChunkList.setNext(this.chunk, newChunk);
                    if (next == null) {
                        ChunkList.access$502(ChunkList.this, newChunk);
                    } else {
                        ChunkList.setPrev(next, newChunk);
                        ChunkList.setNext(newChunk, next);
                    }
                    this.startIndex += 64;
                }
                this.chunk = newChunk;
                this.offset = 3;
                this.end = 3;
            } else {
                System.arraycopy(this.chunk, this.offset, this.chunk, this.offset + 1, this.end - this.offset);
            }
            ChunkList.setElement(this.chunk, this.offset, e);
            ++this.end;
            ChunkList.setOccupied(this.chunk, this.end - 3);
            ++ChunkList.this.size;
        }
    }
}

