/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.plugins.common.ui.named.cluster.bridge;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.namedcluster.NamedClusterManager;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.metastore.api.IMetaStore;

public class NamedClusterBridgeImpl
implements org.pentaho.big.data.api.cluster.NamedCluster {
    private final NamedCluster delegate;
    private final NamedClusterManager namedClusterManager;

    public NamedClusterBridgeImpl(NamedCluster delegate) {
        this(delegate, NamedClusterManager.getInstance());
    }

    @VisibleForTesting
    NamedClusterBridgeImpl(NamedCluster delegate, NamedClusterManager namedClusterManager) {
        this.delegate = delegate;
        this.namedClusterManager = namedClusterManager;
    }

    public static NamedCluster fromOsgiNamedCluster(org.pentaho.big.data.api.cluster.NamedCluster namedCluster) {
        if (namedCluster == null) {
            return null;
        }
        NamedCluster result = new NamedCluster();
        new NamedClusterBridgeImpl(result).replaceMeta(namedCluster);
        return result;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void setName(String name) {
        this.delegate.setName(name);
    }

    public void replaceMeta(org.pentaho.big.data.api.cluster.NamedCluster nc) {
        this.delegate.setName(nc.getName());
        this.delegate.setHdfsHost(nc.getHdfsHost());
        this.delegate.setHdfsPort(nc.getHdfsPort());
        this.delegate.setHdfsUsername(nc.getHdfsUsername());
        this.delegate.setHdfsPassword(nc.getHdfsPassword());
        this.delegate.setJobTrackerHost(nc.getJobTrackerHost());
        this.delegate.setJobTrackerPort(nc.getJobTrackerPort());
        this.delegate.setZooKeeperHost(nc.getZooKeeperHost());
        this.delegate.setZooKeeperPort(nc.getZooKeeperPort());
        this.delegate.setOozieUrl(nc.getOozieUrl());
        this.delegate.setMapr(nc.isMapr());
        this.delegate.setLastModifiedDate(System.currentTimeMillis());
    }

    public String getHdfsHost() {
        return this.delegate.getHdfsHost();
    }

    public void setHdfsHost(String hdfsHost) {
        this.delegate.setHdfsHost(hdfsHost);
    }

    public String getHdfsPort() {
        return this.delegate.getHdfsPort();
    }

    public void setHdfsPort(String hdfsPort) {
        this.delegate.setHdfsPort(hdfsPort);
    }

    public String getHdfsUsername() {
        return this.delegate.getHdfsUsername();
    }

    public void setHdfsUsername(String hdfsUsername) {
        this.delegate.setHdfsUsername(hdfsUsername);
    }

    public String getHdfsPassword() {
        return this.delegate.getHdfsPassword();
    }

    public void setHdfsPassword(String hdfsPassword) {
        this.delegate.setHdfsPassword(hdfsPassword);
    }

    public String getJobTrackerHost() {
        return this.delegate.getJobTrackerHost();
    }

    public void setJobTrackerHost(String jobTrackerHost) {
        this.delegate.setJobTrackerHost(jobTrackerHost);
    }

    public String getJobTrackerPort() {
        return this.delegate.getJobTrackerPort();
    }

    public void setJobTrackerPort(String jobTrackerPort) {
        this.delegate.setJobTrackerPort(jobTrackerPort);
    }

    public String getZooKeeperHost() {
        return this.delegate.getZooKeeperHost();
    }

    public void setZooKeeperHost(String zooKeeperHost) {
        this.delegate.setZooKeeperHost(zooKeeperHost);
    }

    public String getZooKeeperPort() {
        return this.delegate.getZooKeeperPort();
    }

    public void setZooKeeperPort(String zooKeeperPort) {
        this.delegate.setZooKeeperPort(zooKeeperPort);
    }

    public String getOozieUrl() {
        return this.delegate.getOozieUrl();
    }

    public void setOozieUrl(String oozieUrl) {
        this.delegate.setOozieUrl(oozieUrl);
    }

    public long getLastModifiedDate() {
        return this.delegate.getLastModifiedDate();
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.delegate.setLastModifiedDate(lastModifiedDate);
    }

    public boolean isMapr() {
        return this.delegate.isMapr();
    }

    public void setMapr(boolean mapr) {
        this.delegate.setMapr(mapr);
    }

    public org.pentaho.big.data.api.cluster.NamedCluster clone() {
        return new NamedClusterBridgeImpl(this.delegate.clone());
    }

    public String processURLsubstitution(String incomingURL, IMetaStore metastore, VariableSpace variableSpace) {
        if (this.isMapr()) {
            String url = this.namedClusterManager.processURLsubstitution(this.getName(), incomingURL, "maprfs", metastore, variableSpace);
            if (url != null && !url.startsWith("maprfs")) {
                url = "maprfs://" + url;
            }
            return url;
        }
        return this.namedClusterManager.processURLsubstitution(this.getName(), incomingURL, "hdfs", metastore, variableSpace);
    }

    public void initializeVariablesFrom(VariableSpace variableSpace) {
        this.delegate.initializeVariablesFrom(variableSpace);
    }

    public void copyVariablesFrom(VariableSpace variableSpace) {
        this.delegate.copyVariablesFrom(variableSpace);
    }

    public void shareVariablesWith(VariableSpace variableSpace) {
        this.delegate.shareVariablesWith(variableSpace);
    }

    public VariableSpace getParentVariableSpace() {
        return this.delegate.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace variableSpace) {
        this.delegate.setParentVariableSpace(variableSpace);
    }

    public void setVariable(String s, String s1) {
        this.delegate.setVariable(s, s1);
    }

    public String getVariable(String s, String s1) {
        return this.delegate.getVariable(s, s1);
    }

    public String getVariable(String s) {
        return this.delegate.getVariable(s);
    }

    public boolean getBooleanValueOfVariable(String s, boolean b) {
        return this.delegate.getBooleanValueOfVariable(s, b);
    }

    public String[] listVariables() {
        return this.delegate.listVariables();
    }

    public String environmentSubstitute(String s) {
        return this.delegate.environmentSubstitute(s);
    }

    public String[] environmentSubstitute(String[] strings) {
        return this.delegate.environmentSubstitute(strings);
    }

    public void injectVariables(Map<String, String> map) {
        this.delegate.injectVariables(map);
    }

    public String fieldSubstitute(String s, RowMetaInterface rowMetaInterface, Object[] objects) throws KettleValueException {
        return this.delegate.fieldSubstitute(s, rowMetaInterface, objects);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

