/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.command;

import de.simplicit.vjdbc.command.Command;
import de.simplicit.vjdbc.command.ConnectionContext;
import de.simplicit.vjdbc.serial.SerializableTransport;
import de.simplicit.vjdbc.serial.StreamSerializer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.SQLException;

public class CallableStatementGetCharacterStreamCommand
implements Command {
    static final long serialVersionUID = 3594832624574651235L;
    private int _index;
    private String _parameterName;

    public CallableStatementGetCharacterStreamCommand() {
    }

    public CallableStatementGetCharacterStreamCommand(int index) {
        this._index = index;
    }

    public CallableStatementGetCharacterStreamCommand(String paramName) {
        this._parameterName = paramName;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._index);
        out.writeObject(this._parameterName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._index = in.readInt();
        this._parameterName = (String)in.readObject();
    }

    @Override
    public Object execute(Object target, ConnectionContext ctx) throws SQLException {
        CallableStatement cstmt = (CallableStatement)target;
        Reader result = this._parameterName != null ? cstmt.getCharacterStream(this._parameterName) : cstmt.getCharacterStream(this._index);
        try {
            return new SerializableTransport(StreamSerializer.toCharArray(result), ctx.getCompressionMode(), ctx.getCompressionThreshold());
        }
        catch (IOException ioe) {
            throw new SQLException(ioe);
        }
    }

    public String toString() {
        return "CallableStatementGetCharacterStreamCommand";
    }
}

