/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.LoadFuncMetadataWrapper;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.JarManager;

public class ParquetLoader
extends LoadFuncMetadataWrapper
implements LoadPushDown {
    public ParquetLoader() throws FrontendException {
        this(null);
    }

    public ParquetLoader(String requestedSchemaStr) throws FrontendException {
        Throwable exception = null;
        try {
            Class<?> parquetLoader = Class.forName("parquet.pig.ParquetLoader");
            Constructor<?> constructor = parquetLoader.getConstructor(String.class);
            this.init((LoadMetadata)constructor.newInstance(requestedSchemaStr));
        }
        catch (NoClassDefFoundError e) {
            exception = e;
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        catch (NoSuchMethodException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        catch (InstantiationException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        if (exception != null) {
            throw new FrontendException(String.format("Cannot instantiate class %s (%s)", this.getClass().getName(), "parquet.pig.ParquetLoader"), 2259, exception);
        }
    }

    private void init(LoadMetadata loadMetadata) {
        this.setLoadFunc(loadMetadata);
    }

    @Override
    public void setLocation(String location, Job job) throws IOException {
        try {
            JarManager.addDependencyJars(job, Class.forName("parquet.Version.class"));
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Runtime parquet dependency not found", e);
        }
        super.setLocation(location, job);
    }

    @Override
    public List<LoadPushDown.OperatorSet> getFeatures() {
        return ((LoadPushDown)((Object)super.loadFunc())).getFeatures();
    }

    @Override
    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        return ((LoadPushDown)((Object)super.loadFunc())).pushProjection(requiredFieldList);
    }
}

