/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.parser;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.RecognitionException;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.LoadFunc;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.builtin.Assert;
import org.apache.pig.builtin.CubeDimensions;
import org.apache.pig.builtin.InvokerGenerator;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.builtin.RANDOM;
import org.apache.pig.builtin.RollupDimensions;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.streaming.StreamingCommand;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.StringUtils;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.expression.BinCondExpression;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.LessThanExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.NotExpression;
import org.apache.pig.newplan.logical.expression.OrExpression;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;
import org.apache.pig.newplan.logical.optimizer.SchemaResetter;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LOCube;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LOLoad;
import org.apache.pig.newplan.logical.relational.LONative;
import org.apache.pig.newplan.logical.relational.LORank;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOSplitOutput;
import org.apache.pig.newplan.logical.relational.LOStore;
import org.apache.pig.newplan.logical.relational.LOStream;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.logical.rules.OptimizerUtils;
import org.apache.pig.newplan.logical.visitor.ProjStarInUdfExpander;
import org.apache.pig.newplan.logical.visitor.ProjectStarExpander;
import org.apache.pig.newplan.logical.visitor.ResetProjectionAttachedRelationalOpVisitor;
import org.apache.pig.parser.FunctionType;
import org.apache.pig.parser.InvalidCommandException;
import org.apache.pig.parser.InvalidPathException;
import org.apache.pig.parser.NonProjectExpressionException;
import org.apache.pig.parser.ParserException;
import org.apache.pig.parser.ParserValidationException;
import org.apache.pig.parser.PlanGenerationFailureException;
import org.apache.pig.parser.QueryParserUtils;
import org.apache.pig.parser.SourceLocation;
import org.apache.pig.parser.StreamingCommandUtils;

public class LogicalPlanBuilder {
    private LogicalPlan plan = new LogicalPlan();
    private String lastRel = null;
    private Map<String, Operator> operators = new HashMap<String, Operator>(){

        @Override
        public Operator put(String k, Operator v) {
            LogicalPlanBuilder.this.lastRel = k;
            return super.put(k, v);
        }
    };
    Map<String, String> fileNameMap;
    private PigContext pigContext = null;
    private String scope = null;
    private IntStream intStream;
    private int storeIndex = 0;
    private int loadIndex = 0;
    private static NodeIdGenerator nodeIdGen = NodeIdGenerator.getGenerator();

    public static long getNextId(String scope) {
        return nodeIdGen.getNextNodeId(scope);
    }

    LogicalPlanBuilder(PigContext pigContext, String scope, Map<String, String> fileNameMap, IntStream input) {
        this.pigContext = pigContext;
        this.scope = scope;
        this.fileNameMap = fileNameMap;
        this.intStream = input;
    }

    LogicalPlanBuilder(IntStream input) throws ExecException {
        this.pigContext = new PigContext(ExecType.LOCAL, new Properties());
        this.pigContext.connect();
        this.scope = "test";
        this.fileNameMap = new HashMap<String, String>();
        this.intStream = input;
    }

    Operator lookupOperator(String alias) {
        return this.operators.get(alias);
    }

    FuncSpec lookupFunction(String alias) {
        return this.pigContext.getFuncSpecFromAlias(alias);
    }

    StreamingCommand lookupCommand(String alias) {
        return this.pigContext.getCommandForAlias(alias);
    }

    void defineCommand(String alias, StreamingCommand command) {
        this.pigContext.registerStreamCmd(alias, command);
    }

    void defineFunction(String alias, FuncSpec fs) {
        this.pigContext.registerFunction(alias, fs);
    }

    LogicalPlan getPlan() {
        return this.plan;
    }

    Map<String, Operator> getOperators() {
        return this.operators;
    }

    LOFilter createFilterOp() {
        return new LOFilter(this.plan);
    }

    LOLimit createLimitOp() {
        return new LOLimit(this.plan);
    }

    LOFilter createSampleOp() {
        return new LOFilter(this.plan, true);
    }

    String buildFilterOp(SourceLocation loc, LOFilter op, String alias, String inputAlias, LogicalExpressionPlan expr) throws ParserValidationException {
        op.setFilterPlan(expr);
        alias = this.buildOp(loc, (LogicalRelationalOperator)op, alias, inputAlias, null);
        try {
            new ProjStarInUdfExpander(op.getPlan()).visit(op);
            new SchemaResetter(op.getPlan(), true).visit(op);
        }
        catch (FrontendException e) {
            throw new ParserValidationException(this.intStream, loc, e);
        }
        return alias;
    }

    String buildDistinctOp(SourceLocation loc, String alias, String inputAlias, String partitioner) throws ParserValidationException {
        LODistinct op = new LODistinct(this.plan);
        return this.buildOp(loc, (LogicalRelationalOperator)op, alias, inputAlias, partitioner);
    }

    String buildLimitOp(SourceLocation loc, String alias, String inputAlias, long limit) throws ParserValidationException {
        LOLimit op = new LOLimit(this.plan, limit);
        return this.buildOp(loc, (LogicalRelationalOperator)op, alias, inputAlias, null);
    }

    String buildLimitOp(SourceLocation loc, LOLimit op, String alias, String inputAlias, LogicalExpressionPlan expr) throws ParserValidationException {
        op.setLimitPlan(expr);
        return this.buildOp(loc, (LogicalRelationalOperator)op, alias, inputAlias, null);
    }

    String buildSampleOp(SourceLocation loc, String alias, String inputAlias, double value, SourceLocation valLoc) throws ParserValidationException {
        LogicalExpressionPlan filterPlan = new LogicalExpressionPlan();
        ConstantExpression konst = new ConstantExpression(filterPlan, value);
        konst.setLocation(valLoc);
        UserFuncExpression udf = new UserFuncExpression(filterPlan, new FuncSpec(RANDOM.class.getName()));
        new LessThanExpression(filterPlan, udf, konst);
        LOFilter filter = new LOFilter(this.plan, true);
        return this.buildFilterOp(loc, filter, alias, inputAlias, filterPlan);
    }

    String buildSampleOp(SourceLocation loc, LOFilter filter, String alias, String inputAlias, LogicalExpressionPlan samplePlan, LogicalExpression expr) throws ParserValidationException {
        UserFuncExpression udf = new UserFuncExpression(samplePlan, new FuncSpec(RANDOM.class.getName()));
        new LessThanExpression(samplePlan, udf, expr);
        return this.buildFilterOp(loc, filter, alias, inputAlias, samplePlan);
    }

    String buildUnionOp(SourceLocation loc, String alias, List<String> inputAliases, boolean onSchema) throws ParserValidationException {
        this.checkDuplicateAliases(inputAliases, loc, "UNION");
        LOUnion op = new LOUnion(this.plan, onSchema);
        return this.buildOp(loc, (LogicalRelationalOperator)op, alias, inputAliases, null);
    }

    String buildSplitOp(SourceLocation loc, String inputAlias) throws ParserValidationException {
        LOSplit op = new LOSplit(this.plan);
        return this.buildOp(loc, (LogicalRelationalOperator)op, null, inputAlias, null);
    }

    LOSplitOutput createSplitOutputOp() {
        return new LOSplitOutput(this.plan);
    }

    String buildSplitOutputOp(SourceLocation loc, LOSplitOutput op, String alias, String inputAlias, LogicalExpressionPlan filterPlan) throws ParserValidationException {
        op.setFilterPlan(filterPlan);
        return this.buildOp(loc, (LogicalRelationalOperator)op, alias, inputAlias, null);
    }

    String buildSplitOtherwiseOp(SourceLocation loc, LOSplitOutput op, String alias, String inputAlias) throws ParserValidationException, PlanGenerationFailureException {
        LogicalExpressionPlan splitPlan = new LogicalExpressionPlan();
        Operator losplit = this.lookupOperator(inputAlias);
        LogicalExpression currentExpr = null;
        for (Operator losplitoutput : this.plan.getSuccessors(losplit)) {
            LogicalExpressionPlan fragment = ((LOSplitOutput)losplitoutput).getFilterPlan();
            try {
                if (OptimizerUtils.planHasNonDeterministicUdf(fragment)) {
                    throw new ParserValidationException(this.intStream, loc, new FrontendException(op, "Can not use Otherwise in Split with an expression containing a @Nondeterministic UDF", 1131));
                }
            }
            catch (FrontendException e) {
                e.printStackTrace();
                throw new PlanGenerationFailureException(this.intStream, loc, e);
            }
            LogicalExpression root = null;
            try {
                root = ((LogicalExpression)fragment.getSources().get(0)).deepCopy(splitPlan);
            }
            catch (FrontendException e) {
                e.printStackTrace();
                throw new PlanGenerationFailureException(this.intStream, loc, e);
            }
            if (root == null) {
                throw new PlanGenerationFailureException(this.intStream, loc, new FrontendException(op, "Could not retrieve LogicalExpression for LOSplitOutput " + losplitoutput, 2048));
            }
            if (currentExpr == null) {
                currentExpr = root;
                continue;
            }
            currentExpr = new OrExpression(splitPlan, currentExpr, root);
        }
        currentExpr = new NotExpression(splitPlan, currentExpr);
        try {
            new ResetProjectionAttachedRelationalOpVisitor(splitPlan, op).visit();
        }
        catch (FrontendException e) {
            e.printStackTrace();
            throw new PlanGenerationFailureException(this.intStream, loc, e);
        }
        op.setFilterPlan(splitPlan);
        return this.buildOp(loc, (LogicalRelationalOperator)op, alias, inputAlias, null);
    }

    String buildCrossOp(SourceLocation loc, String alias, List<String> inputAliases, String partitioner) throws ParserValidationException {
        LOCross op = new LOCross(this.plan);
        return this.buildOp(loc, (LogicalRelationalOperator)op, alias, inputAliases, partitioner);
    }

    LOSort createSortOp() {
        return new LOSort(this.plan);
    }

    String buildSortOp(SourceLocation loc, LOSort sort, String alias, String inputAlias, List<LogicalExpressionPlan> plans, List<Boolean> ascFlags, FuncSpec fs) throws ParserValidationException {
        sort.setSortColPlans(plans);
        sort.setUserFunc(fs);
        if (ascFlags.isEmpty()) {
            for (int i = 0; i < plans.size(); ++i) {
                ascFlags.add(true);
            }
        }
        sort.setAscendingCols(ascFlags);
        alias = this.buildOp(loc, (LogicalRelationalOperator)sort, alias, inputAlias, null);
        this.expandAndResetVisitor(loc, sort);
        return alias;
    }

    LORank createRankOp() {
        return new LORank(this.plan);
    }

    String buildRankOp(SourceLocation loc, LORank rank, String alias, String inputAlias, List<LogicalExpressionPlan> plans, List<Boolean> ascFlags) throws ParserValidationException {
        rank.setRankColPlan(plans);
        if (ascFlags.isEmpty()) {
            for (int i = 0; i < plans.size(); ++i) {
                ascFlags.add(true);
            }
        }
        rank.setAscendingCol(ascFlags);
        this.buildOp(loc, (LogicalRelationalOperator)rank, alias, inputAlias, null);
        this.expandAndResetVisitor(loc, rank);
        return alias;
    }

    LOJoin createJoinOp() {
        return new LOJoin(this.plan);
    }

    String buildJoinOp(SourceLocation loc, LOJoin op, String alias, List<String> inputAliases, MultiMap<Integer, LogicalExpressionPlan> joinPlans, LOJoin.JOINTYPE jt, List<Boolean> innerFlags, String partitioner) throws ParserValidationException {
        this.checkDuplicateAliases(inputAliases, loc, "JOIN");
        if (jt == null) {
            jt = LOJoin.JOINTYPE.HASH;
        } else {
            op.pinOption(LOJoin.OPTION_JOIN);
        }
        int inputCount = inputAliases.size();
        if (jt == LOJoin.JOINTYPE.SKEWED) {
            if (partitioner != null) {
                throw new ParserValidationException(this.intStream, loc, "Custom Partitioner is not supported for skewed join");
            }
            if (inputCount != 2) {
                throw new ParserValidationException(this.intStream, loc, "Skewed join can only be applied for 2-way joins");
            }
        } else {
            if ((jt == LOJoin.JOINTYPE.MERGE || jt == LOJoin.JOINTYPE.MERGESPARSE) && inputCount != 2) {
                throw new ParserValidationException(this.intStream, loc, "Merge join can only be applied for 2-way joins");
            }
            if (jt == LOJoin.JOINTYPE.REPLICATED && innerFlags.size() == 2 && !innerFlags.get(0).booleanValue()) {
                throw new ParserValidationException(this.intStream, loc, "Replicated join does not support (right|full) outer joins");
            }
        }
        boolean[] flags = new boolean[joinPlans.size()];
        if (innerFlags.size() != 0) {
            for (int i = 0; i < joinPlans.size(); ++i) {
                flags[i] = innerFlags.get(i);
            }
        } else {
            for (int i = 0; i < joinPlans.size(); ++i) {
                flags[i] = true;
            }
        }
        op.setJoinType(jt);
        op.setInnerFlags(flags);
        op.setJoinPlans(joinPlans);
        alias = this.buildOp(loc, (LogicalRelationalOperator)op, alias, inputAliases, partitioner);
        this.expandAndResetVisitor(loc, op);
        return alias;
    }

    private void expandAndResetVisitor(SourceLocation loc, LogicalRelationalOperator lrop) throws ParserValidationException {
        try {
            new ProjectStarExpander(lrop.getPlan()).visit();
            new ProjStarInUdfExpander(lrop.getPlan()).visit();
            new SchemaResetter(lrop.getPlan(), true).visit();
        }
        catch (FrontendException e) {
            throw new ParserValidationException(this.intStream, loc, e);
        }
    }

    LOCube createCubeOp() {
        return new LOCube(this.plan);
    }

    String buildCubeOp(SourceLocation loc, LOCube op, String alias, String inputAlias, List<String> operations, MultiMap<Integer, LogicalExpressionPlan> expressionPlans) throws ParserValidationException {
        this.combineCubeOperations((ArrayList)operations, expressionPlans);
        op.setExpressionPlans(expressionPlans);
        op.setOperations(operations);
        this.buildOp(loc, (LogicalRelationalOperator)op, alias, inputAlias, null);
        this.expandAndResetVisitor(loc, op);
        try {
            alias = this.convertCubeToFGPlan(loc, op, inputAlias, operations, expressionPlans);
        }
        catch (FrontendException e) {
            throw new ParserValidationException(this.intStream, loc, e);
        }
        return alias;
    }

    private void combineCubeOperations(ArrayList<String> operations, MultiMap<Integer, LogicalExpressionPlan> expressionPlans) {
        int startIdx = -1;
        int endIdx = -1;
        int i = 0;
        boolean isMerged = false;
        for (i = 0; i < operations.size(); ++i) {
            if (startIdx == -1 && operations.get(i).equals("CUBE")) {
                startIdx = i;
                continue;
            }
            if (operations.get(i).equals("CUBE")) {
                endIdx = i;
                continue;
            }
            if (endIdx > startIdx) {
                this.mergeAndMarkForDelete(operations, expressionPlans, startIdx, endIdx);
                isMerged = true;
                startIdx = -1;
                endIdx = -1;
                continue;
            }
            startIdx = -1;
            endIdx = -1;
        }
        if (endIdx > startIdx) {
            isMerged = true;
            this.mergeAndMarkForDelete(operations, expressionPlans, startIdx, endIdx);
        }
        if (isMerged) {
            this.performDeletion(expressionPlans, operations);
        }
    }

    private void performDeletion(MultiMap<Integer, LogicalExpressionPlan> expressionPlans, ArrayList<String> operations) {
        MultiMap<Integer, LogicalExpressionPlan> ep = new MultiMap<Integer, LogicalExpressionPlan>();
        ArrayList<String> op = new ArrayList<String>();
        int idx = 0;
        for (int i = 0; i < operations.size(); ++i) {
            if (operations.get(i) != null) {
                op.add(idx, operations.get(i));
            }
            if (expressionPlans.get(i) == null) continue;
            ep.put(Integer.valueOf(idx), expressionPlans.get(i));
            ++idx;
        }
        operations.clear();
        operations.addAll(op);
        expressionPlans.clear();
        for (Integer i : ep.keySet()) {
            expressionPlans.put(i, ep.get(i));
        }
    }

    private void mergeAndMarkForDelete(ArrayList<String> operations, MultiMap<Integer, LogicalExpressionPlan> expressionPlans, int startIdx, int endIdx) {
        for (int i = startIdx + 1; i <= endIdx; ++i) {
            expressionPlans.put((Integer)startIdx, expressionPlans.get(i));
            expressionPlans.removeKey(i);
            operations.remove(i);
            operations.add(i, null);
        }
    }

    private String convertCubeToFGPlan(SourceLocation loc, LOCube op, String inputAlias, List<String> operations, MultiMap<Integer, LogicalExpressionPlan> expressionPlans) throws FrontendException {
        LOForEach foreach = new LOForEach(this.plan);
        LOCogroup groupby = new LOCogroup(this.plan);
        LogicalPlan innerPlan = new LogicalPlan();
        LOGenerate gen = new LOGenerate(innerPlan);
        this.injectForeachOperator(loc, op, foreach);
        List<Operator> inpOpers = foreach.getPlan().getPredecessors(foreach);
        ArrayList<LogicalExpressionPlan> allExprPlan = new ArrayList<LogicalExpressionPlan>();
        for (Operator oper : inpOpers) {
            LogicalSchema schema = new LogicalSchema();
            schema = ((LogicalRelationalOperator)oper).getSchema();
            if (schema == null) continue;
            ArrayList fields = (ArrayList)schema.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                LogicalExpressionPlan logicalExpressionPlan = new LogicalExpressionPlan();
                new ProjectExpression(logicalExpressionPlan, i, ((LogicalSchema.LogicalFieldSchema)fields.get((int)i)).alias, null, gen);
                allExprPlan.add(logicalExpressionPlan);
            }
        }
        for (int operIdx = 0; operIdx < operations.size(); ++operIdx) {
            ArrayList<LogicalExpressionPlan> lexpPlanList = new ArrayList<LogicalExpressionPlan>();
            List<Object> lexpList = new ArrayList();
            lexpPlanList.addAll(expressionPlans.get(operIdx));
            this.checkDuplicateProject(lexpPlanList);
            lexpList = this.getProjectExpList(lexpPlanList, gen);
            for (int i = 0; i < lexpList.size(); ++i) {
                for (int j = 0; j < allExprPlan.size(); ++j) {
                    LogicalExpression logicalExpression = (LogicalExpression)((LogicalExpressionPlan)allExprPlan.get(j)).getSources().get(0);
                    String colAlias = ((ProjectExpression)lexpList.get(i)).getColAlias();
                    if (colAlias == null) {
                        colAlias = ((ProjectExpression)lexpList.get((int)i)).getFieldSchema().alias;
                    }
                    String projExpAlias = null;
                    try {
                        projExpAlias = ((ProjectExpression)logicalExpression).getColAlias();
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                    if (colAlias.equals(projExpAlias)) {
                        allExprPlan.remove(j);
                        continue;
                    }
                    if (projExpAlias.lastIndexOf(":") == -1 || !colAlias.equals(projExpAlias = projExpAlias.substring(projExpAlias.lastIndexOf(":") + 1, projExpAlias.length()))) continue;
                    allExprPlan.remove(j);
                }
            }
            LogicalExpressionPlan uexpPlan = new LogicalExpressionPlan();
            if (operations.get(operIdx).equals("CUBE")) {
                new UserFuncExpression((OperatorPlan)uexpPlan, new FuncSpec(CubeDimensions.class.getName()), lexpList);
            } else {
                new UserFuncExpression((OperatorPlan)uexpPlan, new FuncSpec(RollupDimensions.class.getName()), lexpList);
            }
            for (LogicalExpressionPlan logicalExpressionPlan : lexpPlanList) {
                Iterator<Operator> it = logicalExpressionPlan.getOperators();
                while (it.hasNext()) {
                    uexpPlan.add(it.next());
                }
            }
            allExprPlan.add(operIdx, uexpPlan);
        }
        ArrayList<Boolean> flattenFlags = new ArrayList<Boolean>();
        for (int idx = 0; idx < allExprPlan.size(); ++idx) {
            List<Operator> opers = ((LogicalExpressionPlan)allExprPlan.get(idx)).getSources();
            for (Operator oper : opers) {
                if (oper instanceof ProjectExpression) {
                    flattenFlags.add(false);
                    continue;
                }
                if (!(oper instanceof UserFuncExpression)) continue;
                flattenFlags.add(true);
            }
        }
        String falias = null;
        try {
            this.buildGenerateOp(loc, foreach, gen, allExprPlan, flattenFlags, this.getUserDefinedSchema(allExprPlan));
            falias = this.buildForeachOp(loc, foreach, "cube", inputAlias, innerPlan);
        }
        catch (ParserValidationException pve) {
            throw new FrontendException((Throwable)((Object)pve));
        }
        ArrayList<Boolean> innerFlags = new ArrayList<Boolean>();
        ArrayList<String> inpAliases = new ArrayList<String>();
        inpAliases.add(falias);
        innerFlags.add(false);
        MultiMap<Integer, LogicalExpressionPlan> exprPlansCopy = new MultiMap<Integer, LogicalExpressionPlan>();
        for (LogicalExpressionPlan exp : expressionPlans.values()) {
            LogicalExpression lexp = (LogicalExpression)exp.getSources().get(0);
            LogicalExpressionPlan epGrp = new LogicalExpressionPlan();
            new ProjectExpression(epGrp, 0, lexp.getFieldSchema().alias, null, groupby);
            exprPlansCopy.put((Integer)0, epGrp);
        }
        try {
            return this.buildGroupOp(loc, groupby, op.getAlias(), inpAliases, exprPlansCopy, LOCogroup.GROUPTYPE.REGULAR, innerFlags, null);
        }
        catch (ParserValidationException parserValidationException) {
            throw new FrontendException((Throwable)((Object)parserValidationException));
        }
    }

    private List<LogicalSchema> getUserDefinedSchema(List<LogicalExpressionPlan> allExprPlan) throws FrontendException {
        ArrayList<LogicalSchema> genOutputSchema = new ArrayList<LogicalSchema>();
        for (int i = 0; i < allExprPlan.size(); ++i) {
            List<Operator> opers = allExprPlan.get(i).getSources();
            for (Operator oper : opers) {
                LogicalSchema output;
                if (oper instanceof ProjectExpression) {
                    output = new LogicalSchema();
                    output.addField(new LogicalSchema.LogicalFieldSchema(((ProjectExpression)oper).getColAlias(), null, 1));
                    genOutputSchema.add(output);
                    continue;
                }
                if (!(oper instanceof UserFuncExpression)) continue;
                output = new LogicalSchema();
                for (Operator op : ((UserFuncExpression)oper).getPlan().getSinks()) {
                    output.addField(new LogicalSchema.LogicalFieldSchema(((ProjectExpression)op).getFieldSchema()));
                }
                genOutputSchema.add(output);
            }
        }
        return genOutputSchema;
    }

    private List<LogicalExpression> getProjectExpList(List<LogicalExpressionPlan> lexpPlanList, LogicalRelationalOperator lro) throws FrontendException {
        ArrayList<LogicalExpression> leList = new ArrayList<LogicalExpression>();
        for (int i = 0; i < lexpPlanList.size(); ++i) {
            LogicalExpressionPlan lexp = lexpPlanList.get(i);
            LogicalExpression lex = (LogicalExpression)lexp.getSources().get(0);
            Iterator<Operator> opers = lexp.getOperators();
            while (opers.hasNext()) {
                Operator oper = opers.next();
                try {
                    ((ProjectExpression)oper).setAttachedRelationalOp(lro);
                }
                catch (ClassCastException cce) {
                    throw new FrontendException("Column project expected.", cce);
                }
            }
            leList.add(lex);
        }
        return leList;
    }

    private void injectForeachOperator(SourceLocation loc, LOCube op, LOForEach foreach) throws FrontendException {
        List<Operator> opers = op.getPlan().getPredecessors(op);
        for (Operator oper : opers) {
            OperatorPlan foreachPlan = foreach.getPlan();
            foreachPlan.connect(oper, foreach);
        }
        opers = foreach.getPlan().getPredecessors(foreach);
        for (Operator lop : opers) {
            List<Operator> succs = lop.getPlan().getSuccessors(lop);
            for (Operator succ : succs) {
                if (!(succ instanceof LOCube)) continue;
                succ.getPlan().disconnect(lop, succ);
                succ.getPlan().remove(succ);
            }
        }
    }

    private void checkDuplicateProject(List<LogicalExpressionPlan> lExprPlan) throws FrontendException {
        for (int i = 0; i < lExprPlan.size(); ++i) {
            for (int j = i + 1; j < lExprPlan.size(); ++j) {
                LogicalExpression outer = (LogicalExpression)lExprPlan.get(i).getSources().get(0);
                LogicalExpression inner = (LogicalExpression)lExprPlan.get(j).getSources().get(0);
                String outColAlias = ((ProjectExpression)outer).getColAlias();
                String inColAlias = ((ProjectExpression)inner).getColAlias();
                if (outColAlias == null) {
                    outColAlias = outer.getFieldSchema().alias;
                }
                if (inColAlias == null) {
                    inColAlias = inner.getFieldSchema().alias;
                }
                if (!outColAlias.equals(inColAlias)) continue;
                lExprPlan.remove(j);
                throw new FrontendException("Duplicate dimensions detected. Dimension name: " + inColAlias);
            }
        }
    }

    LOCogroup createGroupOp() {
        return new LOCogroup(this.plan);
    }

    String buildGroupOp(SourceLocation loc, LOCogroup op, String alias, List<String> inputAliases, MultiMap<Integer, LogicalExpressionPlan> expressionPlans, LOCogroup.GROUPTYPE gt, List<Boolean> innerFlags, String partitioner) throws ParserValidationException {
        if (gt == LOCogroup.GROUPTYPE.COLLECTED) {
            if (inputAliases.size() > 1) {
                throw new ParserValidationException(this.intStream, loc, "Collected group is only supported for single input");
            }
            List<LogicalExpressionPlan> exprPlans = expressionPlans.get(0);
            for (LogicalExpressionPlan exprPlan : exprPlans) {
                Iterator<Operator> it = exprPlan.getOperators();
                while (it.hasNext()) {
                    if (it.next() instanceof ProjectExpression) continue;
                    throw new ParserValidationException(this.intStream, loc, "Collected group is only supported for columns or star projection");
                }
            }
        }
        boolean[] flags = new boolean[innerFlags.size()];
        for (int i = 0; i < innerFlags.size(); ++i) {
            flags[i] = innerFlags.get(i);
        }
        op.setExpressionPlans(expressionPlans);
        op.setGroupType(gt);
        op.setInnerFlags(flags);
        alias = this.buildOp(loc, (LogicalRelationalOperator)op, alias, inputAliases, partitioner);
        this.expandAndResetVisitor(loc, op);
        return alias;
    }

    String buildLoadOp(SourceLocation loc, String alias, String filename, FuncSpec funcSpec, LogicalSchema schema) throws ParserValidationException {
        String absolutePath;
        LoadFunc loFunc;
        try {
            funcSpec = funcSpec == null ? new FuncSpec(this.pigContext.getProperties().getProperty("pig.default.load.func", PigStorage.class.getName())) : funcSpec;
            loFunc = (LoadFunc)PigContext.instantiateFuncFromSpec(funcSpec);
            String fileNameKey = QueryParserUtils.constructFileNameSignature(filename, funcSpec) + "_" + this.loadIndex++;
            absolutePath = this.fileNameMap.get(fileNameKey);
            if (absolutePath == null) {
                absolutePath = loFunc.relativeToAbsolutePath(filename, QueryParserUtils.getCurrentDir(this.pigContext));
                if (absolutePath != null) {
                    QueryParserUtils.setHdfsServers(absolutePath, this.pigContext);
                }
                this.fileNameMap.put(fileNameKey, absolutePath);
            }
        }
        catch (Exception ex) {
            throw new ParserValidationException(this.intStream, loc, ex);
        }
        FileSpec loader = new FileSpec(absolutePath, funcSpec);
        LOLoad op = new LOLoad(loader, schema, this.plan, ConfigurationUtil.toConfiguration(this.pigContext.getProperties()), loFunc, alias + "_" + this.newOperatorKey());
        op.setTmpLoad(false);
        return this.buildOp(loc, (LogicalRelationalOperator)op, alias, new ArrayList<String>(), null);
    }

    private String buildOp(SourceLocation loc, LogicalRelationalOperator op, String alias, String inputAlias, String partitioner) throws ParserValidationException {
        ArrayList<String> inputAliases = new ArrayList<String>();
        if (inputAlias != null) {
            inputAliases.add(inputAlias);
        }
        return this.buildOp(loc, op, alias, inputAliases, partitioner);
    }

    private void checkDuplicateAliases(List<String> inputAliases, SourceLocation loc, String opName) throws ParserValidationException {
        HashMap<Operator, Integer> inputAliasesMap = new HashMap<Operator, Integer>();
        for (String a : inputAliases) {
            Operator pred = this.operators.get(a);
            if (pred == null) {
                throw new ParserValidationException(this.intStream, loc, "Unrecognized alias " + a);
            }
            if (inputAliasesMap.containsKey(pred)) {
                throw new ParserValidationException(this.intStream, loc, "Pig does not accept same alias as input for " + opName + " operation : " + a);
            }
            inputAliasesMap.put(pred, 1);
        }
    }

    private String buildOp(SourceLocation loc, LogicalRelationalOperator op, String alias, List<String> inputAliases, String partitioner) throws ParserValidationException {
        this.setAlias(op, alias);
        LogicalPlanBuilder.setPartitioner(op, partitioner);
        op.setLocation(loc);
        this.plan.add(op);
        for (String a : inputAliases) {
            Operator pred = this.operators.get(a);
            if (pred == null) {
                throw new ParserValidationException(this.intStream, loc, "Unrecognized alias " + a);
            }
            this.plan.connect(pred, op);
        }
        this.operators.put(op.getAlias(), op);
        this.pigContext.setLastAlias(op.getAlias());
        return op.getAlias();
    }

    String buildStoreOp(SourceLocation loc, String alias, String inputAlias, String filename, FuncSpec funcSpec) throws ParserValidationException {
        try {
            funcSpec = funcSpec == null ? new FuncSpec(this.pigContext.getProperties().getProperty("pig.default.store.func", PigStorage.class.getName())) : funcSpec;
            StoreFuncInterface stoFunc = (StoreFuncInterface)PigContext.instantiateFuncFromSpec(funcSpec);
            String fileNameKey = inputAlias + "_" + this.storeIndex++;
            String signature = inputAlias + "_" + this.newOperatorKey();
            stoFunc.setStoreFuncUDFContextSignature(signature);
            String absolutePath = this.fileNameMap.get(fileNameKey);
            if (absolutePath == null) {
                absolutePath = stoFunc.relToAbsPathForStoreLocation(filename, QueryParserUtils.getCurrentDir(this.pigContext));
                if (absolutePath != null) {
                    QueryParserUtils.setHdfsServers(absolutePath, this.pigContext);
                }
                this.fileNameMap.put(fileNameKey, absolutePath);
            }
            FileSpec fileSpec = new FileSpec(absolutePath, funcSpec);
            LOStore op = new LOStore(this.plan, fileSpec, stoFunc, signature);
            return this.buildOp(loc, (LogicalRelationalOperator)op, alias, inputAlias, null);
        }
        catch (Exception ex) {
            throw new ParserValidationException(this.intStream, loc, ex);
        }
    }

    String buildAssertOp(SourceLocation loc, LOFilter filterOp, String alias, String inputAlias, LogicalExpression expr, String comment, LogicalExpressionPlan exprPlan) throws ParserValidationException {
        try {
            filterOp.setAlias(inputAlias);
            ArrayList<LogicalExpression> args = new ArrayList<LogicalExpression>();
            ConstantExpression lhs = new ConstantExpression(exprPlan, new Boolean(true));
            ConstantExpression rhs = new ConstantExpression(exprPlan, new Boolean(false));
            BinCondExpression binCond = new BinCondExpression(exprPlan, expr, lhs, rhs);
            args.add(binCond);
            ConstantExpression constExpr = new ConstantExpression(exprPlan, comment == null ? "" : comment);
            args.add(constExpr);
            UserFuncExpression udf = new UserFuncExpression((OperatorPlan)exprPlan, new FuncSpec(Assert.class.getName()), args);
            exprPlan.add(udf);
            filterOp.setFilterPlan(exprPlan);
            return this.buildFilterOp(loc, filterOp, inputAlias, inputAlias, exprPlan);
        }
        catch (Exception ex) {
            throw new ParserValidationException(this.intStream, loc, ex);
        }
    }

    private String newOperatorKey() {
        return new OperatorKey(this.scope, this.getNextId()).toString();
    }

    public static String newOperatorKey(String scope) {
        return new OperatorKey(scope, LogicalPlanBuilder.getNextId(scope)).toString();
    }

    LOForEach createForeachOp() {
        return new LOForEach(this.plan);
    }

    String buildForeachOp(SourceLocation loc, LOForEach op, String alias, String inputAlias, LogicalPlan innerPlan) throws ParserValidationException {
        op.setInnerPlan(innerPlan);
        alias = this.buildOp(loc, (LogicalRelationalOperator)op, alias, inputAlias, null);
        this.expandAndResetVisitor(loc, op);
        return alias;
    }

    LOGenerate createGenerateOp(LogicalPlan plan) {
        return new LOGenerate(plan);
    }

    void buildGenerateOp(SourceLocation loc, LOForEach foreach, LOGenerate gen, List<LogicalExpressionPlan> exprPlans, List<Boolean> flattenFlags, List<LogicalSchema> schemas) throws ParserValidationException {
        boolean[] flags = new boolean[flattenFlags.size()];
        for (int i = 0; i < flattenFlags.size(); ++i) {
            flags[i] = flattenFlags.get(i);
        }
        LogicalPlan innerPlan = (LogicalPlan)gen.getPlan();
        ArrayList<Operator> inputs = new ArrayList<Operator>();
        int idx = 0;
        for (LogicalExpressionPlan exprPlan : exprPlans) {
            LogicalExpression expr = (LogicalExpression)exprPlan.getSources().get(0);
            LogicalSchema userSchema = schemas.get(idx);
            if (userSchema == null && expr.hasFieldSchema()) {
                LogicalSchema ls = new LogicalSchema();
                try {
                    ls.addField(expr.getFieldSchema());
                    schemas.set(idx, ls);
                }
                catch (FrontendException e) {
                    // empty catch block
                }
            }
            ++idx;
            try {
                LogicalPlanBuilder.processExpressionPlan(foreach, innerPlan, exprPlan, inputs);
            }
            catch (FrontendException e) {
                throw new ParserValidationException(this.intStream, loc, e);
            }
        }
        gen.setOutputPlans(exprPlans);
        gen.setFlattenFlags(flags);
        gen.setUserDefinedSchema(schemas);
        innerPlan.add(gen);
        gen.setLocation(loc);
        for (Operator input : inputs) {
            innerPlan.connect(input, gen);
        }
    }

    private static void processExpressionPlan(LOForEach foreach, LogicalPlan lp, LogicalExpressionPlan plan, ArrayList<Operator> inputs) throws FrontendException {
        Iterator<Operator> it = plan.getOperators();
        while (it.hasNext()) {
            LOInnerLoad innerLoad;
            Operator sink = it.next();
            if (!(sink instanceof ProjectExpression)) continue;
            ProjectExpression projExpr = (ProjectExpression)sink;
            String colAlias = projExpr.getColAlias();
            if (projExpr.isRangeProject()) {
                innerLoad = new LOInnerLoad(lp, foreach, new ProjectExpression(projExpr, (OperatorPlan)new LogicalExpressionPlan()));
                LogicalPlanBuilder.setupInnerLoadAndProj(innerLoad, projExpr, lp, inputs);
                continue;
            }
            if (colAlias != null) {
                Operator op = projExpr.getProjectedOperator();
                if (op != null) {
                    int index = inputs.indexOf(op);
                    if (index == -1) {
                        index = inputs.size();
                        inputs.add(op);
                    }
                    projExpr.setInputNum(index);
                    projExpr.setColNum(-1);
                    continue;
                }
                LOInnerLoad innerLoad2 = new LOInnerLoad((OperatorPlan)lp, foreach, colAlias);
                LogicalPlanBuilder.setupInnerLoadAndProj(innerLoad2, projExpr, lp, inputs);
                continue;
            }
            innerLoad = new LOInnerLoad((OperatorPlan)lp, foreach, projExpr.getColNum());
            LogicalPlanBuilder.setupInnerLoadAndProj(innerLoad, projExpr, lp, inputs);
        }
    }

    private static void setupInnerLoadAndProj(LOInnerLoad innerLoad, ProjectExpression projExpr, LogicalPlan lp, ArrayList<Operator> inputs) {
        innerLoad.setLocation(projExpr.getLocation());
        projExpr.setInputNum(inputs.size());
        projExpr.setColNum(-1);
        lp.add(innerLoad);
        inputs.add(innerLoad);
    }

    Operator buildNestedOperatorInput(SourceLocation loc, LogicalPlan innerPlan, LOForEach foreach, Map<String, Operator> operators, LogicalExpression expr) throws NonProjectExpressionException, ParserValidationException {
        OperatorPlan plan = expr.getPlan();
        Iterator<Operator> it = plan.getOperators();
        if (!(it.next() instanceof ProjectExpression) || it.hasNext()) {
            throw new NonProjectExpressionException(this.intStream, loc, expr);
        }
        Operator op = null;
        ProjectExpression projExpr = (ProjectExpression)expr;
        String colAlias = projExpr.getColAlias();
        if (colAlias != null) {
            op = operators.get(colAlias);
            if (op == null) {
                op = this.createInnerLoad(loc, innerPlan, foreach, colAlias);
                op.setLocation(projExpr.getLocation());
                innerPlan.add(op);
            }
        } else {
            op = new LOInnerLoad((OperatorPlan)innerPlan, foreach, projExpr.getColNum());
            op.setLocation(projExpr.getLocation());
            innerPlan.add(op);
        }
        return op;
    }

    private LOInnerLoad createInnerLoad(SourceLocation loc, LogicalPlan innerPlan, LOForEach foreach, String colAlias) throws ParserValidationException {
        try {
            return new LOInnerLoad((OperatorPlan)innerPlan, foreach, colAlias);
        }
        catch (FrontendException e) {
            throw new ParserValidationException(this.intStream, loc, e);
        }
    }

    StreamingCommand buildCommand(SourceLocation loc, String cmd, List<String> shipPaths, List<String> cachePaths, List<StreamingCommand.HandleSpec> inputHandleSpecs, List<StreamingCommand.HandleSpec> outputHandleSpecs, String logDir, Integer limit) throws RecognitionException {
        StreamingCommand command = null;
        try {
            command = this.buildCommand(loc, cmd);
            if (shipPaths != null) {
                if (shipPaths.size() == 0) {
                    command.setShipFiles(false);
                } else {
                    for (String path : shipPaths) {
                        command.addPathToShip(path);
                    }
                }
            }
            if (cachePaths != null) {
                for (String path : cachePaths) {
                    command.addPathToCache(path);
                }
            }
            if (inputHandleSpecs != null) {
                for (StreamingCommand.HandleSpec spec : inputHandleSpecs) {
                    command.addHandleSpec(StreamingCommand.Handle.INPUT, spec);
                }
            }
            if (outputHandleSpecs != null) {
                for (StreamingCommand.HandleSpec spec : outputHandleSpecs) {
                    command.addHandleSpec(StreamingCommand.Handle.OUTPUT, spec);
                }
            }
            if (logDir != null) {
                command.setLogDir(logDir);
            }
            if (limit != null) {
                command.setLogFilesLimit(limit);
            }
        }
        catch (IOException e) {
            throw new PlanGenerationFailureException(this.intStream, loc, e);
        }
        return command;
    }

    StreamingCommand buildCommand(SourceLocation loc, String cmd) throws RecognitionException {
        try {
            String[] args = StreamingCommandUtils.splitArgs(cmd);
            StreamingCommand command = new StreamingCommand(this.pigContext, args);
            StreamingCommandUtils validator = new StreamingCommandUtils(this.pigContext);
            validator.checkAutoShipSpecs(command, args);
            return command;
        }
        catch (ParserException e) {
            throw new InvalidCommandException(this.intStream, loc, cmd);
        }
    }

    String buildStreamOp(SourceLocation loc, String alias, String inputAlias, StreamingCommand command, LogicalSchema schema, IntStream input) throws RecognitionException {
        try {
            LOStream op = new LOStream(this.plan, this.pigContext.createExecutableManager(), command, schema);
            return this.buildOp(loc, (LogicalRelationalOperator)op, alias, inputAlias, null);
        }
        catch (ExecException ex) {
            throw new PlanGenerationFailureException(input, loc, ex);
        }
    }

    String buildNativeOp(SourceLocation loc, String inputJar, String cmd, List<String> paths, String storeAlias, String loadAlias, IntStream input) throws RecognitionException {
        try {
            LONative op = new LONative(this.plan, inputJar, StreamingCommandUtils.splitArgs(cmd));
            this.pigContext.addJar(inputJar);
            for (String path : paths) {
                this.pigContext.addJar(path);
            }
            this.buildOp(loc, (LogicalRelationalOperator)op, null, new ArrayList<String>(), null);
            ((LOStore)this.operators.get(storeAlias)).setTmpStore(true);
            this.plan.connect(this.operators.get(storeAlias), op);
            LOLoad load = (LOLoad)this.operators.get(loadAlias);
            this.plan.connect(op, load);
            return load.getAlias();
        }
        catch (ParserException e) {
            throw new InvalidCommandException(input, loc, cmd);
        }
        catch (MalformedURLException e) {
            throw new InvalidPathException(input, loc, e);
        }
    }

    void setAlias(LogicalRelationalOperator op, String alias) {
        if (alias == null) {
            alias = this.newOperatorKey();
        }
        op.setAlias(alias);
    }

    void setParallel(LogicalRelationalOperator op, Integer parallel) {
        if (parallel != null) {
            op.setRequestedParallelism(this.pigContext.getExecType() == ExecType.LOCAL ? 1 : parallel);
        }
    }

    static void setPartitioner(LogicalRelationalOperator op, String partitioner) {
        if (partitioner != null) {
            op.setCustomPartitioner(partitioner);
        }
    }

    FuncSpec buildFuncSpec(SourceLocation loc, String funcName, List<String> args, byte ft) throws RecognitionException {
        String[] argArray = new String[args.size()];
        FuncSpec funcSpec = new FuncSpec(funcName, args.size() == 0 ? null : args.toArray(argArray));
        this.validateFuncSpec(loc, funcSpec, ft);
        return funcSpec;
    }

    private void validateFuncSpec(SourceLocation loc, FuncSpec funcSpec, byte ft) throws RecognitionException {
        switch (ft) {
            case 4: 
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                try {
                    Class func = PigContext.resolveClassName(funcSpec.getClassName());
                    FunctionType.tryCasting(func, ft);
                    break;
                }
                catch (Exception ex) {
                    throw new ParserValidationException(this.intStream, loc, ex);
                }
            }
        }
    }

    static String unquote(String s) {
        return StringUtils.unescapeInputString(s.substring(1, s.length() - 1));
    }

    static int undollar(String s) {
        return Integer.parseInt(s.substring(1, s.length()));
    }

    static long parseLong(String s) {
        String num = s.substring(0, s.length() - 1);
        return Long.parseLong(num);
    }

    static BigInteger parseBigInteger(String s) {
        String num = s.substring(0, s.length() - 1);
        return new BigInteger(num);
    }

    static BigDecimal parseBigDecimal(String s) {
        String num = s.substring(0, s.length() - 1);
        return new BigDecimal(num);
    }

    static Tuple buildTuple(List<Object> objList) {
        TupleFactory tf = TupleFactory.getInstance();
        return tf.newTuple(objList);
    }

    static DataBag createDataBag() {
        BagFactory bagFactory = BagFactory.getInstance();
        return bagFactory.newDefaultBag();
    }

    LogicalExpression buildProjectExpr(SourceLocation loc, LogicalExpressionPlan plan, LogicalRelationalOperator op, Map<String, Operator> operators, Map<String, LogicalExpressionPlan> exprPlans, String colAlias, int col) throws RecognitionException {
        ProjectExpression result = null;
        if (colAlias != null) {
            LogicalExpressionPlan exprPlan = exprPlans.get(colAlias);
            if (exprPlan != null) {
                LogicalExpressionPlan planCopy = null;
                try {
                    planCopy = exprPlan.deepCopy();
                    plan.merge(planCopy);
                }
                catch (FrontendException ex) {
                    throw new PlanGenerationFailureException(this.intStream, loc, ex);
                }
                if (op != null) {
                    Iterator<Operator> it = plan.getOperators();
                    while (it.hasNext()) {
                        Operator o = it.next();
                        if (!(o instanceof ProjectExpression)) continue;
                        ProjectExpression projExpr = (ProjectExpression)o;
                        projExpr.setAttachedRelationalOp(op);
                    }
                }
                LogicalExpression root = (LogicalExpression)planCopy.getSources().get(0);
                try {
                    LogicalSchema.LogicalFieldSchema schema = root.getFieldSchema();
                    if (schema.alias == null) {
                        schema.alias = colAlias;
                    }
                }
                catch (FrontendException e) {
                    // empty catch block
                }
                return root;
            }
            result = new ProjectExpression(plan, 0, colAlias, operators.get(colAlias), op);
            result.setLocation(loc);
            return result;
        }
        result = new ProjectExpression(plan, 0, col, op);
        result.setLocation(loc);
        return result;
    }

    LogicalExpression buildProjectExpr(SourceLocation loc, LogicalExpressionPlan plan, LogicalRelationalOperator relOp, int input, String colAlias, int col) throws ParserValidationException {
        ProjectExpression result = null;
        result = colAlias != null ? new ProjectExpression(plan, input, colAlias, null, relOp) : new ProjectExpression(plan, input, col, relOp);
        result.setLocation(loc);
        return result;
    }

    LogicalExpression buildRangeProjectExpr(SourceLocation loc, LogicalExpressionPlan plan, LogicalRelationalOperator relOp, int input, LogicalExpression startExpr, LogicalExpression endExpr) throws ParserValidationException {
        if (startExpr == null && endExpr == null) {
            String msg = "in range project (..) at least one of start or end has to be specified. Use project-star (*) instead.";
            throw new ParserValidationException(this.intStream, loc, msg);
        }
        ProjectExpression proj = new ProjectExpression(plan, input, relOp);
        if (startExpr != null) {
            this.checkRangeProjectExpr(loc, startExpr);
            ProjectExpression startProj = (ProjectExpression)startExpr;
            if (startProj.getColAlias() != null) {
                try {
                    proj.setStartAlias(startProj.getColAlias());
                }
                catch (FrontendException e) {
                    throw new ParserValidationException(this.intStream, loc, e);
                }
            } else {
                proj.setStartCol(startProj.getColNum());
            }
        } else {
            proj.setStartCol(0);
        }
        if (endExpr != null) {
            this.checkRangeProjectExpr(loc, endExpr);
            ProjectExpression endProj = (ProjectExpression)endExpr;
            if (endProj.getColAlias() != null) {
                try {
                    proj.setEndAlias(endProj.getColAlias());
                }
                catch (FrontendException e) {
                    throw new ParserValidationException(this.intStream, loc, e);
                }
            } else {
                proj.setEndCol(endProj.getColNum());
            }
        } else {
            proj.setEndCol(-1);
        }
        try {
            if (startExpr != null) {
                plan.removeAndReconnect(startExpr);
            }
            if (endExpr != null) {
                plan.removeAndReconnect(endExpr);
            }
        }
        catch (FrontendException e) {
            throw new ParserValidationException(this.intStream, loc, e);
        }
        return proj;
    }

    private void checkRangeProjectExpr(SourceLocation loc, LogicalExpression startExpr) throws ParserValidationException {
        if (!(startExpr instanceof ProjectExpression)) {
            String msg = "range project (..) can have only a simple column. Found :" + startExpr;
            throw new ParserValidationException(this.intStream, loc, msg);
        }
    }

    LogicalExpression buildInvokerUDF(SourceLocation loc, LogicalExpressionPlan plan, String packageName, String funcName, boolean isStatic, List<LogicalExpression> args) throws RecognitionException {
        UserFuncExpression le = new UserFuncExpression(plan, new FuncSpec(InvokerGenerator.class.getName()), args, false, true, isStatic, packageName, funcName);
        le.setLocation(loc);
        return le;
    }

    public static Class<?> typeToClass(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Long.class;
        }
        if (clazz == Double.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Long.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        throw new RuntimeException("Was not given a primitive TYPE class: " + clazz);
    }

    LogicalExpression buildUDF(SourceLocation loc, LogicalExpressionPlan plan, String funcName, List<LogicalExpression> args) throws RecognitionException {
        UserFuncExpression le;
        Class func;
        try {
            func = this.pigContext.getClassForAlias(funcName);
            FunctionType.tryCasting(func, (byte)2);
        }
        catch (Exception e) {
            throw new PlanGenerationFailureException(this.intStream, loc, e);
        }
        FuncSpec funcSpec = this.pigContext.getFuncSpecFromAlias(funcName);
        if (funcSpec == null) {
            funcName = func.getName();
            funcSpec = new FuncSpec(funcName);
            le = new UserFuncExpression(plan, funcSpec, args, false);
        } else {
            le = new UserFuncExpression(plan, funcSpec, args, true);
        }
        le.setLocation(loc);
        return le;
    }

    private long getNextId() {
        return LogicalPlanBuilder.getNextId(this.scope);
    }

    static LOFilter createNestedFilterOp(LogicalPlan plan) {
        return new LOFilter(plan);
    }

    static LOLimit createNestedLimitOp(LogicalPlan plan) {
        return new LOLimit(plan);
    }

    Operator buildNestedFilterOp(SourceLocation loc, LOFilter op, LogicalPlan plan, String alias, Operator inputOp, LogicalExpressionPlan expr) {
        op.setFilterPlan(expr);
        this.buildNestedOp(loc, plan, (LogicalRelationalOperator)op, alias, inputOp);
        return op;
    }

    Operator buildNestedDistinctOp(SourceLocation loc, LogicalPlan plan, String alias, Operator inputOp) {
        LODistinct op = new LODistinct(plan);
        this.buildNestedOp(loc, plan, (LogicalRelationalOperator)op, alias, inputOp);
        return op;
    }

    Operator buildNestedLimitOp(SourceLocation loc, LogicalPlan plan, String alias, Operator inputOp, long limit) {
        LOLimit op = new LOLimit(plan, limit);
        this.buildNestedOp(loc, plan, (LogicalRelationalOperator)op, alias, inputOp);
        return op;
    }

    Operator buildNestedLimitOp(SourceLocation loc, LOLimit op, LogicalPlan plan, String alias, Operator inputOp, LogicalExpressionPlan expr) {
        op.setLimitPlan(expr);
        this.buildNestedOp(loc, plan, (LogicalRelationalOperator)op, alias, inputOp);
        return op;
    }

    Operator buildNestedCrossOp(SourceLocation loc, LogicalPlan plan, String alias, List<Operator> inputOpList) {
        LOCross op = new LOCross(plan);
        op.setNested(true);
        this.buildNestedOp(loc, plan, (LogicalRelationalOperator)op, alias, inputOpList);
        return op;
    }

    private void buildNestedOp(SourceLocation loc, LogicalPlan plan, LogicalRelationalOperator op, String alias, Operator inputOp) {
        op.setLocation(loc);
        this.setAlias(op, alias);
        plan.add(op);
        plan.connect(inputOp, op);
    }

    private void buildNestedOp(SourceLocation loc, LogicalPlan plan, LogicalRelationalOperator op, String alias, List<Operator> inputOpList) {
        op.setLocation(loc);
        this.setAlias(op, alias);
        plan.add(op);
        for (Operator inputOp : inputOpList) {
            plan.connect(inputOp, op);
        }
    }

    static LOSort createNestedSortOp(LogicalPlan plan) {
        return new LOSort(plan);
    }

    static void setBytearrayForNULLType(LogicalSchema sch) {
        for (LogicalSchema.LogicalFieldSchema fs : sch.getFields()) {
            if (fs.type == 1) {
                fs.type = (byte)50;
            }
            if (fs.schema == null) continue;
            LogicalPlanBuilder.setBytearrayForNULLType(fs.schema);
        }
    }

    static LOForEach createNestedForeachOp(LogicalPlan plan) {
        return new LOForEach(plan);
    }

    Operator buildNestedSortOp(SourceLocation loc, LOSort op, LogicalPlan plan, String alias, Operator inputOp, List<LogicalExpressionPlan> plans, List<Boolean> ascFlags, FuncSpec fs) {
        op.setSortColPlans(plans);
        if (ascFlags.isEmpty()) {
            for (int i = 0; i < plans.size(); ++i) {
                ascFlags.add(true);
            }
        }
        op.setAscendingCols(ascFlags);
        op.setUserFunc(fs);
        this.buildNestedOp(loc, plan, (LogicalRelationalOperator)op, alias, inputOp);
        return op;
    }

    Operator buildNestedForeachOp(SourceLocation loc, LOForEach op, LogicalPlan plan, String alias, Operator inputOp, LogicalPlan innerPlan) throws ParserValidationException {
        op.setInnerPlan(innerPlan);
        this.buildNestedOp(loc, plan, (LogicalRelationalOperator)op, alias, inputOp);
        return op;
    }

    Operator buildNestedProjectOp(SourceLocation loc, LogicalPlan innerPlan, LOForEach foreach, Map<String, Operator> operators, String alias, ProjectExpression projExpr, List<LogicalExpressionPlan> exprPlans) throws ParserValidationException {
        Operator input = null;
        String colAlias = projExpr.getColAlias();
        if (colAlias != null) {
            Operator op = operators.get(colAlias);
            if (op != null) {
                input = op;
            } else {
                input = this.createInnerLoad(loc, innerPlan, foreach, colAlias);
                input.setLocation(projExpr.getLocation());
            }
        } else {
            input = new LOInnerLoad((OperatorPlan)innerPlan, foreach, projExpr.getColNum());
            input.setLocation(projExpr.getLocation());
        }
        LogicalPlan lp = new LogicalPlan();
        LOForEach f = new LOForEach(innerPlan);
        f.setInnerPlan(lp);
        f.setLocation(loc);
        LOGenerate gen = new LOGenerate(lp);
        boolean[] flatten = new boolean[exprPlans.size()];
        ArrayList<LOInnerLoad> innerLoads = new ArrayList<LOInnerLoad>(exprPlans.size());
        for (LogicalExpressionPlan logicalExpressionPlan : exprPlans) {
            ProjectExpression pe = (ProjectExpression)logicalExpressionPlan.getSinks().get(0);
            String al = pe.getColAlias();
            LOInnerLoad iload = al == null ? new LOInnerLoad((OperatorPlan)lp, f, pe.getColNum()) : this.createInnerLoad(loc, lp, f, al);
            iload.setLocation(pe.getLocation());
            pe.setColNum(-1);
            pe.setInputNum(innerLoads.size());
            pe.setAttachedRelationalOp(gen);
            innerLoads.add(iload);
        }
        gen.setOutputPlans(exprPlans);
        gen.setFlattenFlags(flatten);
        lp.add(gen);
        for (Operator operator : innerLoads) {
            lp.add(operator);
            lp.connect(operator, gen);
        }
        this.setAlias(f, alias);
        innerPlan.add(input);
        innerPlan.add(f);
        innerPlan.connect(input, f);
        return f;
    }

    LOCogroup.GROUPTYPE parseGroupType(String hint, SourceLocation loc) throws ParserValidationException {
        String modifier = LogicalPlanBuilder.unquote(hint);
        if (modifier.equalsIgnoreCase("collected")) {
            return LOCogroup.GROUPTYPE.COLLECTED;
        }
        if (modifier.equalsIgnoreCase("regular")) {
            return LOCogroup.GROUPTYPE.REGULAR;
        }
        if (modifier.equalsIgnoreCase("merge")) {
            return LOCogroup.GROUPTYPE.MERGE;
        }
        throw new ParserValidationException(this.intStream, loc, "Only COLLECTED, REGULAR or MERGE are valid GROUP modifiers.");
    }

    LOJoin.JOINTYPE parseJoinType(String hint, SourceLocation loc) throws ParserValidationException {
        String modifier = LogicalPlanBuilder.unquote(hint);
        if (modifier.equalsIgnoreCase("repl") || modifier.equalsIgnoreCase("replicated")) {
            return LOJoin.JOINTYPE.REPLICATED;
        }
        if (modifier.equalsIgnoreCase("hash") || modifier.equalsIgnoreCase("default")) {
            return LOJoin.JOINTYPE.HASH;
        }
        if (modifier.equalsIgnoreCase("skewed")) {
            return LOJoin.JOINTYPE.SKEWED;
        }
        if (modifier.equalsIgnoreCase("merge")) {
            return LOJoin.JOINTYPE.MERGE;
        }
        if (modifier.equalsIgnoreCase("merge-sparse")) {
            return LOJoin.JOINTYPE.MERGESPARSE;
        }
        throw new ParserValidationException(this.intStream, loc, "Only REPL, REPLICATED, HASH, SKEWED, MERGE, and MERGE-SPARSE are vaild JOIN modifiers.");
    }

    void putOperator(String alias, Operator op) {
        this.operators.put(alias, op);
    }

    public String getLastRel(SourceLocation loc) throws ParserValidationException {
        if (this.lastRel == null) {
            throw new ParserValidationException(this.intStream, loc, "Asked for last relation -- no relations have been defined");
        }
        return this.lastRel;
    }

    public String getLastRel() {
        return this.lastRel;
    }
}

