/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewForwardOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class IdentityProjectRemover
implements Transform {
    private static final Log LOG = LogFactory.getLog(IdentityProjectRemover.class);

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", "(" + SelectOperator.getOperatorName() + "%)"), new ProjectRemover());
        DefaultGraphWalker ogw = new DefaultGraphWalker(new DefaultRuleDispatcher(null, opRules, null));
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private static class ProjectRemover
    implements NodeProcessor {
        private ProjectRemover() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator sel = (SelectOperator)nd;
            List<Operator<OperatorDesc>> parents = sel.getParentOperators();
            if (parents.size() != 1 || parents.get(0) instanceof LateralViewForwardOperator) {
                return null;
            }
            Operator<OperatorDesc> parent = parents.get(0);
            if (parent instanceof ReduceSinkOperator && Iterators.any(sel.getChildOperators().iterator(), Predicates.instanceOf(ReduceSinkOperator.class))) {
                return null;
            }
            ArrayList<Operator<OperatorDesc>> ancestorList = new ArrayList<Operator<OperatorDesc>>();
            ancestorList.addAll(sel.getParentOperators());
            while (!ancestorList.isEmpty()) {
                Operator curParent = (Operator)ancestorList.remove(0);
                if (curParent instanceof PTFOperator) {
                    return null;
                }
                if (!(curParent instanceof FilterOperator) || curParent.getParentOperators() == null) continue;
                ancestorList.addAll(curParent.getParentOperators());
            }
            if (sel.isIdentitySelect()) {
                parent.removeChildAndAdoptItsChildren(sel);
                LOG.debug((Object)("Identity project remover optimization removed : " + sel));
            }
            return null;
        }
    }
}

