/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public final class ParseUtils {
    public static boolean isJoinToken(ASTNode node) {
        switch (node.getToken().getType()) {
            case 692: 
            case 723: 
            case 726: 
            case 799: {
                return true;
            }
        }
        return false;
    }

    public static ASTNode findRootNonNullToken(ASTNode tree) {
        while (tree.getToken() == null && tree.getChildCount() > 0) {
            tree = (ASTNode)tree.getChild(0);
        }
        return tree;
    }

    private ParseUtils() {
    }

    public static List<String> validateColumnNameUniqueness(List<FieldSchema> fieldSchemas) throws SemanticException {
        Iterator<FieldSchema> iterCols = fieldSchemas.iterator();
        ArrayList<String> colNames = new ArrayList<String>();
        while (iterCols.hasNext()) {
            String colName = iterCols.next().getName();
            for (String oldColName : colNames) {
                if (!colName.equalsIgnoreCase(oldColName)) continue;
                throw new SemanticException(ErrorMsg.DUPLICATE_COLUMN_NAMES.getMsg(oldColName));
            }
            colNames.add(colName);
        }
        return colNames;
    }

    public static ExprNodeDesc createConversionCast(ExprNodeDesc column, PrimitiveTypeInfo tableFieldTypeInfo) throws SemanticException {
        String baseType = TypeInfoUtils.getBaseName(tableFieldTypeInfo.getTypeName());
        return TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDescWithUdfData(baseType, tableFieldTypeInfo, column);
    }

    public static VarcharTypeInfo getVarcharTypeInfo(ASTNode node) throws SemanticException {
        if (node.getChildCount() != 1) {
            throw new SemanticException("Bad params for type varchar");
        }
        String lengthStr = node.getChild(0).getText();
        return TypeInfoFactory.getVarcharTypeInfo(Integer.valueOf(lengthStr));
    }

    public static CharTypeInfo getCharTypeInfo(ASTNode node) throws SemanticException {
        if (node.getChildCount() != 1) {
            throw new SemanticException("Bad params for type char");
        }
        String lengthStr = node.getChild(0).getText();
        return TypeInfoFactory.getCharTypeInfo(Integer.valueOf(lengthStr));
    }

    static int getIndex(String[] list, String elem) {
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null || !list[i].toLowerCase().equals(elem)) continue;
            return i;
        }
        return -1;
    }

    static int checkJoinFilterRefersOneAlias(String[] tabAliases, ASTNode filterCondn) {
        int i;
        switch (filterCondn.getType()) {
            case 872: {
                String tableOrCol = SemanticAnalyzer.unescapeIdentifier(filterCondn.getChild(0).getText().toLowerCase());
                return ParseUtils.getIndex(tabAliases, tableOrCol);
            }
            case 7: 
            case 18: 
            case 26: 
            case 107: 
            case 260: 
            case 296: 
            case 306: 
            case 307: 
            case 309: 
            case 641: 
            case 660: 
            case 742: 
            case 839: {
                return -1;
            }
        }
        int idx = -1;
        int n = i = filterCondn.getType() == 693 ? 1 : 0;
        while (i < filterCondn.getChildCount()) {
            int cIdx = ParseUtils.checkJoinFilterRefersOneAlias(tabAliases, (ASTNode)filterCondn.getChild(i));
            if (cIdx != idx) {
                if (idx != -1 && cIdx != -1) {
                    return -1;
                }
                idx = idx == -1 ? cIdx : idx;
            }
            ++i;
        }
        return idx;
    }

    public static DecimalTypeInfo getDecimalTypeTypeInfo(ASTNode node) throws SemanticException {
        if (node.getChildCount() > 2) {
            throw new SemanticException("Bad params for type decimal");
        }
        int precision = 10;
        int scale = 0;
        if (node.getChildCount() >= 1) {
            String precStr = node.getChild(0).getText();
            precision = Integer.valueOf(precStr);
        }
        if (node.getChildCount() == 2) {
            String scaleStr = node.getChild(1).getText();
            scale = Integer.valueOf(scaleStr);
        }
        return TypeInfoFactory.getDecimalTypeInfo(precision, scale);
    }

    public static String ensureClassExists(String className) throws SemanticException {
        if (className == null) {
            return null;
        }
        try {
            Class.forName(className, true, Utilities.getSessionSpecifiedClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException("Cannot find class '" + className + "'", e);
        }
        return className;
    }
}

