/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ASTNodeOrigin;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.JoinType;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SubQueryDiagnostic;
import org.apache.hadoop.hive.ql.parse.SubQueryUtils;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class QBSubQuery
implements SubQueryUtils.ISubQueryJoinInfo {
    private final String outerQueryId;
    private final int sqIdx;
    private final String alias;
    private final ASTNode subQueryAST;
    private final ASTNode parentQueryExpression;
    private final SubQueryTypeDef operator;
    private boolean containsAggregationExprs;
    private boolean hasCorrelation;
    private ASTNode joinConditionAST;
    private JoinType joinType;
    private ASTNode postJoinConditionAST;
    private int numCorrExprsinSQ;
    private List<ASTNode> subQueryJoinAliasExprs;
    private final transient ASTNodeOrigin originalSQASTOrigin;
    private int numOfCorrelationExprsAddedToSQSelect;
    private boolean groupbyAddedToSQ;
    private int numOuterCorrExprsForHaving;
    private NotInCheck notInCheck;
    private SubQueryDiagnostic.QBSubQueryRewrite subQueryDiagnostic;

    public QBSubQuery(String outerQueryId, int sqIdx, ASTNode subQueryAST, ASTNode parentQueryExpression, SubQueryTypeDef operator, ASTNode originalSQAST, Context ctx) {
        this.subQueryAST = subQueryAST;
        this.parentQueryExpression = parentQueryExpression;
        this.operator = operator;
        this.outerQueryId = outerQueryId;
        this.sqIdx = sqIdx;
        this.alias = "sq_" + this.sqIdx;
        this.numCorrExprsinSQ = 0;
        this.numOuterCorrExprsForHaving = 0;
        String s = ctx.getTokenRewriteStream().toString(originalSQAST.getTokenStartIndex(), originalSQAST.getTokenStopIndex());
        this.originalSQASTOrigin = new ASTNodeOrigin("SubQuery", this.alias, s, this.alias, originalSQAST);
        this.numOfCorrelationExprsAddedToSQSelect = 0;
        this.groupbyAddedToSQ = false;
        if (operator.getType() == SubQueryType.NOT_IN) {
            this.notInCheck = new NotInCheck();
        }
        this.subQueryDiagnostic = SubQueryDiagnostic.getRewrite(this, ctx.getTokenRewriteStream(), ctx);
    }

    @Override
    public ASTNode getSubQueryAST() {
        return this.subQueryAST;
    }

    public ASTNode getOuterQueryExpression() {
        return this.parentQueryExpression;
    }

    public SubQueryTypeDef getOperator() {
        return this.operator;
    }

    public ASTNode getOriginalSubQueryASTForRewrite() {
        return this.operator.getType() == SubQueryType.NOT_EXISTS || this.operator.getType() == SubQueryType.NOT_IN ? (ASTNode)this.originalSQASTOrigin.getUsageNode().getParent() : this.originalSQASTOrigin.getUsageNode();
    }

    void validateAndRewriteAST(RowResolver outerQueryRR, boolean forHavingClause, String outerQueryAlias, Set<String> outerQryAliases) throws SemanticException {
        ASTNode u;
        ASTNode whereClause;
        ASTNode u2;
        ASTNode fromClause = this.getChildFromSubqueryAST("From", 691);
        ASTNode insertClause = this.getChildFromSubqueryAST("Insert", 717);
        ASTNode selectClause = (ASTNode)insertClause.getChild(1);
        int selectExprStart = 0;
        if (selectClause.getChild(0).getType() == 708) {
            selectExprStart = 1;
        }
        if (this.parentQueryExpression != null && !forHavingClause && (u2 = SubQueryUtils.hasUnQualifiedColumnReferences(this.parentQueryExpression)) != null) {
            this.subQueryAST.setOrigin(this.originalSQASTOrigin);
            throw new SemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(u2, "Correlating expression cannot contain unqualified column references."));
        }
        List<String> sqAliases = SubQueryUtils.getTableAliasesInSubQuery(fromClause);
        String sharedAlias = null;
        for (String s : sqAliases) {
            if (!outerQryAliases.contains(s)) continue;
            sharedAlias = s;
        }
        if (sharedAlias != null && (whereClause = SubQueryUtils.subQueryWhere(insertClause)) != null && (u = SubQueryUtils.hasUnQualifiedColumnReferences(whereClause)) != null) {
            this.subQueryAST.setOrigin(this.originalSQASTOrigin);
            throw new SemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(u, "SubQuery cannot use the table alias: " + sharedAlias + "; " + "this is also an alias in the Outer Query and SubQuery contains a unqualified column reference"));
        }
        if (this.operator.getType() != SubQueryType.EXISTS && this.operator.getType() != SubQueryType.NOT_EXISTS && selectClause.getChildCount() - selectExprStart > 1) {
            this.subQueryAST.setOrigin(this.originalSQASTOrigin);
            throw new SemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg(this.subQueryAST, "SubQuery can contain only 1 item in Select List."));
        }
        this.containsAggregationExprs = false;
        boolean containsWindowing = false;
        for (int i = selectExprStart; i < selectClause.getChildCount(); ++i) {
            ASTNode selectItem = (ASTNode)selectClause.getChild(i);
            int r = SubQueryUtils.checkAggOrWindowing(selectItem);
            containsWindowing |= r == 2;
            this.containsAggregationExprs |= r == 1;
        }
        this.rewrite(outerQueryRR, forHavingClause, outerQueryAlias, insertClause, selectClause);
        SubQueryUtils.setOriginDeep(this.subQueryAST, this.originalSQASTOrigin);
        if (this.operator.getType() == SubQueryType.EXISTS && this.containsAggregationExprs && this.groupbyAddedToSQ) {
            throw new SemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg(this.subQueryAST, "An Exists predicate on SubQuery with implicit Aggregation(no Group By clause) cannot be rewritten. (predicate will always return true)."));
        }
        if (this.operator.getType() == SubQueryType.NOT_EXISTS && this.containsAggregationExprs && this.groupbyAddedToSQ) {
            throw new SemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg(this.subQueryAST, "A Not Exists predicate on SubQuery with implicit Aggregation(no Group By clause) cannot be rewritten. (predicate will always return false)."));
        }
        if (containsWindowing && this.hasCorrelation) {
            throw new SemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(this.subQueryAST, "Correlated Sub Queries cannot contain Windowing clauses."));
        }
        if (!(this.operator.getType() != SubQueryType.EXISTS && this.operator.getType() != SubQueryType.NOT_EXISTS || this.hasCorrelation)) {
            throw new SemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg(this.subQueryAST, "For Exists/Not Exists operator SubQuery must be Correlated."));
        }
    }

    private ASTNode getChildFromSubqueryAST(String errorMsg, int type) throws SemanticException {
        ASTNode childAST = (ASTNode)this.subQueryAST.getFirstChildWithType(type);
        if (childAST == null && errorMsg != null) {
            this.subQueryAST.setOrigin(this.originalSQASTOrigin);
            throw new SemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg(this.subQueryAST, errorMsg + " clause is missing in SubQuery."));
        }
        return childAST;
    }

    private void setJoinType() {
        this.joinType = this.operator.getType() == SubQueryType.NOT_IN || this.operator.getType() == SubQueryType.NOT_EXISTS ? JoinType.LEFTOUTER : JoinType.LEFTSEMI;
    }

    void buildJoinCondition(RowResolver outerQueryRR, RowResolver sqRR, boolean forHavingClause, String outerQueryAlias) throws SemanticException {
        ASTNode parentQueryJoinCond = null;
        if (this.parentQueryExpression != null) {
            ColumnInfo outerQueryCol = null;
            try {
                outerQueryCol = outerQueryRR.getExpression(this.parentQueryExpression);
            }
            catch (SemanticException se) {
                // empty catch block
            }
            parentQueryJoinCond = SubQueryUtils.buildOuterQryToSQJoinCond(this.getOuterQueryExpression(), this.alias, sqRR);
            if (outerQueryCol != null) {
                this.rewriteCorrConjunctForHaving(parentQueryJoinCond, true, outerQueryAlias, outerQueryRR, outerQueryCol);
            }
            this.subQueryDiagnostic.addJoinCondition(parentQueryJoinCond, outerQueryCol != null, true);
        }
        this.joinConditionAST = SubQueryUtils.andAST(parentQueryJoinCond, this.joinConditionAST);
        this.setJoinType();
        if (this.joinType == JoinType.LEFTOUTER) {
            if (this.operator.getType() == SubQueryType.NOT_EXISTS && this.hasCorrelation) {
                this.postJoinConditionAST = SubQueryUtils.buildPostJoinNullCheck(this.subQueryJoinAliasExprs);
            } else if (this.operator.getType() == SubQueryType.NOT_IN) {
                this.postJoinConditionAST = SubQueryUtils.buildOuterJoinPostCond(this.alias, sqRR);
            }
        }
        SubQueryUtils.setOriginDeep(this.joinConditionAST, this.originalSQASTOrigin);
        SubQueryUtils.setOriginDeep(this.postJoinConditionAST, this.originalSQASTOrigin);
    }

    ASTNode updateOuterQueryFilter(ASTNode outerQryFilter) {
        if (this.postJoinConditionAST == null) {
            return outerQryFilter;
        }
        this.subQueryDiagnostic.addPostJoinCondition(this.postJoinConditionAST);
        if (outerQryFilter == null) {
            return this.postJoinConditionAST;
        }
        ASTNode node = SubQueryUtils.andAST(outerQryFilter, this.postJoinConditionAST);
        node.setOrigin(this.originalSQASTOrigin);
        return node;
    }

    String getNextCorrExprAlias() {
        return "sq_corr_" + this.numCorrExprsinSQ++;
    }

    private void rewrite(RowResolver parentQueryRR, boolean forHavingClause, String outerQueryAlias, ASTNode insertClause, ASTNode selectClause) throws SemanticException {
        ASTNode whereClause = SubQueryUtils.subQueryWhere(insertClause);
        if (whereClause == null) {
            return;
        }
        ASTNode searchCond = (ASTNode)whereClause.getChild(0);
        ArrayList<ASTNode> conjuncts = new ArrayList<ASTNode>();
        SubQueryUtils.extractConjuncts(searchCond, conjuncts);
        ConjunctAnalyzer conjunctAnalyzer = new ConjunctAnalyzer(parentQueryRR, forHavingClause, outerQueryAlias);
        ASTNode sqNewSearchCond = null;
        for (ASTNode conjunctAST : conjuncts) {
            Conjunct conjunct = conjunctAnalyzer.analyzeConjunct(conjunctAST);
            if (conjunct.eitherSideRefersBoth()) {
                throw new SemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(conjunctAST, "SubQuery expression refers to both Parent and SubQuery expressions and is not a valid join condition."));
            }
            if (conjunct.refersOuterOnly()) {
                throw new SemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(conjunctAST, "SubQuery expression refers to Outer query expressions only."));
            }
            if (conjunct.isCorrelated()) {
                ASTNode gBy;
                ASTNode selExpr;
                ASTNode joinPredciate;
                this.hasCorrelation = true;
                this.subQueryJoinAliasExprs = new ArrayList<ASTNode>();
                String exprAlias = this.getNextCorrExprAlias();
                ASTNode sqExprAlias = SubQueryUtils.createAliasAST(exprAlias);
                ASTNode sqExprForCorr = SubQueryUtils.createColRefAST(this.alias, exprAlias);
                boolean corrCondLeftIsRewritten = false;
                boolean corrCondRightIsRewritten = false;
                if (conjunct.getLeftExprType().refersSubQuery()) {
                    corrCondLeftIsRewritten = true;
                    if (forHavingClause && conjunct.getRightOuterColInfo() != null) {
                        corrCondRightIsRewritten = true;
                        this.rewriteCorrConjunctForHaving(conjunctAST, false, outerQueryAlias, parentQueryRR, conjunct.getRightOuterColInfo());
                    }
                    joinPredciate = SubQueryUtils.alterCorrelatedPredicate(conjunctAST, sqExprForCorr, true);
                    this.joinConditionAST = SubQueryUtils.andAST(this.joinConditionAST, joinPredciate);
                    this.subQueryJoinAliasExprs.add(sqExprForCorr);
                    selExpr = SubQueryUtils.createSelectItem(conjunct.getLeftExpr(), sqExprAlias);
                    selectClause.addChild((Tree)selExpr);
                    this.subQueryDiagnostic.addSelectClauseRewrite(conjunct.getLeftExpr(), exprAlias);
                    ++this.numOfCorrelationExprsAddedToSQSelect;
                    if (this.containsAggregationExprs) {
                        gBy = this.getSubQueryGroupByAST();
                        SubQueryUtils.addGroupExpressionToFront(gBy, conjunct.getLeftExpr());
                        this.subQueryDiagnostic.addGByClauseRewrite(conjunct.getLeftExpr());
                    }
                    if (this.notInCheck != null) {
                        this.notInCheck.addCorrExpr((ASTNode)conjunctAST.getChild(0));
                    }
                    this.subQueryDiagnostic.addJoinCondition(conjunctAST, corrCondLeftIsRewritten, corrCondRightIsRewritten);
                    continue;
                }
                corrCondRightIsRewritten = true;
                if (forHavingClause && conjunct.getLeftOuterColInfo() != null) {
                    corrCondLeftIsRewritten = true;
                    this.rewriteCorrConjunctForHaving(conjunctAST, true, outerQueryAlias, parentQueryRR, conjunct.getLeftOuterColInfo());
                }
                joinPredciate = SubQueryUtils.alterCorrelatedPredicate(conjunctAST, sqExprForCorr, false);
                this.joinConditionAST = SubQueryUtils.andAST(this.joinConditionAST, joinPredciate);
                this.subQueryJoinAliasExprs.add(sqExprForCorr);
                selExpr = SubQueryUtils.createSelectItem(conjunct.getRightExpr(), sqExprAlias);
                selectClause.addChild((Tree)selExpr);
                this.subQueryDiagnostic.addSelectClauseRewrite(conjunct.getRightExpr(), exprAlias);
                ++this.numOfCorrelationExprsAddedToSQSelect;
                if (this.containsAggregationExprs) {
                    gBy = this.getSubQueryGroupByAST();
                    SubQueryUtils.addGroupExpressionToFront(gBy, conjunct.getRightExpr());
                    this.subQueryDiagnostic.addGByClauseRewrite(conjunct.getRightExpr());
                }
                if (this.notInCheck != null) {
                    this.notInCheck.addCorrExpr((ASTNode)conjunctAST.getChild(1));
                }
                this.subQueryDiagnostic.addJoinCondition(conjunctAST, corrCondLeftIsRewritten, corrCondRightIsRewritten);
                continue;
            }
            sqNewSearchCond = SubQueryUtils.andAST(sqNewSearchCond, conjunctAST);
            this.subQueryDiagnostic.addWhereClauseRewrite(conjunctAST);
        }
        if (sqNewSearchCond != searchCond) {
            if (sqNewSearchCond == null) {
                sqNewSearchCond = SubQueryUtils.constructTrueCond();
                this.subQueryDiagnostic.addWhereClauseRewrite("1 = 1");
            }
            whereClause.setChild(0, (Tree)sqNewSearchCond);
        }
    }

    private ASTNode getSubQueryGroupByAST() {
        ASTNode groupBy = null;
        if (this.subQueryAST.getChild(1).getChildCount() > 3 && this.subQueryAST.getChild(1).getChild(3).getType() == 702) {
            groupBy = (ASTNode)this.subQueryAST.getChild(1).getChild(3);
        }
        if (groupBy != null) {
            return groupBy;
        }
        groupBy = SubQueryUtils.buildGroupBy();
        this.groupbyAddedToSQ = true;
        ArrayList<ASTNode> newChildren = new ArrayList<ASTNode>();
        newChildren.add(groupBy);
        if (this.subQueryAST.getChildCount() > 3) {
            for (int i = this.subQueryAST.getChildCount() - 1; i >= 3; --i) {
                ASTNode child = (ASTNode)this.subQueryAST.getChild(i);
                newChildren.add(child);
            }
        }
        for (ASTNode child : newChildren) {
            this.subQueryAST.addChild((Tree)child);
        }
        this.subQueryDiagnostic.setAddGroupByClause();
        return groupBy;
    }

    @Override
    public String getOuterQueryId() {
        return this.outerQueryId;
    }

    @Override
    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public ASTNode getJoinConditionAST() {
        return this.joinConditionAST;
    }

    public int getNumOfCorrelationExprsAddedToSQSelect() {
        return this.numOfCorrelationExprsAddedToSQSelect;
    }

    public SubQueryDiagnostic.QBSubQueryRewrite getDiagnostic() {
        return this.subQueryDiagnostic;
    }

    @Override
    public QBSubQuery getSubQuery() {
        return this;
    }

    NotInCheck getNotInCheck() {
        return this.notInCheck;
    }

    private void rewriteCorrConjunctForHaving(ASTNode conjunctASTNode, boolean refersLeft, String outerQueryAlias, RowResolver outerQueryRR, ColumnInfo outerQueryCol) {
        String newColAlias = "_gby_sq_col_" + this.numOuterCorrExprsForHaving++;
        ASTNode outerExprForCorr = SubQueryUtils.createColRefAST(outerQueryAlias, newColAlias);
        if (refersLeft) {
            conjunctASTNode.setChild(0, (Tree)outerExprForCorr);
        } else {
            conjunctASTNode.setChild(1, (Tree)outerExprForCorr);
        }
        outerQueryRR.put(outerQueryAlias, newColAlias, outerQueryCol);
    }

    class NotInCheck
    implements SubQueryUtils.ISubQueryJoinInfo {
        private static final String CNT_ALIAS = "c1";
        List<ASTNode> subQryCorrExprs = new ArrayList<ASTNode>();
        RowResolver sqRR;

        NotInCheck() {
        }

        void addCorrExpr(ASTNode corrExpr) {
            this.subQryCorrExprs.add(corrExpr);
        }

        @Override
        public ASTNode getSubQueryAST() {
            ASTNode ast = SubQueryUtils.buildNotInNullCheckQuery(QBSubQuery.this.getSubQueryAST(), QBSubQuery.this.getAlias(), CNT_ALIAS, this.subQryCorrExprs, this.sqRR);
            SubQueryUtils.setOriginDeep(ast, QBSubQuery.this.originalSQASTOrigin);
            return ast;
        }

        @Override
        public String getAlias() {
            return QBSubQuery.this.getAlias() + "_notin_nullcheck";
        }

        @Override
        public JoinType getJoinType() {
            return JoinType.LEFTSEMI;
        }

        @Override
        public ASTNode getJoinConditionAST() {
            ASTNode ast = SubQueryUtils.buildNotInNullJoinCond(this.getAlias(), CNT_ALIAS);
            SubQueryUtils.setOriginDeep(ast, QBSubQuery.this.originalSQASTOrigin);
            return ast;
        }

        @Override
        public QBSubQuery getSubQuery() {
            return QBSubQuery.this;
        }

        @Override
        public String getOuterQueryId() {
            return QBSubQuery.this.getOuterQueryId();
        }

        void setSQRR(RowResolver sqRR) {
            this.sqRR = sqRR;
        }
    }

    class ConjunctAnalyzer {
        RowResolver parentQueryRR;
        boolean forHavingClause;
        String parentQueryNewAlias;
        NodeProcessor defaultExprProcessor;
        Stack<Node> stack;

        ConjunctAnalyzer(RowResolver parentQueryRR, boolean forHavingClause, String parentQueryNewAlias) {
            this.parentQueryRR = parentQueryRR;
            this.defaultExprProcessor = new TypeCheckProcFactory.DefaultExprProcessor();
            this.forHavingClause = forHavingClause;
            this.parentQueryNewAlias = parentQueryNewAlias;
            this.stack = new Stack();
        }

        private ObjectPair<ExprType, ColumnInfo> analyzeExpr(ASTNode expr) {
            ColumnInfo cInfo = null;
            if (this.forHavingClause) {
                try {
                    cInfo = this.parentQueryRR.getExpression(expr);
                    if (cInfo != null) {
                        return ObjectPair.create(ExprType.REFERS_PARENT, cInfo);
                    }
                }
                catch (SemanticException se) {
                    // empty catch block
                }
            }
            if (expr.getType() == 17) {
                ASTNode dot = this.firstDot(expr);
                cInfo = this.resolveDot(dot);
                if (cInfo != null) {
                    return ObjectPair.create(ExprType.REFERS_PARENT, cInfo);
                }
                return ObjectPair.create(ExprType.REFERS_SUBQUERY, null);
            }
            if (expr.getType() == 872) {
                return ObjectPair.create(ExprType.REFERS_SUBQUERY, null);
            }
            ExprType exprType = ExprType.REFERS_NONE;
            int cnt = expr.getChildCount();
            for (int i = 0; i < cnt; ++i) {
                ASTNode child = (ASTNode)expr.getChild(i);
                exprType = exprType.combine(this.analyzeExpr(child).getFirst());
            }
            return ObjectPair.create(exprType, null);
        }

        Conjunct analyzeConjunct(ASTNode conjunct) throws SemanticException {
            int type = conjunct.getType();
            if (type == 20) {
                ASTNode left = (ASTNode)conjunct.getChild(0);
                ASTNode right = (ASTNode)conjunct.getChild(1);
                ObjectPair<ExprType, ColumnInfo> leftInfo = this.analyzeExpr(left);
                ObjectPair<ExprType, ColumnInfo> rightInfo = this.analyzeExpr(right);
                return new Conjunct(left, right, leftInfo.getFirst(), rightInfo.getFirst(), leftInfo.getSecond(), rightInfo.getSecond());
            }
            ObjectPair<ExprType, ColumnInfo> sqExprInfo = this.analyzeExpr(conjunct);
            return new Conjunct(conjunct, null, sqExprInfo.getFirst(), null, sqExprInfo.getSecond(), sqExprInfo.getSecond());
        }

        protected ColumnInfo resolveDot(ASTNode node) {
            try {
                TypeCheckCtx tcCtx = new TypeCheckCtx(this.parentQueryRR);
                String str = BaseSemanticAnalyzer.unescapeIdentifier(node.getChild(1).getText());
                ExprNodeConstantDesc idDesc = new ExprNodeConstantDesc(TypeInfoFactory.stringTypeInfo, str);
                ExprNodeColumnDesc colDesc = (ExprNodeColumnDesc)this.defaultExprProcessor.process(node, this.stack, tcCtx, null, idDesc);
                if (colDesc != null) {
                    String[] qualName = this.parentQueryRR.reverseLookup(colDesc.getColumn());
                    return this.parentQueryRR.get(qualName[0], qualName[1]);
                }
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
            return null;
        }

        protected ASTNode firstDot(ASTNode dot) {
            ASTNode firstChild = (ASTNode)dot.getChild(0);
            if (firstChild != null && firstChild.getType() == 17) {
                return this.firstDot(firstChild);
            }
            return dot;
        }
    }

    static class Conjunct {
        private final ASTNode leftExpr;
        private final ASTNode rightExpr;
        private final ExprType leftExprType;
        private final ExprType rightExprType;
        private final ColumnInfo leftOuterColInfo;
        private final ColumnInfo rightOuterColInfo;

        Conjunct(ASTNode leftExpr, ASTNode rightExpr, ExprType leftExprType, ExprType rightExprType, ColumnInfo leftOuterColInfo, ColumnInfo rightOuterColInfo) {
            this.leftExpr = leftExpr;
            this.rightExpr = rightExpr;
            this.leftExprType = leftExprType;
            this.rightExprType = rightExprType;
            this.leftOuterColInfo = leftOuterColInfo;
            this.rightOuterColInfo = rightOuterColInfo;
        }

        ASTNode getLeftExpr() {
            return this.leftExpr;
        }

        ASTNode getRightExpr() {
            return this.rightExpr;
        }

        ExprType getLeftExprType() {
            return this.leftExprType;
        }

        ExprType getRightExprType() {
            return this.rightExprType;
        }

        boolean eitherSideRefersBoth() {
            if (this.leftExprType == ExprType.REFERS_BOTH) {
                return true;
            }
            if (this.rightExpr != null) {
                return this.rightExprType == ExprType.REFERS_BOTH;
            }
            return false;
        }

        boolean isCorrelated() {
            if (this.rightExpr != null) {
                return this.leftExprType.combine(this.rightExprType) == ExprType.REFERS_BOTH;
            }
            return false;
        }

        boolean refersOuterOnly() {
            if (this.rightExpr == null) {
                return this.leftExprType == ExprType.REFERS_PARENT;
            }
            return this.leftExprType.combine(this.rightExprType) == ExprType.REFERS_PARENT;
        }

        ColumnInfo getLeftOuterColInfo() {
            return this.leftOuterColInfo;
        }

        ColumnInfo getRightOuterColInfo() {
            return this.rightOuterColInfo;
        }
    }

    static enum ExprType {
        REFERS_NONE(false, false){

            @Override
            public ExprType combine(ExprType other) {
                return other;
            }
        }
        ,
        REFERS_PARENT(true, false){

            @Override
            public ExprType combine(ExprType other) {
                switch (other) {
                    case REFERS_SUBQUERY: 
                    case REFERS_BOTH: {
                        return REFERS_BOTH;
                    }
                }
                return this;
            }
        }
        ,
        REFERS_SUBQUERY(false, true){

            @Override
            public ExprType combine(ExprType other) {
                switch (other) {
                    case REFERS_BOTH: 
                    case REFERS_PARENT: {
                        return REFERS_BOTH;
                    }
                }
                return this;
            }
        }
        ,
        REFERS_BOTH(true, true){

            @Override
            public ExprType combine(ExprType other) {
                return this;
            }
        };

        final boolean refersParent;
        final boolean refersSubQuery;

        private ExprType(boolean refersParent, boolean refersSubQuery) {
            this.refersParent = refersParent;
            this.refersSubQuery = refersSubQuery;
        }

        public boolean refersParent() {
            return this.refersParent;
        }

        public boolean refersSubQuery() {
            return this.refersSubQuery;
        }

        public abstract ExprType combine(ExprType var1);
    }

    public static class SubQueryTypeDef {
        private final ASTNode ast;
        private final SubQueryType type;

        public SubQueryTypeDef(ASTNode ast, SubQueryType type) {
            this.ast = ast;
            this.type = type;
        }

        public ASTNode getAst() {
            return this.ast;
        }

        public SubQueryType getType() {
            return this.type;
        }
    }

    public static enum SubQueryType {
        EXISTS,
        NOT_EXISTS,
        IN,
        NOT_IN;


        public static SubQueryType get(ASTNode opNode) throws SemanticException {
            switch (opNode.getType()) {
                case 102: {
                    return EXISTS;
                }
                case 844: {
                    return NOT_EXISTS;
                }
                case 131: {
                    return IN;
                }
                case 845: {
                    return NOT_IN;
                }
            }
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(opNode, "Operator not supported in SubQuery use."));
        }
    }
}

