/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(HiveConf conf, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(tree.getType()));
        switch (tree.getType()) {
            case 683: {
                return new ExplainSemanticAnalyzer(conf);
            }
            case 684: {
                return new ExplainSQRewriteSemanticAnalyzer(conf);
            }
            case 732: {
                return new LoadSemanticAnalyzer(conf);
            }
            case 686: {
                return new ExportSemanticAnalyzer(conf);
            }
            case 713: {
                return new ImportSemanticAnalyzer(conf);
            }
            case 599: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 600: 
                    case 601: 
                    case 602: 
                    case 607: 
                    case 608: 
                    case 609: 
                    case 613: 
                    case 614: 
                    case 616: 
                    case 617: 
                    case 619: 
                    case 622: 
                    case 624: 
                    case 625: {
                        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(conf);
                    }
                }
                HiveOperation commandType = tablePartitionCommandType.get(child.getType())[tree.getChildCount() > 2 ? 1 : 0];
                SemanticAnalyzerFactory.setSessionCommandType(commandType);
                return new DDLSemanticAnalyzer(conf);
            }
            case 627: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 628: 
                    case 629: 
                    case 630: 
                    case 631: 
                    case 632: {
                        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(conf);
                    }
                }
                assert (child.getType() == 787);
                SemanticAnalyzerFactory.setSessionCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(conf);
            }
            case 595: 
            case 596: 
            case 597: 
            case 598: 
            case 605: 
            case 645: 
            case 647: 
            case 650: 
            case 667: 
            case 668: 
            case 669: 
            case 675: 
            case 677: 
            case 679: 
            case 680: 
            case 681: 
            case 696: 
            case 698: 
            case 733: 
            case 734: 
            case 738: 
            case 797: 
            case 798: 
            case 811: 
            case 812: 
            case 813: 
            case 814: 
            case 815: 
            case 816: 
            case 817: 
            case 818: 
            case 819: 
            case 820: 
            case 821: 
            case 822: 
            case 823: 
            case 824: 
            case 825: 
            case 826: 
            case 827: 
            case 828: 
            case 829: 
            case 846: 
            case 888: 
            case 892: 
            case 893: {
                return new DDLSemanticAnalyzer(conf);
            }
            case 646: 
            case 676: 
            case 791: {
                return new FunctionSemanticAnalyzer(conf);
            }
            case 633: {
                return new ColumnStatsSemanticAnalyzer(conf);
            }
            case 649: 
            case 678: {
                return new MacroSemanticAnalyzer(conf);
            }
            case 666: 
            case 894: {
                return new UpdateDeleteSemanticAnalyzer(conf);
            }
        }
        SemanticAnalyzer semAnalyzer = HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(conf) : new SemanticAnalyzer(conf);
        return semAnalyzer;
    }

    private static void setSessionCommandType(HiveOperation commandType) {
        if (SessionState.get() != null) {
            SessionState.get().setCommandType(commandType);
        }
    }

    private SemanticAnalyzerFactory() {
    }

    static {
        commandType.put(683, HiveOperation.EXPLAIN);
        commandType.put(732, HiveOperation.LOAD);
        commandType.put(686, HiveOperation.EXPORT);
        commandType.put(713, HiveOperation.IMPORT);
        commandType.put(645, HiveOperation.CREATEDATABASE);
        commandType.put(675, HiveOperation.DROPDATABASE);
        commandType.put(846, HiveOperation.SWITCHDATABASE);
        commandType.put(651, HiveOperation.CREATETABLE);
        commandType.put(888, HiveOperation.TRUNCATETABLE);
        commandType.put(680, HiveOperation.DROPTABLE);
        commandType.put(669, HiveOperation.DESCTABLE);
        commandType.put(668, HiveOperation.DESCFUNCTION);
        commandType.put(738, HiveOperation.MSCK);
        commandType.put(600, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(619, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(617, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(616, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(607, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(601, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(624, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(602, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(625, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(614, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(608, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(609, HiveOperation.ALTERTABLE_EXCHANGEPARTITION);
        commandType.put(813, HiveOperation.SHOWDATABASES);
        commandType.put(819, HiveOperation.SHOWTABLES);
        commandType.put(811, HiveOperation.SHOWCOLUMNS);
        commandType.put(827, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(828, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(821, HiveOperation.SHOW_CREATETABLE);
        commandType.put(815, HiveOperation.SHOWFUNCTIONS);
        commandType.put(816, HiveOperation.SHOWINDEXES);
        commandType.put(818, HiveOperation.SHOWPARTITIONS);
        commandType.put(817, HiveOperation.SHOWLOCKS);
        commandType.put(814, HiveOperation.SHOWLOCKS);
        commandType.put(812, HiveOperation.SHOWCONF);
        commandType.put(646, HiveOperation.CREATEFUNCTION);
        commandType.put(676, HiveOperation.DROPFUNCTION);
        commandType.put(649, HiveOperation.CREATEMACRO);
        commandType.put(678, HiveOperation.DROPMACRO);
        commandType.put(652, HiveOperation.CREATEVIEW);
        commandType.put(681, HiveOperation.DROPVIEW);
        commandType.put(647, HiveOperation.CREATEINDEX);
        commandType.put(677, HiveOperation.DROPINDEX);
        commandType.put(598, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(597, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(631, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(630, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(628, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(629, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(632, HiveOperation.ALTERVIEW_RENAME);
        commandType.put(627, HiveOperation.ALTERVIEW_AS);
        commandType.put(787, HiveOperation.QUERY);
        commandType.put(734, HiveOperation.LOCKTABLE);
        commandType.put(893, HiveOperation.UNLOCKTABLE);
        commandType.put(733, HiveOperation.LOCKDB);
        commandType.put(892, HiveOperation.UNLOCKDB);
        commandType.put(650, HiveOperation.CREATEROLE);
        commandType.put(679, HiveOperation.DROPROLE);
        commandType.put(696, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(797, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(822, HiveOperation.SHOW_GRANT);
        commandType.put(698, HiveOperation.GRANT_ROLE);
        commandType.put(798, HiveOperation.REVOKE_ROLE);
        commandType.put(823, HiveOperation.SHOW_ROLES);
        commandType.put(826, HiveOperation.SHOW_ROLES);
        commandType.put(825, HiveOperation.SHOW_ROLE_PRINCIPALS);
        commandType.put(824, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(596, HiveOperation.ALTERDATABASE);
        commandType.put(595, HiveOperation.ALTERDATABASE_OWNER);
        commandType.put(667, HiveOperation.DESCDATABASE);
        commandType.put(622, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(633, HiveOperation.ANALYZE_TABLE);
        commandType.put(613, HiveOperation.ALTERTABLE_PARTCOLTYPE);
        commandType.put(820, HiveOperation.SHOW_COMPACTIONS);
        commandType.put(829, HiveOperation.SHOW_TRANSACTIONS);
        tablePartitionCommandType.put(615, new HiveOperation[]{HiveOperation.ALTERTABLE_PROTECTMODE, HiveOperation.ALTERPARTITION_PROTECTMODE});
        tablePartitionCommandType.put(610, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(611, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(612, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(621, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(620, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(618, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(606, new HiveOperation[]{HiveOperation.ALTERTABLE_COMPACT, HiveOperation.ALTERTABLE_COMPACT});
        tablePartitionCommandType.put(623, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(603, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(605, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
        tablePartitionCommandType.put(626, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
    }
}

