/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.awt.Font;
import java.awt.Paint;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.CategoryLabelWidthType;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Second;
import org.jfree.data.time.Year;
import org.jfree.text.TextBlockAnchor;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;
import org.pentaho.plugin.jfreereport.reportcharts.AbstractChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.FormulaCategoryTooltipGenerator;
import org.pentaho.plugin.jfreereport.reportcharts.FormulaCategoryURLGenerator;
import org.pentaho.plugin.jfreereport.reportcharts.LogCategoryItemLabelGenerator;
import org.pentaho.plugin.jfreereport.reportcharts.ScalingLogarithmicAxis;
import org.pentaho.plugin.jfreereport.reportcharts.backport.FastNumberTickUnit;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.LegacyUpdateHandler;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.formatting.FastDecimalFormat;

public abstract class CategoricalChartExpression
extends AbstractChartExpression
implements LegacyUpdateHandler {
    private static final long serialVersionUID = -402500824047401239L;
    private static final double DEFAULT_SCALE_FACTOR = 1.0;
    private String valueAxisLabel;
    private String categoryAxisLabel;
    private boolean horizontal;
    private boolean showGridlines = true;
    private Double labelRotation;
    private Float maxCategoryLabelWidthRatio;
    private Font categoryTitleFont;
    private Font categoryTickFont;
    private String categoricalLabelFormat = "{2}";
    private String categoricalLabelDecimalFormat;
    private String categoricalLabelDateFormat;
    private Double categoricalItemLabelRotation;
    private boolean humanReadableLogarithmicFormat;
    private boolean logarithmicAxis;
    private String categoricalAxisMessageFormat = "{0}";
    private Font rangeTitleFont;
    private Font rangeTickFont;
    private double rangeMinimum = 0.0;
    private double rangeMaximum = 1.0;
    private boolean rangeIncludesZero;
    private boolean rangeStickyZero;
    private NumberFormat rangeTickFormat;
    private String rangeTickFormatString;
    private Class rangeTimePeriod;
    private double rangePeriodCount = 0.0;
    private boolean autoRange = true;
    private double scaleFactor = 1.0;
    private Double lowerMargin;
    private Double upperMargin;
    private Double categoryMargin;

    protected CategoricalChartExpression() {
    }

    public Font getCategoryTitleFont() {
        return this.categoryTitleFont;
    }

    public void setCategoryTitleFont(Font categoryTitleFont) {
        this.categoryTitleFont = categoryTitleFont;
    }

    public Font getCategoryTickFont() {
        return this.categoryTickFont;
    }

    public void setCategoryTickFont(Font categoryTickFont) {
        this.categoryTickFont = categoryTickFont;
    }

    public String getRangeTickFormatString() {
        return this.rangeTickFormatString;
    }

    public void setRangeTickFormatString(String rangeTickFormatString) {
        this.rangeTickFormatString = rangeTickFormatString;
    }

    public String getCategoricalAxisMessageFormat() {
        return this.categoricalAxisMessageFormat;
    }

    public void setCategoricalAxisMessageFormat(String categoricalAxisMessageFormat) {
        this.categoricalAxisMessageFormat = categoricalAxisMessageFormat;
    }

    public Font getRangeTickFont() {
        return this.rangeTickFont;
    }

    public void setRangeTickFont(Font rangeTickFont) {
        this.rangeTickFont = rangeTickFont;
    }

    public double getRangeMinimum() {
        return this.rangeMinimum;
    }

    public void setRangeMinimum(double rangeMinimum) {
        this.rangeMinimum = rangeMinimum;
    }

    public double getRangeMaximum() {
        return this.rangeMaximum;
    }

    public void setRangeMaximum(double rangeMaximum) {
        this.rangeMaximum = rangeMaximum;
    }

    public Font getRangeTitleFont() {
        return this.rangeTitleFont;
    }

    public void setRangeTitleFont(Font rangeTitleFont) {
        this.rangeTitleFont = rangeTitleFont;
    }

    public NumberFormat getRangeTickFormat() {
        return this.rangeTickFormat;
    }

    public void setRangeTickFormat(NumberFormat rangeTickFormat) {
        this.rangeTickFormat = rangeTickFormat;
    }

    public boolean isRangeIncludesZero() {
        return this.rangeIncludesZero;
    }

    public void setRangeIncludesZero(boolean rangeIncludesZero) {
        this.rangeIncludesZero = rangeIncludesZero;
    }

    public boolean isRangeStickyZero() {
        return this.rangeStickyZero;
    }

    public void setRangeStickyZero(boolean rangeStickyZero) {
        this.rangeStickyZero = rangeStickyZero;
    }

    public boolean isLogarithmicAxis() {
        return this.logarithmicAxis;
    }

    public void setLogarithmicAxis(boolean logarithmicAxis) {
        this.logarithmicAxis = logarithmicAxis;
    }

    public boolean isHumanReadableLogarithmicFormat() {
        return this.humanReadableLogarithmicFormat;
    }

    public void setHumanReadableLogarithmicFormat(boolean humanReadableLogarithmicFormat) {
        this.humanReadableLogarithmicFormat = humanReadableLogarithmicFormat;
    }

    public Double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(Double lowerMargin) {
        this.lowerMargin = lowerMargin;
    }

    public Double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(Double upperMargin) {
        this.upperMargin = upperMargin;
    }

    public Double getCategoryMargin() {
        return this.categoryMargin;
    }

    public void setCategoryMargin(Double categoryMargin) {
        this.categoryMargin = categoryMargin;
    }

    public Double getLabelRotationDeg() {
        if (this.labelRotation == null) {
            return null;
        }
        return new Double(StrictMath.toDegrees(this.labelRotation));
    }

    public void setLabelRotationDeg(Double value) {
        this.labelRotation = value == null ? null : new Double(StrictMath.toRadians(value));
    }

    public Double getLabelRotation() {
        return this.labelRotation;
    }

    public void setLabelRotation(Double value) {
        this.labelRotation = value;
    }

    public Double getCategoricalItemLabelRotationDeg() {
        if (this.categoricalItemLabelRotation == null) {
            return null;
        }
        return new Double(StrictMath.toDegrees(this.categoricalItemLabelRotation));
    }

    public void setCategoricalItemLabelRotationDeg(Double value) {
        this.categoricalItemLabelRotation = value == null ? null : new Double(StrictMath.toRadians(value));
    }

    public Double getCategoricalItemLabelRotation() {
        return this.categoricalItemLabelRotation;
    }

    public void setCategoricalItemLabelRotation(Double value) {
        this.categoricalItemLabelRotation = value;
    }

    public void setMaxCategoryLabelWidthRatio(Float value) {
        this.maxCategoryLabelWidthRatio = value;
    }

    public Float getMaxCategoryLabelWidthRatio() {
        return this.maxCategoryLabelWidthRatio;
    }

    public boolean isShowGridlines() {
        return this.showGridlines;
    }

    public void setShowGridlines(boolean value) {
        this.showGridlines = value;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean value) {
        this.horizontal = value;
    }

    public String getValueAxisLabel() {
        return this.valueAxisLabel;
    }

    public void setValueAxisLabel(String valueAxisLabel) {
        this.valueAxisLabel = valueAxisLabel;
    }

    public String getCategoryAxisLabel() {
        return this.categoryAxisLabel;
    }

    public void setCategoryAxisLabel(String categoryAxisLabel) {
        this.categoryAxisLabel = categoryAxisLabel;
    }

    public void setCategoricalLabelFormat(String value) {
        this.categoricalLabelFormat = value;
    }

    public String getCategoricalLabelFormat() {
        return this.categoricalLabelFormat;
    }

    public void setCategoricalLabelDecimalFormat(String value) {
        this.categoricalLabelDecimalFormat = value;
    }

    public String getCategoricalLabelDecimalFormat() {
        return this.categoricalLabelDecimalFormat;
    }

    public void setCategoricalLabelDateFormat(String value) {
        this.categoricalLabelDateFormat = value;
    }

    public String getCategoricalLabelDateFormat() {
        return this.categoricalLabelDateFormat;
    }

    public boolean isAutoRange() {
        return this.autoRange;
    }

    public void setAutoRange(boolean autoRange) {
        this.autoRange = autoRange;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    @Override
    protected JFreeChart computeChart(Dataset dataset) {
        if (!(dataset instanceof CategoryDataset)) {
            return this.computeCategoryChart(null);
        }
        CategoryDataset categoryDataset = (CategoryDataset)dataset;
        return this.computeCategoryChart(categoryDataset);
    }

    protected JFreeChart computeCategoryChart(CategoryDataset dataset) {
        return this.getChart(dataset);
    }

    public JFreeChart getChart(CategoryDataset categoryDataset) {
        return null;
    }

    protected PlotOrientation computePlotOrientation() {
        PlotOrientation orientation = this.isHorizontal() ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
        return orientation;
    }

    @Override
    protected void configureChart(JFreeChart chart) {
        super.configureChart(chart);
        CategoryPlot cpl = chart.getCategoryPlot();
        CategoryItemRenderer renderer = cpl.getRenderer();
        if (!StringUtils.isEmpty((String)this.getTooltipFormula())) {
            renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new FormulaCategoryTooltipGenerator(this.getRuntime(), this.getTooltipFormula()));
        }
        if (!StringUtils.isEmpty((String)this.getUrlFormula())) {
            renderer.setBaseItemURLGenerator((CategoryURLGenerator)new FormulaCategoryURLGenerator(this.getRuntime(), this.getUrlFormula()));
        }
        if (this.categoricalLabelFormat != null) {
            StandardCategoryItemLabelGenerator scilg;
            if (this.categoricalLabelDecimalFormat != null) {
                DecimalFormat numFormat = new DecimalFormat(this.categoricalLabelDecimalFormat, new DecimalFormatSymbols(this.getRuntime().getResourceBundleFactory().getLocale()));
                numFormat.setRoundingMode(RoundingMode.HALF_UP);
                scilg = new StandardCategoryItemLabelGenerator(this.categoricalLabelFormat, (NumberFormat)numFormat);
            } else if (this.categoricalLabelDateFormat != null) {
                scilg = new StandardCategoryItemLabelGenerator(this.categoricalLabelFormat, (DateFormat)new SimpleDateFormat(this.categoricalLabelDateFormat, this.getRuntime().getResourceBundleFactory().getLocale()));
            } else {
                DecimalFormat formatter = new DecimalFormat();
                formatter.setDecimalFormatSymbols(new DecimalFormatSymbols(this.getRuntime().getResourceBundleFactory().getLocale()));
                scilg = new StandardCategoryItemLabelGenerator(this.categoricalLabelFormat, (NumberFormat)formatter);
            }
            renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)scilg);
        }
        renderer.setBaseItemLabelsVisible(Boolean.TRUE.equals(this.getItemsLabelVisible()));
        if (this.getItemLabelFont() != null) {
            renderer.setBaseItemLabelFont(this.getItemLabelFont());
        }
        if (this.categoricalItemLabelRotation != null) {
            ItemLabelPosition pos2;
            ItemLabelPosition orgPosItemLabelPos = renderer.getBasePositiveItemLabelPosition();
            if (orgPosItemLabelPos == null) {
                pos2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER, TextAnchor.CENTER, this.categoricalItemLabelRotation.doubleValue());
                renderer.setBasePositiveItemLabelPosition(pos2);
            } else {
                pos2 = new ItemLabelPosition(orgPosItemLabelPos.getItemLabelAnchor(), orgPosItemLabelPos.getTextAnchor(), orgPosItemLabelPos.getRotationAnchor(), this.categoricalItemLabelRotation.doubleValue());
                renderer.setBasePositiveItemLabelPosition(pos2);
            }
            ItemLabelPosition orgNegItemLabelPos = renderer.getBaseNegativeItemLabelPosition();
            if (orgNegItemLabelPos == null) {
                ItemLabelPosition pos22 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER, TextAnchor.CENTER, this.categoricalItemLabelRotation.doubleValue());
                renderer.setBaseNegativeItemLabelPosition(pos22);
            } else {
                ItemLabelPosition neg2 = new ItemLabelPosition(orgNegItemLabelPos.getItemLabelAnchor(), orgNegItemLabelPos.getTextAnchor(), orgNegItemLabelPos.getRotationAnchor(), this.categoricalItemLabelRotation.doubleValue());
                renderer.setBaseNegativeItemLabelPosition(neg2);
            }
        }
        Font labelFont = Font.decode(this.getLabelFont());
        CategoryAxis categoryAxis = cpl.getDomainAxis();
        categoryAxis.setLabelFont(labelFont);
        categoryAxis.setTickLabelFont(labelFont);
        if (this.getCategoryTitleFont() != null) {
            categoryAxis.setLabelFont(this.getCategoryTitleFont());
        }
        if (this.getCategoryTickFont() != null) {
            categoryAxis.setTickLabelFont(this.getCategoryTickFont());
        }
        if (this.maxCategoryLabelWidthRatio != null) {
            categoryAxis.setMaximumCategoryLabelWidthRatio(this.maxCategoryLabelWidthRatio.floatValue());
        }
        cpl.setDomainGridlinesVisible(this.showGridlines);
        if (this.labelRotation != null) {
            double angle = this.labelRotation;
            CategoryLabelPosition top = this.createUpRotationCategoryLabelPosition(PlaneDirection.TOP, angle);
            CategoryLabelPosition bottom = this.createUpRotationCategoryLabelPosition(PlaneDirection.BOTTOM, angle);
            CategoryLabelPosition left = this.createUpRotationCategoryLabelPosition(PlaneDirection.LEFT, angle);
            CategoryLabelPosition right = this.createUpRotationCategoryLabelPosition(PlaneDirection.RIGHT, angle);
            CategoryLabelPositions rotationLabelPositions = new CategoryLabelPositions(top, bottom, left, right);
            categoryAxis.setCategoryLabelPositions(rotationLabelPositions);
        }
        String[] colors = this.getSeriesColor();
        for (int i = 0; i < colors.length; ++i) {
            renderer.setSeriesPaint(i, (Paint)this.parseColorFromString(colors[i]));
        }
        if (this.lowerMargin != null) {
            categoryAxis.setLowerMargin(this.lowerMargin.doubleValue());
        }
        if (this.upperMargin != null) {
            categoryAxis.setUpperMargin(this.upperMargin.doubleValue());
        }
        if (this.categoryMargin != null) {
            categoryAxis.setCategoryMargin(this.categoryMargin.doubleValue());
        }
        this.configureRangeAxis(cpl, labelFont);
    }

    protected void configureRangeAxis(CategoryPlot cpl, Font labelFont) {
        Format formatter;
        NumberAxis numberAxis;
        ValueAxis rangeAxis = cpl.getRangeAxis();
        if (rangeAxis instanceof NumberAxis) {
            numberAxis = (NumberAxis)rangeAxis;
            numberAxis.setAutoRangeIncludesZero(this.isRangeIncludesZero());
            numberAxis.setAutoRangeStickyZero(this.isRangeStickyZero());
            if (this.getRangePeriodCount() > 0.0) {
                if (this.getRangeTickFormat() != null) {
                    numberAxis.setTickUnit(new NumberTickUnit(this.getRangePeriodCount(), this.getRangeTickFormat()));
                } else if (this.getRangeTickFormatString() != null) {
                    formatter = new FastDecimalFormat(this.getRangeTickFormatString(), this.getResourceBundleFactory().getLocale());
                    numberAxis.setTickUnit((NumberTickUnit)new FastNumberTickUnit(this.getRangePeriodCount(), (FastDecimalFormat)formatter));
                } else {
                    numberAxis.setTickUnit((NumberTickUnit)new FastNumberTickUnit(this.getRangePeriodCount()));
                }
            } else if (this.getRangeTickFormat() != null) {
                numberAxis.setNumberFormatOverride(this.getRangeTickFormat());
            } else if (this.getRangeTickFormatString() != null) {
                formatter = new DecimalFormat(this.getRangeTickFormatString(), new DecimalFormatSymbols(this.getResourceBundleFactory().getLocale()));
                numberAxis.setNumberFormatOverride((NumberFormat)formatter);
            }
        } else if (rangeAxis instanceof DateAxis) {
            numberAxis = (DateAxis)rangeAxis;
            if (this.getRangePeriodCount() > 0.0 && this.getRangeTimePeriod() != null) {
                if (this.getRangeTickFormatString() != null) {
                    formatter = new SimpleDateFormat(this.getRangeTickFormatString(), new DateFormatSymbols(this.getResourceBundleFactory().getLocale()));
                    numberAxis.setTickUnit(new DateTickUnit(this.getDateUnitAsInt(this.getRangeTimePeriod()), (int)this.getRangePeriodCount(), (DateFormat)formatter));
                } else {
                    numberAxis.setTickUnit(new DateTickUnit(this.getDateUnitAsInt(this.getRangeTimePeriod()), (int)this.getRangePeriodCount()));
                }
            } else if (this.getRangeTickFormatString() != null) {
                formatter = new SimpleDateFormat(this.getRangeTickFormatString(), new DateFormatSymbols(this.getResourceBundleFactory().getLocale()));
                numberAxis.setDateFormatOverride((DateFormat)formatter);
            }
        }
        if (rangeAxis != null) {
            int level;
            rangeAxis.setLabelFont(labelFont);
            rangeAxis.setTickLabelFont(labelFont);
            if (this.getRangeTitleFont() != null) {
                rangeAxis.setLabelFont(this.getRangeTitleFont());
            }
            if (this.getRangeTickFont() != null) {
                rangeAxis.setTickLabelFont(this.getRangeTickFont());
            }
            if (ClassicEngineBoot.isEnforceCompatibilityFor((int)(level = this.getRuntime().getProcessingContext().getCompatibilityLevel()), (int)3, (int)8)) {
                if (this.getRangeMinimum() != 0.0) {
                    rangeAxis.setLowerBound(this.getRangeMinimum());
                }
                if (this.getRangeMaximum() != 1.0) {
                    rangeAxis.setUpperBound(this.getRangeMaximum());
                }
                if (this.getRangeMinimum() == 0.0 && this.getRangeMaximum() == 0.0) {
                    rangeAxis.setAutoRange(true);
                }
            } else if (this.isAutoRange()) {
                rangeAxis.setAutoRange(this.isAutoRange());
            } else {
                double factor = this.getScaleFactor();
                if (factor > 1.0) {
                    double lower = rangeAxis.getLowerBound();
                    if (lower < 0.0) {
                        lower *= factor;
                    } else if (lower > 0.0) {
                        lower /= factor;
                    }
                    double upper = rangeAxis.getUpperBound();
                    if (upper > 0.0) {
                        upper *= factor;
                    } else if (upper < 0.0) {
                        upper /= factor;
                    }
                    rangeAxis.setRange(lower, upper);
                } else {
                    rangeAxis.setUpperBound(this.getRangeMaximum());
                    rangeAxis.setLowerBound(this.getRangeMinimum());
                }
            }
        }
    }

    protected void configureLogarithmicAxis(CategoryPlot plot) {
        if (this.isLogarithmicAxis()) {
            LogarithmicAxis logarithmicAxis;
            if (this.isHumanReadableLogarithmicFormat()) {
                plot.getRenderer().setBaseItemLabelGenerator((CategoryItemLabelGenerator)new LogCategoryItemLabelGenerator());
                logarithmicAxis = new ScalingLogarithmicAxis(this.getValueAxisLabel());
                logarithmicAxis.setStrictValuesFlag(false);
            } else {
                logarithmicAxis = new LogarithmicAxis(this.getValueAxisLabel());
                logarithmicAxis.setStrictValuesFlag(false);
            }
            plot.setRangeAxis((ValueAxis)logarithmicAxis);
        }
    }

    public Class getRangeTimePeriod() {
        return this.rangeTimePeriod;
    }

    public void setRangeTimePeriod(Class rangeTimePeriod) {
        this.rangeTimePeriod = rangeTimePeriod;
    }

    public double getRangePeriodCount() {
        return this.rangePeriodCount;
    }

    public void setRangePeriodCount(double rangePeriodCount) {
        this.rangePeriodCount = rangePeriodCount;
    }

    @Override
    public Expression getInstance() {
        CategoricalChartExpression expression = (CategoricalChartExpression)super.getInstance();
        if (expression.rangeTickFormat != null) {
            expression.rangeTickFormat = (NumberFormat)expression.rangeTickFormat.clone();
        }
        return expression;
    }

    protected int getDateUnitAsInt(Class domainTimePeriod) {
        if (Second.class.equals((Object)domainTimePeriod)) {
            return 5;
        }
        if (Minute.class.equals((Object)domainTimePeriod)) {
            return 4;
        }
        if (Hour.class.equals((Object)domainTimePeriod)) {
            return 3;
        }
        if (Day.class.equals((Object)domainTimePeriod)) {
            return 2;
        }
        if (Month.class.equals((Object)domainTimePeriod)) {
            return 1;
        }
        if (Year.class.equals((Object)domainTimePeriod)) {
            return 0;
        }
        if (Second.class.equals((Object)domainTimePeriod)) {
            return 6;
        }
        return 2;
    }

    public void reconfigureForCompatibility(int versionTag) {
        if (ClassicEngineBoot.isEnforceCompatibilityFor((int)versionTag, (int)3, (int)8)) {
            this.setAutoRange(this.getRangeMinimum() == 0.0 && this.getRangeMaximum() == 1.0);
        }
    }

    protected CategoryLabelPosition createUpRotationCategoryLabelPosition(PlaneDirection axisPosition, double labelAngle) {
        RectangleAnchor categoryAnchor = axisPosition.opposite().asRectangleAnchor();
        double labelAnchorDirectionAngle = axisPosition.opposite().asAngle() - labelAngle;
        PlaneDirection labelAnchorDirection = this.getTextAnchorDirectionOfAngle(labelAnchorDirectionAngle);
        TextBlockAnchor labelAnchor = labelAnchorDirection.asTextBlockAnchor();
        TextAnchor rotationAnchor = labelAnchorDirection.asTextAnchor();
        return new CategoryLabelPosition(categoryAnchor, labelAnchor, rotationAnchor, -labelAngle, CategoryLabelWidthType.RANGE, 0.5f);
    }

    protected PlaneDirection getTextAnchorDirectionOfAngle(double angle) {
        int sectorIndex = (int)(angle * 16.0 / Math.PI % 32.0 + 32.0) % 32;
        switch (sectorIndex) {
            case 5: 
            case 6: {
                return PlaneDirection.TOP_RIGHT;
            }
            case 7: 
            case 8: {
                return PlaneDirection.TOP;
            }
            case 9: 
            case 10: {
                return PlaneDirection.TOP_LEFT;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return PlaneDirection.LEFT;
            }
            case 21: 
            case 22: {
                return PlaneDirection.BOTTOM_LEFT;
            }
            case 23: 
            case 24: {
                return PlaneDirection.BOTTOM;
            }
            case 25: 
            case 26: {
                return PlaneDirection.BOTTOM_RIGHT;
            }
        }
        return PlaneDirection.RIGHT;
    }

    static enum PlaneDirection {
        RIGHT,
        TOP_RIGHT,
        TOP,
        TOP_LEFT,
        LEFT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT;

        private static final int COUNT;

        public static PlaneDirection byUnlimitedIndex(int unlimitedIndex) {
            return PlaneDirection.values()[(unlimitedIndex % COUNT + COUNT) % COUNT];
        }

        public PlaneDirection opposite() {
            return PlaneDirection.byUnlimitedIndex(this.ordinal() + COUNT / 2);
        }

        public RectangleAnchor asRectangleAnchor() {
            switch (this) {
                case RIGHT: {
                    return RectangleAnchor.RIGHT;
                }
                case TOP_RIGHT: {
                    return RectangleAnchor.TOP_RIGHT;
                }
                case TOP: {
                    return RectangleAnchor.TOP;
                }
                case TOP_LEFT: {
                    return RectangleAnchor.TOP_LEFT;
                }
                case LEFT: {
                    return RectangleAnchor.LEFT;
                }
                case BOTTOM_LEFT: {
                    return RectangleAnchor.BOTTOM_LEFT;
                }
                case BOTTOM: {
                    return RectangleAnchor.BOTTOM;
                }
                case BOTTOM_RIGHT: {
                    return RectangleAnchor.BOTTOM_RIGHT;
                }
            }
            return null;
        }

        public TextBlockAnchor asTextBlockAnchor() {
            switch (this) {
                case RIGHT: {
                    return TextBlockAnchor.CENTER_RIGHT;
                }
                case TOP_RIGHT: {
                    return TextBlockAnchor.TOP_RIGHT;
                }
                case TOP: {
                    return TextBlockAnchor.TOP_CENTER;
                }
                case TOP_LEFT: {
                    return TextBlockAnchor.TOP_LEFT;
                }
                case LEFT: {
                    return TextBlockAnchor.CENTER_LEFT;
                }
                case BOTTOM_LEFT: {
                    return TextBlockAnchor.BOTTOM_LEFT;
                }
                case BOTTOM: {
                    return TextBlockAnchor.BOTTOM_CENTER;
                }
                case BOTTOM_RIGHT: {
                    return TextBlockAnchor.BOTTOM_RIGHT;
                }
            }
            return null;
        }

        public TextAnchor asTextAnchor() {
            switch (this) {
                case RIGHT: {
                    return TextAnchor.CENTER_RIGHT;
                }
                case TOP_RIGHT: {
                    return TextAnchor.TOP_RIGHT;
                }
                case TOP: {
                    return TextAnchor.TOP_CENTER;
                }
                case TOP_LEFT: {
                    return TextAnchor.TOP_LEFT;
                }
                case LEFT: {
                    return TextAnchor.CENTER_LEFT;
                }
                case BOTTOM_LEFT: {
                    return TextAnchor.BOTTOM_LEFT;
                }
                case BOTTOM: {
                    return TextAnchor.BOTTOM_CENTER;
                }
                case BOTTOM_RIGHT: {
                    return TextAnchor.BOTTOM_RIGHT;
                }
            }
            return null;
        }

        public double asAngle() {
            return (double)this.ordinal() * 0.25 * Math.PI;
        }

        static {
            COUNT = PlaneDirection.values().length;
        }
    }
}

