/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.api.jdbc.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.api.jdbc.JdbcUrl;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUrlImpl
implements JdbcUrl {
    public static final String PENTAHO_NAMED_CLUSTER = "pentahoNamedCluster";
    private static final Logger logger = LoggerFactory.getLogger(JdbcUrlImpl.class);
    private final URI uri;
    private final Map<String, String> queryParams;
    private final NamedClusterService namedClusterService;
    private final MetastoreLocator metastoreLocator;

    public JdbcUrlImpl(String url, NamedClusterService namedClusterService, MetastoreLocator metastoreLocator) throws URISyntaxException {
        int beginIndex;
        this.namedClusterService = namedClusterService;
        this.metastoreLocator = metastoreLocator;
        if (!url.startsWith("jdbc:")) {
            throw new URISyntaxException(url, "Should start with \"jdbc:\"");
        }
        this.uri = new URI(url.substring(5));
        String query = null;
        String path = this.uri.getPath();
        if (path != null && (beginIndex = path.indexOf(59)) >= 0) {
            query = path.substring(beginIndex);
        }
        this.queryParams = query == null ? new HashMap<String, String>() : Arrays.asList(query.split(";")).stream().map(s -> {
            int i = s.indexOf(61);
            if (i < 0 || i >= s.length() - 1) {
                return null;
            }
            return new String[]{s.substring(0, i), s.substring(i + 1)};
        }).filter(Objects::nonNull).collect(Collectors.toMap(r -> r[0], t -> t[1]));
    }

    @Override
    public String toString() {
        String queryParameters = this.queryParams.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).filter(Objects::nonNull).sorted(String::compareToIgnoreCase).collect(Collectors.joining(";"));
        String path = this.uri.getPath();
        int semicolon = path.indexOf(59);
        if (semicolon >= 0) {
            path = path.substring(0, semicolon);
        }
        return "jdbc:" + this.uri.getScheme() + "://" + this.uri.getHost() + ":" + this.uri.getPort() + path + (queryParameters != null && queryParameters.length() > 0 ? ";" + queryParameters : "");
    }

    @Override
    public void setQueryParam(String key, String value) {
        this.queryParams.put(key, value);
    }

    @Override
    public String getQueryParam(String key) {
        return this.queryParams.get(key);
    }

    @Override
    public NamedCluster getNamedCluster() throws MetaStoreException {
        IMetaStore metaStore = this.metastoreLocator.getMetastore();
        if (metaStore == null) {
            return null;
        }
        String queryParam = this.getQueryParam(PENTAHO_NAMED_CLUSTER);
        if (queryParam == null) {
            return null;
        }
        return this.namedClusterService.read(queryParam, metaStore);
    }

    @Override
    public String getHost() {
        return this.uri.getHost();
    }
}

