/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model;

import java.awt.Color;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;

public final class BorderEdge {
    public static final BorderEdge EMPTY = new BorderEdge(BorderStyle.NONE, Color.black, 0L);
    private BorderStyle borderStyle;
    private Color color;
    private long width;

    public BorderEdge(BorderStyle borderStyle, Color color, long width) {
        if (borderStyle == null) {
            throw new NullPointerException();
        }
        this.borderStyle = borderStyle;
        this.color = color;
        this.width = width;
        if (BorderStyle.NONE.equals(borderStyle)) {
            this.width = 0L;
        }
    }

    public BorderStyle getBorderStyle() {
        return this.borderStyle;
    }

    public Color getColor() {
        return this.color;
    }

    public long getWidth() {
        return this.width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BorderEdge)) {
            return false;
        }
        BorderEdge that = (BorderEdge)o;
        if (this.width != that.width) {
            return false;
        }
        if (!this.borderStyle.equals(that.borderStyle)) {
            return false;
        }
        return !(this.color != null ? !this.color.equals(that.color) : that.color != null);
    }

    public int hashCode() {
        int result = this.borderStyle.hashCode();
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        result = 31 * result + (int)(this.width ^ this.width >>> 32);
        return result;
    }

    public String toString() {
        return "BorderEdge{borderStyle='" + this.borderStyle + '\'' + ", color=" + this.color + ", width=" + this.width + '}';
    }

    public boolean isEmpty() {
        return this.width == 0L || BorderStyle.NONE.equals(this.borderStyle);
    }
}

