/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.alignment;

import java.util.ArrayList;
import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.SpacerRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.SplittableRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.context.StaticBoxLayoutProperties;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.LastLineTextAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.LeftAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.TextAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.EndSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.InlineSequenceElement;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.SequenceList;
import org.pentaho.reporting.engine.classic.core.layout.process.layoutrules.StartSequenceElement;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.WhitespaceCollapse;
import org.pentaho.reporting.engine.classic.core.util.LongList;
import org.pentaho.reporting.libraries.base.util.FastStack;

public abstract class AbstractAlignmentProcessor
implements TextAlignmentProcessor,
LastLineTextAlignmentProcessor {
    private static final InlineSequenceElement[] EMPTY_ELEMENTS = new InlineSequenceElement[0];
    private static final RenderNode[] EMPTY_NODES = new RenderNode[0];
    private long startOfLine;
    private long endOfLine;
    private long[] pagebreaks;
    private int pagebreakCount;
    private PageGrid pageGrid;
    private InlineSequenceElement[] sequenceElements = EMPTY_ELEMENTS;
    private RenderNode[] nodes = EMPTY_NODES;
    private int sequenceFill;
    private int breakableIndex;
    private int skipIndex;
    private long breakableMaxAllowedWidth;
    private long[] elementPositions;
    private long[] elementDimensions;
    private FastStack<RenderBox> contexts = new FastStack(50);
    private ArrayList<RenderNode> pendingElements = new ArrayList();
    private static final long[] EMPTY = new long[0];
    private boolean lastLineAlignment;
    private LeftAlignmentProcessor leftAlignProcessor;
    private boolean overflowX;
    private LongList pageLongList;

    protected AbstractAlignmentProcessor() {
        this.elementDimensions = EMPTY;
        this.elementPositions = EMPTY;
    }

    public boolean isLastLineAlignment() {
        return this.lastLineAlignment;
    }

    protected long getStartOfLine() {
        return this.startOfLine;
    }

    protected PageGrid getPageGrid() {
        return this.pageGrid;
    }

    protected InlineSequenceElement[] getSequenceElements() {
        return this.sequenceElements;
    }

    protected RenderNode[] getNodes() {
        return this.nodes;
    }

    protected long[] getElementPositions() {
        return this.elementPositions;
    }

    protected long[] getElementDimensions() {
        return this.elementDimensions;
    }

    protected long getEndOfLine() {
        return this.endOfLine;
    }

    public int getPagebreakCount() {
        return this.pagebreakCount;
    }

    protected long getPageBreak(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.pagebreakCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.pagebreaks[pageIndex];
    }

    protected long[] getPageBreaks() {
        return this.pagebreaks;
    }

    protected void updatePageBreaks(long[] pagebreaks, int pageBreakCount) {
        this.pagebreakCount = pageBreakCount;
        this.pagebreaks = pagebreaks;
    }

    protected int getBreakableIndex() {
        return this.breakableIndex;
    }

    protected void setBreakableIndex(int breakableIndex) {
        this.breakableIndex = breakableIndex;
    }

    protected int getSkipIndex() {
        return this.skipIndex;
    }

    protected void setSkipIndex(int skipIndex) {
        this.skipIndex = skipIndex;
    }

    protected long getBreakableMaxAllowedWidth() {
        return this.breakableMaxAllowedWidth;
    }

    protected void setBreakableMaxAllowedWidth(long breakableMaxAllowedWidth) {
        this.breakableMaxAllowedWidth = breakableMaxAllowedWidth;
    }

    protected int iterate(InlineSequenceElement[] elements, int maxPos) {
        this.breakableIndex = -1;
        this.breakableMaxAllowedWidth = -1L;
        this.skipIndex = -1;
        if (maxPos == 0) {
            return 0;
        }
        int lastElementType = elements[0].getClassification();
        int startIndex = 0;
        boolean lastNodeWasSpacer = lastElementType == 1 && this.nodes[0].getNodeType() == 65;
        for (int i = 1; i < maxPos; ++i) {
            InlineSequenceElement element = elements[i];
            int elementType = element.getClassification();
            if (!lastNodeWasSpacer && lastElementType != 0 && elementType != 2) {
                int newIndex = this.handleElement(startIndex, i - startIndex);
                if (newIndex <= startIndex) {
                    return startIndex;
                }
                startIndex = i;
            }
            lastNodeWasSpacer = elementType == 1 && this.nodes[i].getNodeType() == 65;
            lastElementType = elementType;
        }
        return this.handleElement(startIndex, maxPos - startIndex);
    }

    @Override
    public void initialize(OutputProcessorMetaData metaData, SequenceList sequence, long start, long end, PageGrid breaks, boolean overflowX) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        if (metaData == null) {
            throw new NullPointerException();
        }
        if (breaks == null) {
            throw new NullPointerException();
        }
        if (end < start) {
            throw new IllegalArgumentException("Start is <= end; which is stupid!: " + end + ' ' + start);
        }
        this.overflowX = overflowX;
        this.sequenceElements = sequence.getSequenceElements(this.sequenceElements);
        this.nodes = sequence.getNodes(this.nodes);
        this.sequenceFill = sequence.size();
        this.pageGrid = breaks;
        if (this.elementPositions.length < this.sequenceFill) {
            this.elementPositions = new long[this.sequenceFill];
        } else {
            Arrays.fill(this.elementPositions, 0L);
        }
        if (this.elementDimensions.length < this.sequenceFill) {
            this.elementDimensions = new long[this.sequenceFill];
        } else {
            Arrays.fill(this.elementDimensions, 0L);
        }
        this.updateLineSize(start, end);
    }

    @Override
    public void updateLineSize(long start, long end) {
        if (this.startOfLine != start || this.endOfLine != end || this.pagebreaks == null) {
            this.startOfLine = start;
            this.endOfLine = end;
            this.updateBreaks();
        }
    }

    @Override
    public void deinitialize() {
        this.pageGrid = null;
        this.pendingElements.clear();
        this.contexts.clear();
        this.sequenceFill = 0;
    }

    private void updateBreaks() {
        long[] horizontalBreaks = this.pageGrid.getHorizontalBreaks();
        int breakCount = horizontalBreaks.length;
        if (this.pageLongList == null) {
            this.pageLongList = new LongList(breakCount);
        } else {
            this.pageLongList.clear();
        }
        for (int i = 0; i < breakCount; ++i) {
            long pos = horizontalBreaks[i];
            if (pos <= this.startOfLine) continue;
            if (pos >= this.endOfLine) break;
            if (this.overflowX && i >= breakCount - 1) continue;
            this.pageLongList.add(pos);
        }
        this.pageLongList.add(this.endOfLine);
        this.pagebreaks = this.pageLongList.toArray(this.pagebreaks);
        this.pagebreakCount = this.pageLongList.size();
    }

    @Override
    public boolean hasNext() {
        return this.sequenceFill > 0;
    }

    @Override
    public RenderBox next() {
        RenderNode node;
        StyleSheet styleSheet;
        this.cleanFirstSpacers();
        Arrays.fill(this.elementDimensions, 0L);
        Arrays.fill(this.elementPositions, 0L);
        int lastPosition = this.iterate(this.sequenceElements, this.sequenceFill);
        if (lastPosition == 0) {
            if (this.splitBreakableIfPossible()) {
                return this.next();
            }
            if (this.getSkipIndex() >= 0) {
                this.performSkipAlignment(this.getSkipIndex());
                lastPosition = this.getSkipIndex();
            } else {
                lastPosition = this.sequenceFill;
            }
        }
        this.pendingElements.clear();
        this.contexts.clear();
        RenderBox firstBox = null;
        RenderBox box = null;
        for (int i = 0; i < lastPosition; ++i) {
            RenderNode node2 = this.nodes[i];
            InlineSequenceElement element = this.sequenceElements[i];
            if (element instanceof EndSequenceElement) {
                this.contexts.pop();
                long boxX2 = this.elementPositions[i] + this.elementDimensions[i];
                box.setCachedWidth(boxX2 - box.getCachedX());
                if (this.contexts.isEmpty()) {
                    box = null;
                    continue;
                }
                RenderBox tmpnode = box;
                box = (RenderBox)this.contexts.peek();
                box.addGeneratedChild(tmpnode);
                continue;
            }
            if (element instanceof StartSequenceElement) {
                box = (RenderBox)node2.derive(false);
                box.setCachedX(this.elementPositions[i]);
                this.contexts.push((Object)box);
                if (firstBox != null) continue;
                firstBox = box;
                continue;
            }
            if (box == null) {
                throw new IllegalStateException("Invalid sequence: Cannot have elements before we open the box context.");
            }
            RenderNode child = node2.derive(true);
            child.setCachedX(this.elementPositions[i]);
            child.setCachedWidth(this.elementDimensions[i]);
            if (box.getStaticBoxLayoutProperties().isPreserveSpace() && !box.getStyleSheet().getBooleanStyleProperty(TextStyleKeys.TRIM_TEXT_CONTENT)) {
                box.addGeneratedChild(child);
                continue;
            }
            if (child.isIgnorableForRendering()) {
                this.pendingElements.add(child);
                continue;
            }
            for (int j = 0; j < this.pendingElements.size(); ++j) {
                RenderNode pendingNode = this.pendingElements.get(j);
                box.addGeneratedChild(pendingNode);
            }
            this.pendingElements.clear();
            box.addGeneratedChild(child);
        }
        while (lastPosition < this.sequenceFill && (!WhitespaceCollapse.PRESERVE.equals((styleSheet = (node = this.nodes[lastPosition]).getStyleSheet()).getStyleProperty(TextStyleKeys.WHITE_SPACE_COLLAPSE)) || styleSheet.getBooleanStyleProperty(TextStyleKeys.TRIM_TEXT_CONTENT)) && node.isIgnorableForRendering()) {
            ++lastPosition;
        }
        RenderBox previousContext = null;
        int openContexts = this.contexts.size();
        for (int i = 0; i < openContexts; ++i) {
            RenderBox renderBox = (RenderBox)this.contexts.get(i);
            long cachedWidth = this.getEndOfLine() - renderBox.getCachedX();
            renderBox.setCachedWidth(cachedWidth);
            InlineRenderBox rightBox = (InlineRenderBox)renderBox.split(0);
            this.sequenceElements[i] = StartSequenceElement.INSTANCE;
            this.nodes[i] = rightBox;
            if (previousContext != null) {
                previousContext.addGeneratedChild(renderBox);
            }
            previousContext = renderBox;
        }
        int length = this.sequenceFill - lastPosition;
        System.arraycopy(this.sequenceElements, lastPosition, this.sequenceElements, openContexts, length);
        System.arraycopy(this.nodes, lastPosition, this.nodes, openContexts, length);
        this.sequenceFill = openContexts + length;
        Arrays.fill(this.sequenceElements, this.sequenceFill, this.sequenceElements.length, null);
        Arrays.fill(this.nodes, this.sequenceFill, this.nodes.length, null);
        return firstBox;
    }

    private void cleanFirstSpacers() {
        Object[] sequenceElements = this.sequenceElements;
        Object[] nodes = this.nodes;
        int sequenceFill = this.sequenceFill;
        boolean changed = false;
        int targetIndex = 0;
        for (int i = 0; i < this.sequenceFill; ++i) {
            RenderNode node;
            InlineSequenceElement ise = this.sequenceElements[i];
            InlineSequenceElement.Classification type = ise.getType();
            if (type == InlineSequenceElement.Classification.CONTENT && (node = this.nodes[i]) instanceof SpacerRenderNode) {
                if (!changed) {
                    sequenceElements = (InlineSequenceElement[])this.sequenceElements.clone();
                    nodes = (RenderNode[])this.nodes.clone();
                }
                --sequenceFill;
                changed = true;
                continue;
            }
            if (changed) {
                sequenceElements[targetIndex] = ise;
                nodes[targetIndex] = this.nodes[i];
            }
            if (type != InlineSequenceElement.Classification.START) {
                if (!changed) {
                    return;
                }
                System.arraycopy(this.sequenceElements, i, sequenceElements, targetIndex, this.sequenceFill - i);
                System.arraycopy(this.nodes, i, nodes, targetIndex, this.sequenceFill - i);
                Arrays.fill(nodes, sequenceFill, nodes.length, null);
                Arrays.fill(sequenceElements, sequenceFill, sequenceElements.length, null);
                this.sequenceElements = sequenceElements;
                this.nodes = nodes;
                this.sequenceFill = sequenceFill;
                return;
            }
            ++targetIndex;
        }
    }

    protected abstract int handleElement(int var1, int var2);

    protected void computeInlineBlock(RenderBox box, long position, long itemElementWidth) {
        StaticBoxLayoutProperties blp = box.getStaticBoxLayoutProperties();
        box.setCachedX(position + blp.getMarginLeft());
        long width = itemElementWidth - blp.getMarginLeft() - blp.getMarginRight();
        if (width == 0L) {
            throw new IllegalStateException("A box without any width? " + Integer.toHexString(System.identityHashCode(box)) + ' ' + box.getClass());
        }
        box.setCachedWidth(width);
        BoxDefinition bdef = box.getBoxDefinition();
        long leftInsets = bdef.getPaddingLeft() + blp.getBorderLeft();
        long rightInsets = bdef.getPaddingRight() + blp.getBorderRight();
        box.setContentAreaX1(box.getCachedX() + leftInsets);
        box.setContentAreaX2(box.getCachedX() + box.getCachedWidth() - rightInsets);
    }

    protected int getSequenceFill() {
        return this.sequenceFill;
    }

    @Override
    public void performLastLineAlignment() {
        if (this.pagebreakCount == 0) {
            throw new IllegalStateException("Alignment processor has not been initialized correctly.");
        }
        Arrays.fill(this.elementDimensions, 0L);
        Arrays.fill(this.elementPositions, 0L);
        int lastPosition = this.iterate(this.sequenceElements, this.sequenceFill);
        if (lastPosition == 0) {
            if (this.getSkipIndex() >= 0) {
                this.performSkipAlignment(this.getSkipIndex());
                lastPosition = this.getSkipIndex();
            } else {
                lastPosition = this.sequenceFill;
            }
        }
        if (lastPosition == this.sequenceFill || this.lastLineAlignment) {
            RenderBox firstBox = null;
            for (int i = 0; i < lastPosition; ++i) {
                RenderNode node = this.nodes[i];
                InlineSequenceElement element = this.sequenceElements[i];
                if (element instanceof EndSequenceElement) {
                    long boxX2 = this.elementPositions[i] + this.elementDimensions[i];
                    RenderBox box = (RenderBox)node;
                    box.setCachedWidth(boxX2 - box.getCachedX());
                    continue;
                }
                if (element instanceof StartSequenceElement) {
                    RenderBox box = (RenderBox)node;
                    box.setCachedX(this.elementPositions[i]);
                    if (firstBox != null) continue;
                    firstBox = box;
                    continue;
                }
                node.setCachedX(this.elementPositions[i]);
                node.setCachedWidth(this.elementDimensions[i]);
            }
            return;
        }
        if (this.leftAlignProcessor == null) {
            this.leftAlignProcessor = new LeftAlignmentProcessor();
        }
        this.leftAlignProcessor.initializeForLastLineAlignment(this);
        this.leftAlignProcessor.performLastLineAlignment();
        this.leftAlignProcessor.deinitialize();
    }

    public void performSkipAlignment(int endIndex) {
        if (this.leftAlignProcessor == null) {
            this.leftAlignProcessor = new LeftAlignmentProcessor();
        }
        this.leftAlignProcessor.initializeForSkipAlignment(this, endIndex);
        this.leftAlignProcessor.performLastLineAlignment();
        this.leftAlignProcessor.deinitialize();
    }

    protected void initializeForSkipAlignment(AbstractAlignmentProcessor proc, int endIndex) {
        this.lastLineAlignment = true;
        this.sequenceElements = proc.sequenceElements;
        this.nodes = proc.nodes;
        this.sequenceFill = endIndex;
        this.pageGrid = proc.pageGrid;
        this.elementDimensions = proc.elementDimensions;
        this.elementPositions = proc.elementPositions;
        Arrays.fill(this.elementPositions, 0L);
        Arrays.fill(this.elementDimensions, 0L);
        this.startOfLine = proc.startOfLine;
        this.endOfLine = proc.endOfLine;
        if (this.pagebreaks == null || this.pagebreaks.length < proc.pagebreakCount) {
            this.pagebreaks = (long[])proc.pagebreaks.clone();
            this.pagebreakCount = proc.pagebreakCount;
        } else {
            System.arraycopy(proc.pagebreaks, 0, this.pagebreaks, 0, proc.pagebreakCount);
            this.pagebreakCount = proc.pagebreakCount;
        }
    }

    protected void initializeForLastLineAlignment(AbstractAlignmentProcessor proc) {
        this.lastLineAlignment = true;
        this.sequenceElements = proc.sequenceElements;
        this.nodes = proc.nodes;
        this.sequenceFill = proc.sequenceFill;
        this.pageGrid = proc.pageGrid;
        this.elementDimensions = proc.elementDimensions;
        this.elementPositions = proc.elementPositions;
        Arrays.fill(this.elementPositions, 0L);
        Arrays.fill(this.elementDimensions, 0L);
        this.startOfLine = proc.startOfLine;
        this.endOfLine = proc.endOfLine;
        this.updateBreaksForLastLineAlignment();
    }

    protected void updateBreaksForLastLineAlignment() {
        this.updateBreaks();
    }

    protected boolean isBorderMarker(InlineSequenceElement element) {
        return element == StartSequenceElement.INSTANCE || element == EndSequenceElement.INSTANCE;
    }

    protected boolean splitBreakableIfPossible() {
        RenderNode breakableNode;
        int breakableIndex = this.getBreakableIndex();
        if (breakableIndex >= 0 && (breakableNode = this.nodes[breakableIndex]) instanceof SplittableRenderNode) {
            RenderNode[] pair;
            long widthByLayout;
            long maxAllowedWidth;
            SplittableRenderNode splittableNode = (SplittableRenderNode)((Object)breakableNode);
            long widthExceeding = this.getBreakableMaxAllowedWidth();
            if (widthExceeding > 0L && (maxAllowedWidth = (widthByLayout = this.getElementDimensions()[breakableIndex]) > 0L ? widthByLayout - widthExceeding : splittableNode.getMinimumWidth() - widthExceeding) > 0L && (pair = splittableNode.splitBy(maxAllowedWidth)) != null) {
                this.reInitializeForHandlingComponentSplit(breakableIndex, pair);
                return true;
            }
        }
        return false;
    }

    static void shiftArray(Object[] array, int startIndex, int amount, int offset) {
        System.arraycopy(array, startIndex, array, startIndex + offset, amount);
    }

    @Deprecated
    void setNodes(RenderNode[] nodes) {
        this.nodes = nodes;
    }

    @Deprecated
    void setElementDimensions(long[] elementDimensions) {
        this.elementDimensions = elementDimensions;
    }

    protected void reInitializeForHandlingComponentSplit(int breakableIndex, RenderNode[] replacement) {
        int replacementAmountMinus1 = replacement.length - 1;
        int newSize = this.sequenceFill + replacementAmountMinus1;
        if (newSize > this.sequenceElements.length) {
            this.sequenceElements = Arrays.copyOf(this.sequenceElements, newSize);
            this.nodes = Arrays.copyOf(this.nodes, newSize);
            this.elementPositions = Arrays.copyOf(this.elementPositions, newSize);
            this.elementDimensions = Arrays.copyOf(this.elementDimensions, newSize);
        }
        int shiftedPartStartIndex = breakableIndex + 1;
        int shiftedPartLength = this.sequenceFill - shiftedPartStartIndex;
        AbstractAlignmentProcessor.shiftArray(this.sequenceElements, shiftedPartStartIndex, shiftedPartLength, replacementAmountMinus1);
        InlineSequenceElement breakableNodeType = this.sequenceElements[breakableIndex];
        Arrays.fill(this.sequenceElements, breakableIndex + 1, breakableIndex + replacement.length, breakableNodeType);
        AbstractAlignmentProcessor.shiftArray(this.nodes, shiftedPartStartIndex, shiftedPartLength, replacementAmountMinus1);
        System.arraycopy(replacement, 0, this.nodes, breakableIndex, replacement.length);
        this.sequenceFill = newSize;
    }
}

