/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.ParameterReportControllerPane;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;

public class PreviewParametersDialog
extends JDialog {
    private static final Log logger = LogFactory.getLog(PreviewParametersDialog.class);
    private MasterReport masterReport;
    private ParameterReportControllerPane parametersPanel;
    private boolean confirmed;
    private ResourceBundleSupport messages;
    private OkAction confirmAction;

    public PreviewParametersDialog(Frame parent, MasterReport report) {
        super(parent);
        this.initialize(report);
    }

    public PreviewParametersDialog(Dialog parent, MasterReport report) {
        super(parent);
        this.initialize(report);
    }

    public PreviewParametersDialog(MasterReport report) {
        this.initialize(report);
    }

    private void initialize(MasterReport report) {
        if (report == null) {
            throw new NullPointerException();
        }
        this.masterReport = report;
        this.messages = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.base.messages.messages", ObjectUtilities.getClassLoader(PreviewParametersDialog.class));
        this.confirmAction = new OkAction();
        this.setTitle(this.messages.getString("PreviewParametersDialog.Title"));
        this.setDefaultCloseOperation(2);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.createParametersPanel(), "Center");
        contentPane.add((Component)this.createButtonsPanel(), "South");
        this.setContentPane(contentPane);
        InputMap inputMap = contentPane.getInputMap();
        ActionMap actionMap = contentPane.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "confirm");
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        actionMap.put("confirm", new OkAction());
        actionMap.put("cancel", new CancelAction());
        this.setModal(true);
        this.pack();
        LibSwingUtil.centerDialogInParent((Dialog)this);
    }

    private JPanel createButtonsPanel() {
        JButton okButton = new JButton(this.confirmAction);
        okButton.setDefaultCapable(true);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new FlowLayout(2, 5, 5));
        buttonsPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY));
        buttonsPanel.add(okButton);
        buttonsPanel.add(new JButton(new CancelAction()));
        return buttonsPanel;
    }

    private JPanel createParametersPanel() {
        this.parametersPanel = new ParameterReportControllerPane();
        try {
            this.parametersPanel.setReport(this.masterReport);
        }
        catch (ReportProcessingException e) {
            this.parametersPanel.setErrorMessage(e.getMessage());
            logger.error((Object)"Failed to query parameters", (Throwable)e);
        }
        this.parametersPanel.hideControls();
        JPanel carrierPanel = new JPanel(new BorderLayout());
        carrierPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        carrierPanel.add((Component)this.parametersPanel, "North");
        return carrierPanel;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isAllParametersHidden(MasterReport report, ReportParameterDefinition parameterDefinition) {
        try (DefaultParameterContext parameterContext = new DefaultParameterContext(report);){
            ParameterDefinitionEntry[] entries = parameterDefinition.getParameterDefinitions();
            int i = 0;
            while (i < entries.length) {
                ParameterDefinitionEntry entry = entries[i];
                if (!"true".equals(entry.getParameterAttribute("http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core", "hidden", parameterContext))) {
                    boolean bl = false;
                    return bl;
                }
                ++i;
            }
            return true;
        }
        catch (ReportDataFactoryException e) {
            return false;
        }
        catch (ReportProcessingException e) {
            return false;
        }
    }

    public static boolean process(Window parent, MasterReport masterReport) {
        if (masterReport == null) {
            throw new NullPointerException();
        }
        ReportParameterDefinition parameterDefinition = masterReport.getParameterDefinition();
        if (parameterDefinition.getParameterCount() == 0) {
            return true;
        }
        if (PreviewParametersDialog.isAllParametersHidden(masterReport, parameterDefinition)) {
            return true;
        }
        PreviewParametersDialog parametersDialog = parent instanceof Frame ? new PreviewParametersDialog((Frame)parent, masterReport) : (parent instanceof Dialog ? new PreviewParametersDialog((Dialog)parent, masterReport) : new PreviewParametersDialog(masterReport));
        parametersDialog.setVisible(true);
        return parametersDialog.isConfirmed();
    }

    public class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", PreviewParametersDialog.this.messages.getString("PreviewParametersDialog.Cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent aEvt) {
            PreviewParametersDialog.this.confirmed = false;
            PreviewParametersDialog.this.dispose();
        }
    }

    public class OkAction
    extends AbstractAction {
        public OkAction() {
            this.putValue("Name", PreviewParametersDialog.this.messages.getString("PreviewParametersDialog.Ok"));
        }

        @Override
        public void actionPerformed(ActionEvent aEvt) {
            ReportParameterValues properties = PreviewParametersDialog.this.parametersPanel.getReportParameterValues();
            if (properties != null) {
                ReportParameterValues reportParameters = PreviewParametersDialog.this.masterReport.getParameterValues();
                String[] strings = properties.getColumnNames();
                for (int i = 0; i < strings.length; ++i) {
                    String propertyName = strings[i];
                    reportParameters.put(propertyName, properties.get(propertyName));
                }
            }
            PreviewParametersDialog.this.confirmed = true;
            PreviewParametersDialog.this.dispose();
        }
    }
}

