/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.common;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.IconTheme;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;

public class DefaultIconTheme
implements IconTheme {
    private String bundleName;

    public DefaultIconTheme() {
        this.initialize(ClassicEngineBoot.getInstance().getGlobalConfig());
    }

    @Override
    public void initialize(Configuration configuration) {
        this.bundleName = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.common.IconThemeBundle");
    }

    @Override
    public Icon getSmallIcon(Locale locale, String id) {
        return this.getResourceBundleSupport(locale).getIcon(id, false);
    }

    @Override
    public Icon getLargeIcon(Locale locale, String id) {
        return this.getResourceBundleSupport(locale).getIcon(id, true);
    }

    private ResourceBundleSupport getResourceBundleSupport(Locale locale) {
        if (this.bundleName == null) {
            throw new IllegalStateException("DefaultIconTheme.ERROR_0001_NO_RESOURCE_BUNDLE");
        }
        return new ResourceBundleSupport(locale, ResourceBundle.getBundle(this.bundleName, locale), ObjectUtilities.getClassLoader(DefaultIconTheme.class));
    }
}

