/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence;

import java.lang.reflect.Array;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.AbstractSequence;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.ArraySequenceDescription;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.SequenceDescription;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;

public class ArraySequence
extends AbstractSequence {
    @Override
    public SequenceDescription getSequenceDescription() {
        return new ArraySequenceDescription();
    }

    @Override
    public TableModel produce(DataRow parameters, DataFactoryContext dataFactoryContext) throws ReportDataFactoryException {
        String col = this.getTypedParameter("column", String.class);
        if (col == null) {
            throw new ReportDataFactoryException("Column parameter is not defined.");
        }
        String displayName = this.getTypedParameter("display-name", String.class, col);
        Object o = parameters.get(col);
        if (o == null || !o.getClass().isArray()) {
            return new TypedTableModel(new String[]{displayName});
        }
        TypedTableModel model = new TypedTableModel(new String[]{displayName}, new Class[]{o.getClass().getComponentType()});
        int length = Array.getLength(o);
        for (int i = 0; i < length; ++i) {
            model.addRow(Array.get(o, i));
        }
        return model;
    }
}

