/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.template;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.CellLayoutInfo;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.engine.classic.core.util.LongList;
import org.pentaho.reporting.libraries.base.util.GenericObjectTable;

public class FastGridLayout {
    private GenericObjectTable<GridCell> cells;
    private HashMap<InstanceID, Point> cellIndex;
    private LongList gridHeights = new LongList(20);

    public FastGridLayout() {
        this.cells = new GenericObjectTable();
        this.cellIndex = new HashMap();
    }

    public void addRow(int index, long rowHeight) {
        this.gridHeights.set(index, rowHeight);
    }

    public void addBackground(CellLayoutInfo layoutInfo) {
        this.cells.setObject(layoutInfo.getY1(), layoutInfo.getX1(), (Object)new GridCell(layoutInfo));
    }

    public void addContent(InstanceID instanceId, CellLayoutInfo layoutInfo) {
        this.cells.setObject(layoutInfo.getY1(), layoutInfo.getX1(), (Object)new ContentGridCell(layoutInfo, instanceId));
        this.cellIndex.put(instanceId, new Point(layoutInfo.getX1(), layoutInfo.getY1()));
    }

    public GridCell get(int row, int col) {
        return (GridCell)this.cells.getObject(row, col);
    }

    public LongList getCellHeights() {
        return this.gridHeights;
    }

    public Point getIndex(InstanceID id) {
        return this.cellIndex.get(id);
    }

    public int getRowCount() {
        return this.cells.getRowCount();
    }

    public int getColumnCount() {
        return this.cells.getColumnCount();
    }

    public List<InstanceID> getOrderedElements() {
        ArrayList<InstanceID> list = new ArrayList<InstanceID>();
        for (int y = 0; y < this.cells.getRowCount(); ++y) {
            for (int x = 0; x < this.cells.getColumnCount(); ++x) {
                GridCell object = (GridCell)this.cells.getObject(y, x);
                if (object.getInstanceId() == null) continue;
                list.add(object.getInstanceId());
            }
        }
        return list;
    }

    public static class ContentGridCell
    extends GridCell {
        private final InstanceID instanceId;

        private ContentGridCell(CellLayoutInfo background, InstanceID instanceId) {
            super(background);
            this.instanceId = instanceId;
        }

        @Override
        public InstanceID getInstanceId() {
            return this.instanceId;
        }
    }

    public static class GridCell {
        private CellLayoutInfo layoutInfo;

        private GridCell(CellLayoutInfo background) {
            this.layoutInfo = background;
        }

        public CellLayoutInfo getLayoutInfo() {
            return this.layoutInfo;
        }

        public InstanceID getInstanceId() {
            return null;
        }
    }
}

