/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.base;

import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableComplexText;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContent;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.model.SpacerRenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnGroupNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.RevalidateTextEllipseProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.text.GlyphList;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;

public class DefaultTextExtractor
extends IterateStructuralProcessStep {
    private StringBuffer text;
    private Object rawResult;
    private RenderNode rawSource;
    private StrictBounds paragraphBounds;
    private boolean overflowX;
    private boolean overflowY;
    private boolean textLineOverflow;
    private RevalidateTextEllipseProcessStep revalidateTextEllipseProcessStep;
    private CodePointBuffer codePointBuffer;
    private boolean manualBreak;
    private long contentAreaX2;
    private boolean ellipseDrawn;
    private boolean clipOnWordBoundary;

    public DefaultTextExtractor(OutputProcessorMetaData metaData) {
        if (metaData == null) {
            throw new NullPointerException();
        }
        this.codePointBuffer = new CodePointBuffer(400);
        this.text = new StringBuffer(400);
        this.paragraphBounds = new StrictBounds();
        this.revalidateTextEllipseProcessStep = new RevalidateTextEllipseProcessStep(metaData);
        this.clipOnWordBoundary = "true".equals(metaData.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.LastLineBreaksOnWordBoundary"));
    }

    protected CodePointBuffer getCodePointBuffer() {
        return this.codePointBuffer;
    }

    public Object compute(RenderBox box) {
        this.rawResult = null;
        this.rawSource = null;
        this.paragraphBounds.setRect(box.getX(), box.getY(), box.getWidth(), box.getHeight());
        this.overflowX = box.isBoxOverflowX();
        this.overflowY = box.isBoxOverflowY();
        this.clearText();
        this.startProcessing(box);
        if (this.rawResult != null) {
            return this.rawResult;
        }
        return this.text.toString();
    }

    public String getFormattedtext() {
        return this.text.toString();
    }

    private long extractEllipseSize(RenderNode node) {
        if (node == null) {
            return 0L;
        }
        RenderBox parent = node.getParent();
        if (parent == null) {
            return 0L;
        }
        RenderBox textEllipseBox = parent.getTextEllipseBox();
        if (textEllipseBox == null) {
            return 0L;
        }
        return textEllipseBox.getWidth();
    }

    @Override
    protected void processOtherNode(RenderNode node) {
        if (this.isTextLineOverflow() && this.handleOverflow(node)) {
            return;
        }
        int nodeType = node.getNodeType();
        if (nodeType == 17) {
            RenderableText textNode = (RenderableText)node;
            this.processStandardText(textNode);
            if (textNode.isForceLinebreak()) {
                this.manualBreak = true;
            }
        } else if (nodeType == 273) {
            RenderableComplexText textNode = (RenderableComplexText)node;
            if (this.processComplexText(textNode)) {
                return;
            }
            if (textNode.isForceLinebreak()) {
                this.manualBreak = true;
            }
        } else if (nodeType == 65) {
            SpacerRenderNode spacer = (SpacerRenderNode)node;
            int count = Math.max(1, spacer.getSpaceCount());
            for (int i = 0; i < count; ++i) {
                this.text.append(' ');
            }
        }
    }

    private boolean processComplexText(RenderableComplexText textNode) {
        if (this.isTextLineOverflow()) {
            long effectiveAreaX2;
            if (!textNode.isNodeVisible(this.paragraphBounds, this.overflowX, this.overflowY)) {
                return true;
            }
            long ellipseSize = this.extractEllipseSize(textNode);
            long x1 = textNode.getX();
            long x2 = x1 + textNode.getWidth();
            if (x2 <= (effectiveAreaX2 = this.contentAreaX2 - ellipseSize)) {
                this.drawComplexText(textNode);
            } else if (x1 < this.contentAreaX2) {
                RenderBox textEllipseBox;
                this.drawComplexText(textNode);
                RenderBox parent = textNode.getParent();
                if (parent != null && (textEllipseBox = parent.getTextEllipseBox()) != null) {
                    this.processBoxChilds(textEllipseBox);
                }
            }
        } else {
            this.drawComplexText(textNode);
        }
        return false;
    }

    private void processStandardText(RenderableText textNode) {
        if (this.isTextLineOverflow()) {
            long effectiveAreaX2;
            if (!textNode.isNodeVisible(this.paragraphBounds, this.overflowX, this.overflowY)) {
                return;
            }
            long ellipseSize = this.extractEllipseSize(textNode);
            long x1 = textNode.getX();
            long x2 = x1 + textNode.getWidth();
            if (x2 <= (effectiveAreaX2 = this.contentAreaX2 - ellipseSize)) {
                this.drawText(textNode, x2);
            } else if (x1 < this.contentAreaX2) {
                RenderBox textEllipseBox;
                this.drawText(textNode, effectiveAreaX2);
                RenderBox parent = textNode.getParent();
                if (parent != null && (textEllipseBox = parent.getTextEllipseBox()) != null) {
                    this.processBoxChilds(textEllipseBox);
                }
            }
        } else {
            this.drawText(textNode, textNode.getX() + textNode.getWidth());
        }
    }

    private boolean handleOverflow(RenderNode node) {
        if (!node.isNodeVisible(this.paragraphBounds, this.overflowX, this.overflowY)) {
            return true;
        }
        if (node.isVirtualNode()) {
            RenderBox textEllipseBox;
            long x1;
            RenderNode text;
            if (this.ellipseDrawn) {
                return true;
            }
            this.ellipseDrawn = true;
            int nodeType = node.getNodeType();
            if (!this.clipOnWordBoundary && nodeType == 17) {
                text = (RenderableText)node;
                long ellipseSize = this.extractEllipseSize(node);
                long x12 = text.getX();
                long effectiveAreaX2 = this.contentAreaX2 - ellipseSize;
                if (x12 < this.contentAreaX2) {
                    this.drawText((RenderableText)text, effectiveAreaX2);
                }
            } else if (!this.clipOnWordBoundary && nodeType == 273 && (x1 = (text = (RenderableComplexText)node).getX()) < this.contentAreaX2) {
                this.drawComplexText((RenderableComplexText)text);
            }
            RenderBox parent = node.getParent();
            if (parent != null && (textEllipseBox = parent.getTextEllipseBox()) != null) {
                this.processBoxChilds(textEllipseBox);
            }
            return true;
        }
        return false;
    }

    protected void drawText(RenderableText renderableText, long contentX2) {
        if (renderableText.getLength() == 0) {
            return;
        }
        GlyphList gs = renderableText.getGlyphs();
        int maxLength = renderableText.computeMaximumTextSize(contentX2);
        this.text.append(gs.getText(renderableText.getOffset(), maxLength, this.codePointBuffer));
    }

    protected void drawComplexText(RenderableComplexText renderableComplexText) {
        String text = renderableComplexText.getRawText();
        if (text.length() == 0) {
            return;
        }
        this.text.append(text);
    }

    @Override
    protected boolean startOtherBox(RenderBox box) {
        return false;
    }

    protected boolean isContentField(RenderBox box) {
        return box.getNodeType() == 258;
    }

    @Override
    protected boolean startCanvasBox(CanvasRenderBox box) {
        return true;
    }

    @Override
    protected void processRenderableContent(RenderableReplacedContentBox box) {
        RenderableReplacedContent rpc = box.getContent();
        this.rawResult = rpc.getRawObject();
        this.rawSource = box;
    }

    @Override
    protected boolean startBlockBox(BlockRenderBox box) {
        return box.getStaticBoxLayoutProperties().isVisible();
    }

    @Override
    protected boolean startRowBox(RenderBox box) {
        return box.getStaticBoxLayoutProperties().isVisible();
    }

    public RenderNode getRawSource() {
        return this.rawSource;
    }

    @Override
    protected boolean startInlineBox(InlineRenderBox box) {
        return box.getStaticBoxLayoutProperties().isVisible();
    }

    @Override
    protected boolean startTableCellBox(TableCellRenderBox box) {
        return box.getStaticBoxLayoutProperties().isVisible();
    }

    @Override
    protected boolean startTableRowBox(TableRowRenderBox box) {
        return box.getStaticBoxLayoutProperties().isVisible();
    }

    @Override
    protected boolean startTableSectionBox(TableSectionRenderBox box) {
        return box.getStaticBoxLayoutProperties().isVisible();
    }

    @Override
    protected boolean startTableColumnGroupBox(TableColumnGroupNode box) {
        return box.getStaticBoxLayoutProperties().isVisible();
    }

    @Override
    protected boolean startTableBox(TableRenderBox box) {
        return box.getStaticBoxLayoutProperties().isVisible();
    }

    @Override
    protected boolean startAutoBox(RenderBox box) {
        return box.getStaticBoxLayoutProperties().isVisible();
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox box) {
        this.rawResult = box.getRawValue();
        this.paragraphBounds.setRect(box.getX(), box.getY(), box.getWidth(), box.getHeight());
        this.overflowX = box.isBoxOverflowX();
        this.overflowY = box.isBoxOverflowY();
        long contentAreaX1 = box.getContentAreaX1();
        this.contentAreaX2 = box.getContentAreaX2();
        for (RenderBox lineBox = (RenderBox)box.getFirstChild(); lineBox != null; lineBox = (RenderBox)lineBox.getNext()) {
            this.manualBreak = false;
            this.processTextLine(lineBox, contentAreaX1, this.contentAreaX2);
            if (this.manualBreak) {
                this.addLinebreak();
                continue;
            }
            if (lineBox.getNext() == null) continue;
            if (!lineBox.getStaticBoxLayoutProperties().isPreserveSpace()) {
                this.addSoftBreak();
                continue;
            }
            this.addEmptyBreak();
        }
    }

    protected void addEmptyBreak() {
        this.text.append(' ');
    }

    protected void addSoftBreak() {
        this.text.append(' ');
    }

    protected void addLinebreak() {
        this.text.append('\n');
    }

    protected void processTextLine(RenderBox lineBox, long contentAreaX1, long contentAreaX2) {
        if (!lineBox.isNodeVisible(this.paragraphBounds, this.overflowX, this.overflowY)) {
            return;
        }
        this.ellipseDrawn = false;
        boolean overflowProperty = lineBox.getParent().getStaticBoxLayoutProperties().isOverflowX();
        boolean bl = this.textLineOverflow = lineBox.getX() + lineBox.getWidth() > contentAreaX2 && !overflowProperty;
        if (this.textLineOverflow) {
            this.revalidateTextEllipseProcessStep.compute(lineBox, contentAreaX1, contentAreaX2);
        }
        this.startProcessing(lineBox);
    }

    public Object getRawResult() {
        return this.rawResult;
    }

    protected void setRawResult(Object rawResult) {
        this.rawResult = rawResult;
    }

    public String getText() {
        return this.text.toString();
    }

    public int getTextLength() {
        return this.text.length();
    }

    protected void clearText() {
        this.text.delete(0, this.text.length());
    }

    protected StrictBounds getParagraphBounds() {
        return this.paragraphBounds;
    }

    public boolean isTextLineOverflow() {
        return this.textLineOverflow;
    }

    public boolean isOverflowX() {
        return this.overflowX;
    }

    public boolean isOverflowY() {
        return this.overflowY;
    }
}

