/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper;

import org.pentaho.reporting.engine.classic.core.ReportAttributeMap;
import org.pentaho.reporting.engine.classic.core.filter.types.bands.MasterReportType;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ExtendedConfigurationWrapper;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.fonts.awt.AWTFontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.DefaultFontStorage;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;

public class HtmlOutputProcessorMetaData
extends AbstractOutputProcessorMetaData {
    public static final int PAGINATION_NONE = 0;
    public static final int PAGINATION_MANUAL = 1;
    public static final int PAGINATION_FULL = 2;
    private int paginationMode;

    public HtmlOutputProcessorMetaData(int paginationMode) {
        this(HtmlOutputProcessorMetaData.createFontStorage(), paginationMode);
    }

    public HtmlOutputProcessorMetaData(FontStorage fontStorage, int paginationMode) {
        super(fontStorage);
        this.paginationMode = paginationMode;
    }

    private static FontStorage createFontStorage() {
        return new DefaultFontStorage((FontRegistry)new AWTFontRegistry());
    }

    @Override
    public void initialize(Configuration configuration) {
        ExtendedConfigurationWrapper extendedConfig;
        double deviceResolution;
        super.initialize(configuration);
        this.addFeature(OutputProcessorFeature.SPACING_SUPPORTED);
        String localStrict = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.StrictLayout");
        if (localStrict != null) {
            if ("true".equals(localStrict)) {
                this.addFeature(AbstractTableOutputProcessor.STRICT_LAYOUT);
            }
        } else {
            String globalStrict = configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.StrictLayout");
            if ("true".equals(globalStrict)) {
                this.addFeature(AbstractTableOutputProcessor.STRICT_LAYOUT);
            }
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.UsePageBands"))) {
            this.addFeature(OutputProcessorFeature.PAGE_SECTIONS);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.UsePageBands"))) {
            this.addFeature(OutputProcessorFeature.PAGE_SECTIONS);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.base.TreatEllipseAsRectangle"))) {
            this.addFeature(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.TreatEllipseAsRectangle"))) {
            this.addFeature(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE);
        }
        if ((deviceResolution = (double)(extendedConfig = new ExtendedConfigurationWrapper(configuration)).getIntProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.DeviceResolution", 0)) > 0.0) {
            this.setNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION, deviceResolution);
        }
        if (this.paginationMode == 2) {
            this.addFeature(OutputProcessorFeature.PAGEBREAKS);
        } else if (this.paginationMode == 1) {
            this.addFeature(OutputProcessorFeature.PAGEBREAKS);
            this.addFeature(OutputProcessorFeature.ITERATIVE_RENDERING);
            this.addFeature(OutputProcessorFeature.UNALIGNED_PAGEBANDS);
        } else {
            this.addFeature(OutputProcessorFeature.ITERATIVE_RENDERING);
            this.addFeature(OutputProcessorFeature.UNALIGNED_PAGEBANDS);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.AssumeOverflowX"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_X);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.AssumeOverflowY"))) {
            this.addFeature(OutputProcessorFeature.ASSUME_OVERFLOW_Y);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.ShapeAsContent"))) {
            this.addFeature(AbstractTableOutputProcessor.SHAPES_CONTENT);
        }
        if ("true".equals(configuration.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.table.html.RotatedTextAsImages"))) {
            this.addFeature(AbstractTableOutputProcessor.ROTATED_TEXT_AS_IMAGES);
        }
    }

    public int getPaginationMode() {
        return this.paginationMode;
    }

    @Override
    public String getExportDescriptor() {
        switch (this.paginationMode) {
            case 2: {
                return "table/html+pagination";
            }
            case 1: {
                return "table/html+flow";
            }
        }
        return "table/html+stream";
    }

    @Override
    public boolean isExtraContentElement(StyleSheet style, ReportAttributeMap attributes) {
        if (!this.isFeatureSupported(OutputProcessorFeature.DETECT_EXTRA_CONTENT)) {
            return false;
        }
        Object o = attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "element-type");
        if (o instanceof MasterReportType) {
            return false;
        }
        if (super.isExtraContentElement(style, attributes)) {
            return true;
        }
        if (!StringUtils.isEmpty((String)((String)attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-content")))) {
            return true;
        }
        return !StringUtils.isEmpty((String)((String)attributes.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/html", "extra-raw-footer-content")));
    }
}

