/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.helper.StyleBuilder;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class StoredStyle {
    private StyleBuilder.StyleCarrier[] styles;
    private int hashCode;

    public StoredStyle(StyleBuilder styleBuilder) {
        this.styles = styleBuilder.toArray();
        int hashCode = 1;
        for (StyleBuilder.StyleCarrier sc : this.styles) {
            if (sc != null) {
                StyleBuilder.CSSKeys s = sc.getKey();
                hashCode = s.hashCode() + hashCode * 23;
                continue;
            }
            hashCode *= 23;
        }
        this.hashCode = hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredStyle that = (StoredStyle)o;
        return Arrays.equals(this.styles, that.styles);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void print(Writer writer, boolean compact) throws IOException {
        String lineSeparator = StringUtils.getLineSeparator();
        boolean first = true;
        for (StyleBuilder.StyleCarrier sc : this.styles) {
            if (sc == null) continue;
            if (!first) {
                writer.write("; ");
            }
            if (!compact) {
                if (!first) {
                    writer.write(lineSeparator);
                }
                writer.write("    ");
            }
            writer.write(sc.getKey().getCssName());
            writer.write(": ");
            writer.write(sc.getValue());
            String unit = sc.getUnit();
            if (unit != null) {
                writer.write(unit);
            }
            first = false;
        }
    }

    public void print(StringBuffer buffer, boolean compact) {
        String lineSeparator = StringUtils.getLineSeparator();
        boolean first = true;
        for (StyleBuilder.StyleCarrier sc : this.styles) {
            if (sc == null) continue;
            if (!first) {
                buffer.append("; ");
            }
            if (!compact) {
                if (!first) {
                    buffer.append(lineSeparator);
                }
                buffer.append("    ");
            }
            buffer.append((Object)sc.getKey());
            buffer.append(": ");
            buffer.append(sc.getValue());
            String unit = sc.getUnit();
            if (unit != null) {
                buffer.append(unit);
            }
            first = false;
        }
    }
}

