/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper;

import java.awt.Color;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackground;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.HSSFCellStyleProducer;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextRotation;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;

public class ExcelCellStyleBuilder {
    private final Workbook workbook;
    private final CellStyle hssfCellStyle;
    private boolean isXLSX = false;

    public ExcelCellStyleBuilder(Workbook workbook) {
        this.workbook = workbook;
        this.hssfCellStyle = workbook.createCellStyle();
        this.isXLSX = this.hssfCellStyle instanceof XSSFCellStyle;
    }

    public void withRotation(StyleSheet element) {
        if (element == null) {
            return;
        }
        Object raw = element.getStyleProperty(TextStyleKeys.TEXT_ROTATION, null);
        if (raw == null) {
            return;
        }
        TextRotation rotation = (TextRotation)TextRotation.class.cast(raw);
        if (this.isXLSX) {
            short numericValue = rotation.getNumericValue();
            this.hssfCellStyle.setRotation(numericValue < 0 ? (short)(90 - numericValue) : numericValue);
        } else {
            this.hssfCellStyle.setRotation(rotation.getNumericValue());
        }
    }

    public void withElementStyle(StyleSheet elementStyleSheet, HSSFCellStyleProducer.HSSFCellStyleKey styleKey) {
        if (elementStyleSheet == null) {
            return;
        }
        this.hssfCellStyle.setAlignment(styleKey.getHorizontalAlignment());
        this.hssfCellStyle.setVerticalAlignment(styleKey.getVerticalAlignment());
        this.hssfCellStyle.setFont(this.workbook.getFontAt(styleKey.getFont()));
        this.hssfCellStyle.setWrapText(styleKey.isWrapText());
        this.hssfCellStyle.setIndention(styleKey.getIndention());
        if (styleKey.getDataStyle() >= 0) {
            this.hssfCellStyle.setDataFormat(styleKey.getDataStyle());
        }
    }

    public void withBackgroundStyle(CellBackground bg, HSSFCellStyleProducer.HSSFCellStyleKey styleKey) {
        if (bg == null) {
            return;
        }
        if (this.isXLSX) {
            this.xlsx_backgroundStyle(bg, styleKey);
        } else {
            this.xls_backgroundStyle(bg, styleKey);
        }
    }

    void xls_backgroundStyle(CellBackground bg, HSSFCellStyleProducer.HSSFCellStyleKey styleKey) {
        if (!BorderStyle.NONE.equals(bg.getBottom().getBorderStyle())) {
            this.hssfCellStyle.setBorderBottom(styleKey.getBorderStrokeBottom());
            this.hssfCellStyle.setBottomBorderColor(styleKey.getColorBottom());
        }
        if (!BorderStyle.NONE.equals(bg.getTop().getBorderStyle())) {
            this.hssfCellStyle.setBorderTop(styleKey.getBorderStrokeTop());
            this.hssfCellStyle.setTopBorderColor(styleKey.getColorTop());
        }
        if (!BorderStyle.NONE.equals(bg.getLeft().getBorderStyle())) {
            this.hssfCellStyle.setBorderLeft(styleKey.getBorderStrokeLeft());
            this.hssfCellStyle.setLeftBorderColor(styleKey.getColorLeft());
        }
        if (!BorderStyle.NONE.equals(bg.getRight().getBorderStyle())) {
            this.hssfCellStyle.setBorderRight(styleKey.getBorderStrokeRight());
            this.hssfCellStyle.setRightBorderColor(styleKey.getColorRight());
        }
        if (bg.getBackgroundColor() != null) {
            this.hssfCellStyle.setFillForegroundColor(styleKey.getColor());
            this.hssfCellStyle.setFillPattern((short)1);
        }
    }

    void xlsx_backgroundStyle(CellBackground bg, HSSFCellStyleProducer.HSSFCellStyleKey styleKey) {
        XSSFCellStyle xssfCellStyle = (XSSFCellStyle)this.hssfCellStyle;
        if (!BorderStyle.NONE.equals(bg.getBottom().getBorderStyle())) {
            this.hssfCellStyle.setBorderBottom(styleKey.getBorderStrokeBottom());
            xssfCellStyle.setBorderColor(XSSFCellBorder.BorderSide.BOTTOM, this.createXSSFColor(styleKey.getExtendedColorBottom()));
        }
        if (!BorderStyle.NONE.equals(bg.getTop().getBorderStyle())) {
            this.hssfCellStyle.setBorderTop(styleKey.getBorderStrokeTop());
            xssfCellStyle.setBorderColor(XSSFCellBorder.BorderSide.TOP, this.createXSSFColor(styleKey.getExtendedColorTop()));
        }
        if (!BorderStyle.NONE.equals(bg.getLeft().getBorderStyle())) {
            this.hssfCellStyle.setBorderLeft(styleKey.getBorderStrokeLeft());
            xssfCellStyle.setBorderColor(XSSFCellBorder.BorderSide.LEFT, this.createXSSFColor(styleKey.getExtendedColorLeft()));
        }
        if (!BorderStyle.NONE.equals(bg.getRight().getBorderStyle())) {
            this.hssfCellStyle.setBorderRight(styleKey.getBorderStrokeRight());
            xssfCellStyle.setBorderColor(XSSFCellBorder.BorderSide.RIGHT, this.createXSSFColor(styleKey.getExtendedColorRight()));
        }
        if (bg.getBackgroundColor() != null) {
            xssfCellStyle.setFillForegroundColor(this.createXSSFColor(styleKey.getExtendedColor()));
            this.hssfCellStyle.setFillPattern((short)1);
        }
    }

    public CellStyle build() {
        return this.hssfCellStyle;
    }

    XSSFColor createXSSFColor(Color clr) {
        byte[] rgb = new byte[]{-1, (byte)clr.getRed(), (byte)clr.getGreen(), (byte)clr.getBlue()};
        return new XSSFColor(rgb);
    }
}

