/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Workbook;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.LocalImageContainer;
import org.pentaho.reporting.engine.classic.core.URLImageContainer;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SlimSheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableRectangle;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.helper.ExcelPrinterBase;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.ImageUtils;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictBounds;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.encoder.UnsupportedEncoderException;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ExcelImageHandler {
    private static final Log logger = LogFactory.getLog(ExcelPrinter.class);
    private ResourceManager resourceManager;
    private ExcelPrinterBase printerBase;

    public ExcelImageHandler(ResourceManager resourceManager, ExcelPrinterBase printerBase) {
        ArgumentNullException.validate((String)"resourceManager", (Object)resourceManager);
        ArgumentNullException.validate((String)"printerBase", (Object)printerBase);
        this.resourceManager = resourceManager;
        this.printerBase = printerBase;
    }

    public void createImageCell(StyleSheet layoutContext, ImageContainer image, SlimSheetLayout currentLayout, TableRectangle rectangle, StrictBounds cellBounds) {
        try {
            int pictureId;
            StrictBounds cb;
            if (rectangle == null) {
                logger.debug((Object)"Invalid reference: I was not able to compute the rectangle for the content.");
                return;
            }
            boolean shouldScale = layoutContext.getBooleanStyleProperty(ElementStyleKeys.SCALE);
            int imageWidth = image.getImageWidth();
            int imageHeight = image.getImageHeight();
            if (imageWidth < 1 || imageHeight < 1) {
                return;
            }
            double scaleFactor = this.computeImageScaleFactor();
            ElementAlignment horizontalAlignment = (ElementAlignment)layoutContext.getStyleProperty(ElementStyleKeys.ALIGNMENT);
            ElementAlignment verticalAlignment = (ElementAlignment)layoutContext.getStyleProperty(ElementStyleKeys.VALIGNMENT);
            long internalImageWidth = StrictGeomUtility.toInternalValue(scaleFactor * (double)imageWidth);
            long internalImageHeight = StrictGeomUtility.toInternalValue(scaleFactor * (double)imageHeight);
            long cellWidth = cellBounds.getWidth();
            long cellHeight = cellBounds.getHeight();
            try {
                if (shouldScale) {
                    double scaleY;
                    double scaleX;
                    boolean keepAspectRatio = layoutContext.getBooleanStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO);
                    if (keepAspectRatio) {
                        double imgScaleFactor;
                        scaleX = imgScaleFactor = Math.min((double)cellWidth / (double)internalImageWidth, (double)cellHeight / (double)internalImageHeight);
                        scaleY = imgScaleFactor;
                    } else {
                        scaleX = (double)cellWidth / (double)internalImageWidth;
                        scaleY = (double)cellHeight / (double)internalImageHeight;
                    }
                    long clipWidth = (long)(scaleX * (double)internalImageWidth);
                    long clipHeight = (long)(scaleY * (double)internalImageHeight);
                    long alignmentX = RenderUtility.computeHorizontalAlignment(horizontalAlignment, cellWidth, clipWidth);
                    long alignmentY = RenderUtility.computeVerticalAlignment(verticalAlignment, cellHeight, clipHeight);
                    cb = new StrictBounds(cellBounds.getX() + alignmentX, cellBounds.getY() + alignmentY, Math.min(clipWidth, cellWidth), Math.min(clipHeight, cellHeight));
                    rectangle = currentLayout.getTableBounds(cb, rectangle);
                    pictureId = this.loadImage(image);
                    if (this.printerBase.isUseXlsxFormat() ? pictureId < 0 : pictureId <= 0) {
                        return;
                    }
                } else if (internalImageWidth <= cellWidth && internalImageHeight <= cellHeight) {
                    long alignmentX = RenderUtility.computeHorizontalAlignment(horizontalAlignment, cellBounds.getWidth(), internalImageWidth);
                    long alignmentY = RenderUtility.computeVerticalAlignment(verticalAlignment, cellBounds.getHeight(), internalImageHeight);
                    cb = new StrictBounds(cellBounds.getX() + alignmentX, cellBounds.getY() + alignmentY, internalImageWidth, internalImageHeight);
                    rectangle = currentLayout.getTableBounds(cb, rectangle);
                    pictureId = this.loadImage(image);
                    if (this.printerBase.isUseXlsxFormat() ? pictureId < 0 : pictureId <= 0) {
                        return;
                    }
                } else {
                    long clipWidth = Math.min(cellWidth, internalImageWidth);
                    long clipHeight = Math.min(cellHeight, internalImageHeight);
                    long alignmentX = RenderUtility.computeHorizontalAlignment(horizontalAlignment, cellBounds.getWidth(), clipWidth);
                    long alignmentY = RenderUtility.computeVerticalAlignment(verticalAlignment, cellBounds.getHeight(), clipHeight);
                    cb = new StrictBounds(cellBounds.getX() + alignmentX, cellBounds.getY() + alignmentY, clipWidth, clipHeight);
                    rectangle = currentLayout.getTableBounds(cb, rectangle);
                    pictureId = this.loadImageWithClipping(image, clipWidth, clipHeight, scaleFactor);
                    if (this.printerBase.isUseXlsxFormat() ? pictureId < 0 : pictureId <= 0) {
                        return;
                    }
                }
            }
            catch (UnsupportedEncoderException uee) {
                logger.warn((Object)"Assertation-Failure: PNG encoding failed.", (Throwable)uee);
                return;
            }
            ClientAnchor anchor = this.computeClientAnchor(currentLayout, rectangle, cb);
            Drawing patriarch = this.printerBase.getDrawingPatriarch();
            Picture picture = patriarch.createPicture(anchor, pictureId);
            logger.info((Object)String.format("Created image: %d => %s", pictureId, picture));
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to add image. Ignoring.", (Throwable)e);
        }
    }

    private double computeImageScaleFactor() {
        OutputProcessorMetaData metaData = this.printerBase.getMetaData();
        double devResolution = metaData.getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION);
        double scaleFactor = metaData.isFeatureSupported(OutputProcessorFeature.IMAGE_RESOLUTION_MAPPING) ? (devResolution != 72.0 && devResolution > 0.0 ? 72.0 / devResolution : 1.0) : 1.0;
        return scaleFactor;
    }

    protected ClientAnchor computeClientAnchor(SlimSheetLayout currentLayout, TableRectangle rectangle, StrictBounds cb) {
        if (this.printerBase.isUseXlsxFormat()) {
            return this.computeExcel2003ClientAnchor(currentLayout, rectangle, cb);
        }
        return this.computeExcel97ClientAnchor(currentLayout, rectangle, cb);
    }

    protected ClientAnchor computeExcel97ClientAnchor(SlimSheetLayout currentLayout, TableRectangle rectangle, StrictBounds cb) {
        int cell1x = rectangle.getX1();
        int cell1y = rectangle.getY1();
        int cell2x = Math.max(cell1x, rectangle.getX2() - 1);
        int cell2y = Math.max(cell1y, rectangle.getY2() - 1);
        long cell1width = currentLayout.getCellWidth(cell1x);
        long cell1height = currentLayout.getRowHeight(cell1y);
        long cell2width = currentLayout.getCellWidth(cell2x);
        long cell2height = currentLayout.getRowHeight(cell2y);
        long cell1xPos = currentLayout.getXPosition(cell1x);
        long cell1yPos = currentLayout.getYPosition(cell1y);
        long cell2xPos = currentLayout.getXPosition(cell2x);
        long cell2yPos = currentLayout.getYPosition(cell2y);
        int dx1 = (int)(1023.0 * ((double)(cb.getX() - cell1xPos) / (double)cell1width));
        int dy1 = (int)(255.0 * ((double)(cb.getY() - cell1yPos) / (double)cell1height));
        int dx2 = (int)(1023.0 * ((double)(cb.getX() + cb.getWidth() - cell2xPos) / (double)cell2width));
        int dy2 = (int)(255.0 * ((double)(cb.getY() + cb.getHeight() - cell2yPos) / (double)cell2height));
        ClientAnchor anchor = this.printerBase.getWorkbook().getCreationHelper().createClientAnchor();
        anchor.setDx1(dx1);
        anchor.setDy1(dy1);
        anchor.setDx2(dx2);
        anchor.setDy2(dy2);
        anchor.setCol1(cell1x);
        anchor.setRow1(cell1y);
        anchor.setCol2(cell2x);
        anchor.setRow2(cell2y);
        anchor.setAnchorType(2);
        return anchor;
    }

    protected ClientAnchor computeExcel2003ClientAnchor(SlimSheetLayout currentLayout, TableRectangle rectangle, StrictBounds cb) {
        int cell1x = rectangle.getX1();
        int cell1y = rectangle.getY1();
        int cell2x = Math.max(cell1x, rectangle.getX2() - 1);
        int cell2y = Math.max(cell1y, rectangle.getY2() - 1);
        long cell1xPos = currentLayout.getXPosition(cell1x);
        long cell1yPos = currentLayout.getYPosition(cell1y);
        long cell2xPos = currentLayout.getXPosition(cell2x);
        long cell2yPos = currentLayout.getYPosition(cell2y);
        int dx1 = (int)StrictGeomUtility.toExternalValue((cb.getX() - cell1xPos) * 12700L);
        int dy1 = (int)StrictGeomUtility.toExternalValue((cb.getY() - cell1yPos) * 12700L);
        int dx2 = (int)Math.max(0.0, StrictGeomUtility.toExternalValue((cb.getX() + cb.getWidth() - cell2xPos) * 12700L));
        int dy2 = (int)Math.max(0.0, StrictGeomUtility.toExternalValue((cb.getY() + cb.getHeight() - cell2yPos) * 12700L));
        ClientAnchor anchor = this.printerBase.getWorkbook().getCreationHelper().createClientAnchor();
        anchor.setDx1(dx1);
        anchor.setDy1(dy1);
        anchor.setDx2(dx2);
        anchor.setDy2(dy2);
        anchor.setCol1(cell1x);
        anchor.setRow1(cell1y);
        anchor.setCol2(cell2x);
        anchor.setRow2(cell2y);
        anchor.setAnchorType(2);
        return anchor;
    }

    private int getImageFormat(ResourceKey key) {
        URL url = this.resourceManager.toURL(key);
        if (url == null) {
            return -1;
        }
        String file = url.getFile();
        if (StringUtils.endsWithIgnoreCase((String)file, (String)".png")) {
            return 6;
        }
        if (StringUtils.endsWithIgnoreCase((String)file, (String)".jpg") || StringUtils.endsWithIgnoreCase((String)file, (String)".jpeg")) {
            return 5;
        }
        if (StringUtils.endsWithIgnoreCase((String)file, (String)".bmp") || StringUtils.endsWithIgnoreCase((String)file, (String)".ico")) {
            return 7;
        }
        return -1;
    }

    private int loadImageWithClipping(ImageContainer reference, long clipWidth, long clipHeight, double deviceScaleFactor) throws IOException, UnsupportedEncoderException {
        URLImageContainer urlImage;
        ResourceKey url;
        Image image = null;
        if (reference instanceof URLImageContainer && (url = (urlImage = (URLImageContainer)reference).getResourceKey()) != null && urlImage.isLoadable()) {
            if (reference instanceof LocalImageContainer) {
                LocalImageContainer li = (LocalImageContainer)reference;
                image = li.getImage();
            }
            if (image == null) {
                try {
                    Resource resource = this.resourceManager.create(url, null, Image.class);
                    image = (Image)resource.getResource();
                }
                catch (ResourceException resourceException) {
                    // empty catch block
                }
            }
        }
        if (reference instanceof LocalImageContainer) {
            LocalImageContainer li = (LocalImageContainer)reference;
            if (image == null) {
                image = li.getImage();
            }
        }
        if (image != null) {
            return this.clipAndEncodeImage(image, clipWidth, clipHeight, deviceScaleFactor);
        }
        return -1;
    }

    private int clipAndEncodeImage(Image image, long width, long height, double deviceScaleFactor) throws UnsupportedEncoderException, IOException {
        Graphics2D graphics;
        BufferedImage bi;
        block2: {
            block1: {
                int imageWidth = (int)StrictGeomUtility.toExternalValue(width);
                int imageHeight = (int)StrictGeomUtility.toExternalValue(height);
                bi = ImageUtils.createTransparentImage(imageWidth, imageHeight);
                graphics = (Graphics2D)bi.getGraphics();
                graphics.scale(deviceScaleFactor, deviceScaleFactor);
                if (!(image instanceof BufferedImage)) break block1;
                if (graphics.drawImage(image, null, null)) break block2;
                logger.debug((Object)"Failed to render the image. This should not happen for BufferedImages");
                break block2;
            }
            WaitingImageObserver obs = new WaitingImageObserver(image);
            obs.waitImageLoaded();
            while (!graphics.drawImage(image, null, (ImageObserver)obs)) {
                obs.waitImageLoaded();
                if (!obs.isError()) continue;
                logger.warn((Object)"Error while loading the image during the rendering.");
                break;
            }
        }
        graphics.dispose();
        byte[] data = RenderUtility.encodeImage(bi);
        return this.printerBase.getWorkbook().addPicture(data, 6);
    }

    private int loadImage(ImageContainer reference) throws IOException, UnsupportedEncoderException {
        URLImageContainer urlImage;
        ResourceKey url;
        Workbook workbook = this.printerBase.getWorkbook();
        Image image = null;
        if (reference instanceof URLImageContainer && (url = (urlImage = (URLImageContainer)reference).getResourceKey()) != null && urlImage.isLoadable()) {
            int format = this.getImageFormat(url);
            if (format == -1) {
                if (reference instanceof LocalImageContainer) {
                    LocalImageContainer li = (LocalImageContainer)reference;
                    image = li.getImage();
                }
                if (image == null) {
                    try {
                        Resource resource = this.resourceManager.create(url, null, Image.class);
                        image = (Image)resource.getResource();
                    }
                    catch (ResourceException re) {
                        logger.info((Object)("Failed to load image from URL " + url), (Throwable)re);
                    }
                }
            } else {
                try {
                    ResourceData data = this.resourceManager.load(url);
                    return workbook.addPicture(data.getResource(this.resourceManager), format);
                }
                catch (ResourceException re) {
                    logger.info((Object)("Failed to load image from URL " + url), (Throwable)re);
                }
            }
        }
        if (reference instanceof LocalImageContainer) {
            LocalImageContainer li = (LocalImageContainer)reference;
            if (image == null) {
                image = li.getImage();
            }
        }
        if (image != null) {
            byte[] data = RenderUtility.encodeImage(image);
            return workbook.addPicture(data, 6);
        }
        return -1;
    }
}

