/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.AbstractObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectFactoryException;

public class ArrayObjectDescription
extends AbstractObjectDescription {
    private static final Log logger = LogFactory.getLog(ArrayObjectDescription.class);

    public ArrayObjectDescription(Class c) {
        super(c);
        if (!c.isArray()) {
            throw new IllegalArgumentException("Need an array class");
        }
    }

    @Override
    public Object createObject() {
        try {
            Integer size = (Integer)this.getParameter("size");
            if (size == null) {
                Object value;
                ArrayList<Object> l = new ArrayList<Object>();
                int counter = 0;
                while (this.getParameterDefinition(String.valueOf(counter)) != null && (value = this.getParameter(String.valueOf(counter))) != null) {
                    l.add(value);
                    ++counter;
                }
                Object o = Array.newInstance(this.getObjectClass().getComponentType(), l.size());
                for (int i = 0; i < l.size(); ++i) {
                    Array.set(o, i, l.get(i));
                }
                return o;
            }
            Object o = Array.newInstance(this.getObjectClass().getComponentType(), (int)size);
            for (int i = 0; i < size; ++i) {
                Array.set(o, i, this.getParameter(String.valueOf(i)));
            }
            return o;
        }
        catch (Exception ie) {
            logger.warn((Object)"Unable to instantiate Object", (Throwable)ie);
            return null;
        }
    }

    @Override
    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (o == null) {
            throw new ObjectFactoryException("Given object is null.");
        }
        if (!o.getClass().isArray()) {
            throw new ObjectFactoryException("Given object is no array");
        }
        if (!this.getObjectClass().isAssignableFrom(o.getClass())) {
            throw new ObjectFactoryException("Given object is incompatible with base class");
        }
        int size = Array.getLength(o);
        this.setParameter("size", new Integer(size));
        for (int i = 0; i < size; ++i) {
            this.setParameter(String.valueOf(i), Array.get(o, i));
        }
    }

    private int parseParameterName(String name) {
        try {
            return Integer.parseInt(name);
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public Class getParameterDefinition(String name) {
        if ("size".equals(name)) {
            return Integer.TYPE;
        }
        int par = this.parseParameterName(name);
        if (par < 0) {
            return null;
        }
        return this.getObjectClass().getComponentType();
    }

    @Override
    public synchronized Iterator getParameterNames() {
        Integer size = (Integer)this.getParameter("size");
        if (size == null) {
            return this.getDefinedParameterNames();
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add("size");
        for (int i = 0; i < size; ++i) {
            l.add(String.valueOf(i));
        }
        return l.iterator();
    }

    @Override
    public ObjectDescription getInstance() {
        return new ArrayObjectDescription(this.getObjectClass());
    }
}

