/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.extwriter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ClassFactoryCollector;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectFactoryException;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.AbstractXMLDefinitionWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ObjectWriter;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.engine.classic.core.style.BandDefaultStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ElementDefaultStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class StyleWriter
extends AbstractXMLDefinitionWriter {
    private ElementStyleSheet elementStyleSheet;

    public StyleWriter(ReportWriterContext reportWriter, ElementStyleSheet elementStyleSheet, XmlWriter writer) {
        super(reportWriter, writer);
        if (elementStyleSheet == null) {
            throw new NullPointerException();
        }
        this.elementStyleSheet = elementStyleSheet;
    }

    @Override
    public void write() throws IOException, ReportWriterException {
        StyleKey[] namesArray;
        for (StyleKey key : namesArray = this.elementStyleSheet.getDefinedPropertyNamesArray()) {
            Object value;
            if (key == null || key.isTransient() || (value = this.elementStyleSheet.getStyleProperty(key)) == null) continue;
            this.writeKeyValue(key, value);
        }
    }

    private ObjectDescription findObjectDescription(StyleKey key, Object o) {
        ClassFactoryCollector cc = this.getReportWriter().getClassFactoryCollector();
        ObjectDescription od = cc.getDescriptionForClass(o.getClass());
        if (od != null) {
            return od;
        }
        od = cc.getDescriptionForClass(key.getValueType());
        if (od == null) {
            od = cc.getSuperClassObjectDescription(o.getClass(), od);
        }
        if (od == null) {
            od = cc.getSuperClassObjectDescription(key.getValueType(), od);
        }
        return od;
    }

    private boolean isUseKeyObjectDescription(StyleKey key, Object o) {
        ClassFactoryCollector cc = this.getReportWriter().getClassFactoryCollector();
        ObjectDescription odObject = cc.getDescriptionForClass(o.getClass());
        ObjectDescription odKey = cc.getDescriptionForClass(key.getValueType());
        if (odObject == null) {
            odObject = cc.getSuperClassObjectDescription(o.getClass(), odObject);
        }
        if (odKey == null) {
            odKey = cc.getSuperClassObjectDescription(key.getValueType(), odKey);
        }
        return ObjectUtilities.equal((Object)odKey, (Object)odObject);
    }

    private void writeKeyValue(StyleKey key, Object o) throws IOException, ReportWriterException {
        ObjectDescription od = this.findObjectDescription(key, o);
        if (od == null) {
            throw new ReportWriterException("Unable to find object description for key: " + key.getName());
        }
        try {
            od.setParameterFromObject(o);
        }
        catch (ObjectFactoryException e) {
            throw new ReportWriterException("Unable to fill the parameters for key: " + key.getName(), e);
        }
        StyleKey keyFromFactory = this.getReportWriter().getStyleKeyFactoryCollector().getStyleKey(key.getName());
        if (keyFromFactory == null) {
            throw new ReportWriterException("The stylekey " + key.getName() + " has no corresponding key description.");
        }
        AttributeList p = new AttributeList();
        p.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "name", key.getName());
        if (!this.isUseKeyObjectDescription(key, o)) {
            p.setAttribute("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "class", o.getClass().getName());
        }
        XmlWriter writer = this.getXmlWriter();
        ArrayList parameterNames = this.getParameterNames(od);
        if (this.isBasicKey(parameterNames, od)) {
            writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "basic-key", p, false);
            writer.writeTextNormalized((String)od.getParameter("value"), false);
            writer.writeCloseTag();
        } else {
            writer.writeTag("http://jfreereport.sourceforge.net/namespaces/reports/legacy/ext", "compound-key", p, false);
            ObjectWriter objWriter = new ObjectWriter(this.getReportWriter(), o, od, writer);
            objWriter.write();
            writer.writeCloseTag();
        }
    }

    private boolean isBasicKey(List parameters, ObjectDescription od) {
        String param;
        return parameters.size() == 1 && "value".equals(param = (String)parameters.get(0)) && od.getParameterDefinition("value").equals(String.class);
    }

    private ArrayList getParameterNames(ObjectDescription d) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = d.getParameterNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            list.add(name);
        }
        return list;
    }

    private boolean isDefaultStyleSheet(ElementStyleSheet es) {
        if (es == BandDefaultStyleSheet.getBandDefaultStyle()) {
            return true;
        }
        if (es == ElementDefaultStyleSheet.getDefaultStyle()) {
            return true;
        }
        return es == Watermark.getDefaultStyle();
    }
}

