/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.style.css;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.pentaho.reporting.engine.classic.core.style.css.CSSParseException;
import org.pentaho.reporting.engine.classic.core.style.css.CSSParserFactory;
import org.pentaho.reporting.engine.classic.core.style.css.namespaces.DefaultNamespaceCollection;
import org.pentaho.reporting.engine.classic.core.style.css.namespaces.DefaultNamespaceDefinition;
import org.pentaho.reporting.engine.classic.core.style.css.namespaces.NamespaceCollection;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.SelectorList;

public class StyleSheetParserUtil {
    private static final StyleSheetParserUtil instance = new StyleSheetParserUtil();
    private DefaultNamespaceCollection namespaceCollection = new DefaultNamespaceCollection();

    public static StyleSheetParserUtil getInstance() {
        return instance;
    }

    private StyleSheetParserUtil() {
        this.addNamespaceDefinition("http://reporting.pentaho.org/namespaces/engine/attributes/html", "html");
        this.addNamespaceDefinition("http://reporting.pentaho.org/namespaces/engine/attributes/core", "style-class", "core");
        this.addNamespaceDefinition("http://reporting.pentaho.org/namespaces/engine/attributes/pdf", "pdf");
        this.addNamespaceDefinition("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "crosstab");
        this.addNamespaceDefinition("http://reporting.pentaho.org/namespaces/engine/attributes/excel", "excel");
        this.addNamespaceDefinition("http://reporting.pentaho.org/namespaces/engine/attributes/swing", "action");
        this.addNamespaceDefinition("http://reporting.pentaho.org/namespaces/engine/attributes/internal", "internal");
        this.addNamespaceDefinition("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "wizard");
        this.addNamespaceDefinition("http://reporting.pentaho.org/namespaces/engine/attributes/pentaho", "pentaho");
        this.addNamespaceDefinition("http://reporting.pentaho.org/namespaces/engine/attributes/table", "table");
        this.addNamespaceDefinition("http://www.w3.org/XML/1998/namespace", "xml");
        this.namespaceCollection.setDefaultNamespaceURI("http://reporting.pentaho.org/namespaces/engine/attributes/core");
    }

    public void addNamespaceDefinition(String uri, String preferredPrefix) {
        this.namespaceCollection.addDefinition(new DefaultNamespaceDefinition(uri, null, null, null, preferredPrefix));
    }

    public void addNamespaceDefinition(String uri, String classAttribute, String preferredPrefix) {
        this.namespaceCollection.addDefinition(new DefaultNamespaceDefinition(uri, null, classAttribute, null, preferredPrefix));
    }

    public void addNamespaceDefinition(String uri, ResourceKey defaultStyleSheet, String classAttribute, String styleAttribute, String preferredPrefix) {
        this.namespaceCollection.addDefinition(new DefaultNamespaceDefinition(uri, defaultStyleSheet, classAttribute, styleAttribute, preferredPrefix));
    }

    public NamespaceCollection getNamespaceCollection() {
        return this.namespaceCollection;
    }

    public String[] parseNamespaceIdent(String attrName, NamespaceCollection namespaceCollection) {
        String name;
        String namespace;
        StringTokenizer strtok = new StringTokenizer(attrName, "|");
        if (strtok.countTokens() == 2) {
            String tkNamespace = strtok.nextToken();
            namespace = tkNamespace.length() == 0 ? null : ("*".equals(tkNamespace) ? "*" : namespaceCollection.lookupNamespaceURI(tkNamespace));
            name = strtok.nextToken();
        } else {
            name = strtok.nextToken();
            namespace = null;
        }
        return new String[]{namespace, name};
    }

    public SelectorList parseSelector(NamespaceCollection nc, String selectorText) throws CSSParseException {
        try {
            return CSSParserFactory.getInstance().createCSSParser(nc).parseSelectors(new InputSource((Reader)new StringReader(selectorText)));
        }
        catch (CSSException e) {
            throw new CSSParseException("Failed to parse selector", e);
        }
        catch (InstantiationException e) {
            throw new CSSParseException("Failed to instantiate CSS parser", e);
        }
        catch (IOException e) {
            throw new CSSParseException("IO error while parsing selector", e);
        }
    }
}

