/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.http;

import com.cloudera.com.amazonaws.AmazonWebServiceClient;
import com.cloudera.com.amazonaws.auth.AWSCredentials;
import com.cloudera.com.amazonaws.auth.Signer;
import com.cloudera.com.amazonaws.handlers.RequestHandler2;
import com.cloudera.com.amazonaws.retry.internal.AuthErrorRetryStrategy;
import com.cloudera.com.amazonaws.util.AWSRequestMetrics;
import com.cloudera.com.amazonaws.util.AWSRequestMetricsFullSupport;
import com.cloudera.org.apache.http.annotation.NotThreadSafe;
import java.net.URI;
import java.util.List;

@NotThreadSafe
public class ExecutionContext {
    private final AWSRequestMetrics awsRequestMetrics;
    private final List<RequestHandler2> requestHandler2s;
    private String contextUserAgent;
    private final AmazonWebServiceClient awsClient;
    private AWSCredentials credentials;
    private AuthErrorRetryStrategy authErrorRetryStrategy;

    public ExecutionContext(boolean isMetricEnabled) {
        this(null, isMetricEnabled, null);
    }

    public ExecutionContext() {
        this(null, false, null);
    }

    public ExecutionContext(List<RequestHandler2> requestHandler2s, boolean isMetricEnabled, AmazonWebServiceClient awsClient) {
        this.requestHandler2s = requestHandler2s;
        this.awsRequestMetrics = isMetricEnabled ? new AWSRequestMetricsFullSupport() : new AWSRequestMetrics();
        this.awsClient = awsClient;
    }

    public String getContextUserAgent() {
        return this.contextUserAgent;
    }

    public void setContextUserAgent(String contextUserAgent) {
        this.contextUserAgent = contextUserAgent;
    }

    public List<RequestHandler2> getRequestHandler2s() {
        return this.requestHandler2s;
    }

    public AWSRequestMetrics getAwsRequestMetrics() {
        return this.awsRequestMetrics;
    }

    protected AmazonWebServiceClient getAwsClient() {
        return this.awsClient;
    }

    public void setSigner(Signer signer) {
    }

    public Signer getSignerByURI(URI uri) {
        return this.awsClient == null ? null : this.awsClient.getSignerByURI(uri);
    }

    public AWSCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(AWSCredentials credentials) {
        this.credentials = credentials;
    }

    public AuthErrorRetryStrategy getAuthErrorRetryStrategy() {
        return this.authErrorRetryStrategy;
    }

    public void setAuthErrorRetryStrategy(AuthErrorRetryStrategy authErrorRetryStrategy) {
        this.authErrorRetryStrategy = authErrorRetryStrategy;
    }
}

