/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.amazonaws.http.impl.client;

import com.cloudera.com.amazonaws.util.AWSRequestMetrics;
import com.cloudera.org.apache.http.annotation.ThreadSafe;
import com.cloudera.org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import com.cloudera.org.apache.http.protocol.HttpContext;
import java.io.IOException;

@ThreadSafe
public class SdkHttpRequestRetryHandler
extends DefaultHttpRequestRetryHandler {
    public static final SdkHttpRequestRetryHandler Singleton = new SdkHttpRequestRetryHandler();

    private SdkHttpRequestRetryHandler() {
    }

    @Override
    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        AWSRequestMetrics awsRequestMetrics;
        boolean retry = super.retryRequest(exception, executionCount, context);
        if (retry && (awsRequestMetrics = (AWSRequestMetrics)context.getAttribute(AWSRequestMetrics.class.getSimpleName())) != null) {
            awsRequestMetrics.incrementCounter(AWSRequestMetrics.Field.HttpClientRetryCount);
        }
        return retry;
    }
}

