/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.com.fasterxml.jackson.databind.type;

import com.cloudera.com.fasterxml.jackson.databind.JavaType;
import com.cloudera.com.fasterxml.jackson.databind.type.SimpleType;
import com.cloudera.com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class TypeBindings {
    private static final JavaType[] NO_TYPES = new JavaType[0];
    public static final JavaType UNBOUND = new SimpleType(Object.class);
    protected final TypeFactory _typeFactory;
    protected final JavaType _contextType;
    protected final Class<?> _contextClass;
    protected Map<String, JavaType> _bindings;
    protected HashSet<String> _placeholders;
    private final TypeBindings _parentBindings;

    public TypeBindings(TypeFactory typeFactory, Class<?> clazz) {
        this(typeFactory, null, clazz, null);
    }

    public TypeBindings(TypeFactory typeFactory, JavaType javaType) {
        this(typeFactory, null, javaType.getRawClass(), javaType);
    }

    public TypeBindings childInstance() {
        return new TypeBindings(this._typeFactory, this, this._contextClass, this._contextType);
    }

    private TypeBindings(TypeFactory typeFactory, TypeBindings typeBindings, Class<?> clazz, JavaType javaType) {
        this._typeFactory = typeFactory;
        this._parentBindings = typeBindings;
        this._contextClass = clazz;
        this._contextType = javaType;
    }

    public JavaType resolveType(Class<?> clazz) {
        return this._typeFactory._constructType(clazz, this);
    }

    public JavaType resolveType(Type type) {
        return this._typeFactory._constructType(type, this);
    }

    public int getBindingCount() {
        if (this._bindings == null) {
            this._resolve();
        }
        return this._bindings.size();
    }

    public JavaType findType(String string) {
        Object object;
        JavaType javaType;
        if (this._bindings == null) {
            this._resolve();
        }
        if ((javaType = this._bindings.get(string)) != null) {
            return javaType;
        }
        if (this._placeholders != null && this._placeholders.contains(string)) {
            return UNBOUND;
        }
        if (this._parentBindings != null) {
            return this._parentBindings.findType(string);
        }
        if (this._contextClass != null && (object = this._contextClass.getEnclosingClass()) != null && !Modifier.isStatic(this._contextClass.getModifiers())) {
            return UNBOUND;
        }
        object = this._contextClass != null ? this._contextClass.getName() : (this._contextType != null ? this._contextType.toString() : "UNKNOWN");
        throw new IllegalArgumentException("Type variable '" + string + "' can not be resolved (with context of class " + (String)object + ")");
    }

    public void addBinding(String string, JavaType javaType) {
        if (this._bindings == null || this._bindings.size() == 0) {
            this._bindings = new LinkedHashMap<String, JavaType>();
        }
        this._bindings.put(string, javaType);
    }

    public JavaType[] typesAsArray() {
        if (this._bindings == null) {
            this._resolve();
        }
        if (this._bindings.size() == 0) {
            return NO_TYPES;
        }
        return this._bindings.values().toArray(new JavaType[this._bindings.size()]);
    }

    protected void _resolve() {
        int n;
        this._resolveBindings(this._contextClass);
        if (this._contextType != null && (n = this._contextType.containedTypeCount()) > 0) {
            for (int i = 0; i < n; ++i) {
                String string = this._contextType.containedTypeName(i);
                JavaType javaType = this._contextType.containedType(i);
                this.addBinding(string, javaType);
            }
        }
        if (this._bindings == null) {
            this._bindings = Collections.emptyMap();
        }
    }

    public void _addPlaceholder(String string) {
        if (this._placeholders == null) {
            this._placeholders = new HashSet();
        }
        this._placeholders.add(string);
    }

    /*
     * WARNING - void declaration
     */
    protected void _resolveBindings(Type type) {
        Class clazz;
        block17: {
            block18: {
                void var5_9;
                Type type2;
                JavaType[] javaTypeArray;
                Type[] typeArray;
                Type type3;
                block16: {
                    if (type == null) {
                        return;
                    }
                    if (!(type instanceof ParameterizedType)) break block16;
                    type3 = (ParameterizedType)type;
                    typeArray = type3.getActualTypeArguments();
                    if (typeArray != null && typeArray.length > 0) {
                        javaTypeArray = (JavaType[])type3.getRawType();
                        TypeVariable<Class<T>>[] object = javaTypeArray.getTypeParameters();
                        if (object.length != typeArray.length) {
                            throw new IllegalArgumentException("Strange parametrized type (in class " + javaTypeArray.getName() + "): number of type arguments != number of type parameters (" + typeArray.length + " vs " + object.length + ")");
                        }
                        int n = typeArray.length;
                        for (int i = 0; i < n; ++i) {
                            type2 = object[i];
                            String string = type2.getName();
                            if (this._bindings == null) {
                                this._bindings = new LinkedHashMap<String, JavaType>();
                            } else if (this._bindings.containsKey(string)) continue;
                            this._addPlaceholder(string);
                            this._bindings.put(string, this._typeFactory._constructType(typeArray[i], this));
                        }
                    }
                    clazz = (Class)type3.getRawType();
                    break block17;
                }
                if (!(type instanceof Class)) break block18;
                clazz = (Class)type;
                type3 = clazz.getDeclaringClass();
                if (type3 != null && !((Class)type3).isAssignableFrom(clazz)) {
                    this._resolveBindings(clazz.getDeclaringClass());
                }
                if ((typeArray = clazz.getTypeParameters()) == null || typeArray.length <= 0) break block17;
                javaTypeArray = null;
                if (this._contextType != null && clazz.isAssignableFrom(this._contextType.getRawClass())) {
                    javaTypeArray = this._typeFactory.findTypeParameters(this._contextType, clazz);
                }
                boolean i = false;
                while (var5_9 < typeArray.length) {
                    block19: {
                        String string;
                        block21: {
                            block20: {
                                Type type4 = typeArray[var5_9];
                                string = type4.getName();
                                type2 = type4.getBounds()[0];
                                if (type2 == null) break block19;
                                if (this._bindings != null) break block20;
                                this._bindings = new LinkedHashMap<String, JavaType>();
                                break block21;
                            }
                            if (this._bindings.containsKey(string)) break block19;
                        }
                        this._addPlaceholder(string);
                        if (javaTypeArray != null) {
                            this._bindings.put(string, javaTypeArray[var5_9]);
                        } else {
                            this._bindings.put(string, this._typeFactory._constructType(type2, this));
                        }
                    }
                    ++var5_9;
                }
                break block17;
            }
            return;
        }
        this._resolveBindings(clazz.getGenericSuperclass());
        for (Type type5 : clazz.getGenericInterfaces()) {
            this._resolveBindings(type5);
        }
    }

    public String toString() {
        if (this._bindings == null) {
            this._resolve();
        }
        StringBuilder stringBuilder = new StringBuilder("[TypeBindings for ");
        if (this._contextType != null) {
            stringBuilder.append(this._contextType.toString());
        } else {
            stringBuilder.append(this._contextClass.getName());
        }
        stringBuilder.append(": ").append(this._bindings).append("]");
        return stringBuilder.toString();
    }
}

