/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.dictionary;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.dictionary.DictionaryConst;
import org.pentaho.dictionary.DictionaryHelper;
import org.pentaho.metaverse.api.IIdentifierModifiable;
import org.pentaho.metaverse.api.ILogicalIdGenerator;
import org.pentaho.metaverse.api.IMetaverseLink;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.PropertiesHolder;

public class MetaverseTransientNode
extends PropertiesHolder
implements IMetaverseNode,
IIdentifierModifiable {
    protected List<IMetaverseLink> links = new ArrayList<IMetaverseLink>();
    protected ILogicalIdGenerator logicalIdGenerator = DictionaryConst.LOGICAL_ID_GENERATOR_DEFAULT;
    private String logicalId;

    public MetaverseTransientNode() {
    }

    public MetaverseTransientNode(String id) {
        this();
        this.setStringID(id);
    }

    @Override
    public String getName() {
        return this.getPropertyAsString("name");
    }

    @Override
    public String getStringID() {
        return this.getPropertyAsString("id");
    }

    @Override
    public String getType() {
        return this.getPropertyAsString("type");
    }

    @Override
    public void setName(String name) {
        this.setProperty("name", name);
    }

    @Override
    public void setStringID(String id) {
        this.setProperty("id", id);
    }

    @Override
    public void setType(String type) {
        this.setProperty("type", type);
        String category = DictionaryHelper.getCategoryForType(type);
        this.setProperty("category", category);
    }

    public void addLink(IMetaverseLink link) {
        this.links.add(link);
    }

    public void removeLink(IMetaverseLink link) {
        this.links.remove(link);
    }

    public List<IMetaverseLink> getLinks() {
        return this.links;
    }

    @Override
    public String getLogicalId() {
        if (this.logicalIdGenerator == null) {
            return this.getStringID();
        }
        if (this.logicalId == null || this.isDirty()) {
            this.logicalId = this.logicalIdGenerator.generateId(this);
        }
        return this.logicalId == null ? this.getStringID() : this.logicalId;
    }

    @Override
    public void setLogicalIdGenerator(ILogicalIdGenerator idGenerator) {
        this.logicalId = null;
        this.logicalIdGenerator = idGenerator;
    }
}

