/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.domain.model.entities.serialization.jaxb;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.marketplace.domain.model.entities.MarketEntryType;
import org.pentaho.marketplace.domain.model.entities.interfaces.ICategory;
import org.pentaho.marketplace.domain.model.entities.interfaces.IPlugin;
import org.pentaho.marketplace.domain.model.entities.interfaces.IPluginVersion;
import org.pentaho.marketplace.domain.model.entities.serialization.IMarketplaceXmlSerializer;
import org.pentaho.marketplace.domain.model.entities.serialization.jaxb.dto.Category;
import org.pentaho.marketplace.domain.model.entities.serialization.jaxb.dto.DevelopmentStage;
import org.pentaho.marketplace.domain.model.entities.serialization.jaxb.dto.Market;
import org.pentaho.marketplace.domain.model.entities.serialization.jaxb.dto.Version;
import org.pentaho.marketplace.domain.model.factories.interfaces.ICategoryFactory;
import org.pentaho.marketplace.domain.model.factories.interfaces.IPluginFactory;
import org.pentaho.marketplace.domain.model.factories.interfaces.IPluginVersionFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class JAXBMarketplaceXmlSerializer
implements IMarketplaceXmlSerializer {
    private static final String OSGI_URL_SUFFIX = ".kar";
    private JAXBContext jaxbContext;
    private Unmarshaller jaxbUnmarshaller;
    private ICategoryFactory categoryFactory;
    private IPluginFactory pluginFactory;
    private IPluginVersionFactory pluginVersionFactory;
    private Log logger = LogFactory.getLog(this.getClass());

    protected Log getLogger() {
        return this.logger;
    }

    public JAXBMarketplaceXmlSerializer(IPluginFactory pluginFactory, IPluginVersionFactory pluginVersionFactory, ICategoryFactory categoryFactory) {
        this.pluginFactory = pluginFactory;
        this.pluginVersionFactory = pluginVersionFactory;
        this.categoryFactory = categoryFactory;
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Market.class});
            this.jaxbUnmarshaller = this.jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            this.getLogger().error((Object)"Error initializing JAXBMarketplaceXmlSerializer.", (Throwable)e);
        }
    }

    @Override
    public Map<String, IPlugin> getPlugins(InputStream xmlInputStream) {
        try {
            Market market = (Market)this.jaxbUnmarshaller.unmarshal(xmlInputStream);
            Map<String, IPlugin> plugins = this.toPlugins(market);
            return plugins;
        }
        catch (JAXBException e) {
            this.getLogger().debug((Object)"Failed trying to parse invalid marketplace metadata.");
            return Collections.emptyMap();
        }
    }

    @Override
    public Map<String, IPlugin> getPlugins(String xml) {
        try {
            Market market = (Market)this.jaxbUnmarshaller.unmarshal((Reader)new StringReader(xml));
            Map<String, IPlugin> plugins = this.toPlugins(market);
            return plugins;
        }
        catch (JAXBException e) {
            this.getLogger().debug((Object)"Failed trying to parse invalid marketplace metadata.");
            return Collections.emptyMap();
        }
    }

    @Override
    public Map<String, IPlugin> getPlugins(Document marketplaceMetadataDocument) throws XPathExpressionException {
        try {
            Market market = (Market)this.jaxbUnmarshaller.unmarshal((Node)marketplaceMetadataDocument);
            Map<String, IPlugin> plugins = this.toPlugins(market);
            return plugins;
        }
        catch (JAXBException e) {
            this.getLogger().debug((Object)"Failed trying to parse invalid marketplace metadata.");
            return Collections.emptyMap();
        }
    }

    @Override
    public IPluginVersion getInstalledVersion(String xml) {
        return this.getInstalledVersion(new InputSource(new StringReader(xml)));
    }

    @Override
    public IPluginVersion getInstalledVersion(InputSource inputDocument) {
        IPluginVersion version = null;
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = db.parse(inputDocument);
            version = this.getInstalledVersion(document);
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Error getting plugin version from version xml.", (Throwable)e);
        }
        return version;
    }

    @Override
    public IPluginVersion getInstalledVersion(Document installedVersionDocument) {
        NodeList versionElements = installedVersionDocument.getElementsByTagName("version");
        if (versionElements.getLength() == 0) {
            return null;
        }
        Element versionElement = (Element)versionElements.item(0);
        IPluginVersion version = (IPluginVersion)this.pluginVersionFactory.create();
        version.setBranch(versionElement.getAttribute("branch"));
        version.setVersion(versionElement.getTextContent());
        version.setBuildId(versionElement.getAttribute("buildId"));
        return version;
    }

    private Map<String, IPlugin> toPlugins(Market market) {
        List<Market.MarketEntry> marketEntries = market.getMarketEntry();
        HashMap<String, IPlugin> plugins = new HashMap<String, IPlugin>(marketEntries.size());
        int rank = 0;
        for (Market.MarketEntry entry : marketEntries) {
            plugins.put(entry.getId(), this.toPlugin(entry, rank++));
        }
        return plugins;
    }

    private IPlugin toPlugin(Market.MarketEntry entry, int rank) {
        IPlugin plugin = (IPlugin)this.pluginFactory.create();
        plugin.setRank(rank);
        plugin.setId(entry.getId());
        plugin.setName(entry.getName());
        plugin.setType(this.toEntryType(entry.getType()));
        plugin.setImg(entry.getImg());
        plugin.setSmallImg(entry.getSmallImg());
        plugin.setDocumentationUrl(entry.getDocumentationUrl());
        plugin.setDescription(entry.getDescription());
        plugin.setAuthorName(entry.getAuthor());
        plugin.setAuthorUrl(entry.getAuthorUrl());
        plugin.setAuthorLogo(entry.getAuthorLogo());
        plugin.setInstallationNotes(entry.getInstallationNotes());
        plugin.setDependencies(entry.getDependencies());
        plugin.setLicense(entry.getLicense());
        plugin.setLicenseName(entry.getLicenseName());
        plugin.setLicenseText(entry.getLicenseText());
        ArrayList<Version> versions = entry.getVersions() != null ? entry.getVersions().getVersion() : new ArrayList(0);
        plugin.setVersions(this.toVersions(versions));
        List<Object> screenshots = entry.getScreenshots() != null ? entry.getScreenshots().getScreenshot() : new ArrayList(0);
        plugin.setScreenshots(screenshots.toArray(new String[screenshots.size()]));
        plugin.setCategory(this.toCategory(entry.getCategory()));
        return plugin;
    }

    private Collection<IPluginVersion> toVersions(List<Version> versions) {
        ArrayList<IPluginVersion> pluginVersions = new ArrayList<IPluginVersion>(versions.size());
        for (Version version : versions) {
            pluginVersions.add(this.toVersion(version));
        }
        return pluginVersions;
    }

    private IPluginVersion toVersion(Version version) {
        IPluginVersion pluginVersion = (IPluginVersion)this.pluginVersionFactory.create();
        pluginVersion.setBranch(version.getBranch());
        pluginVersion.setName(version.getName());
        String downloadUrl = version.getPackageUrl();
        if (downloadUrl != null) {
            downloadUrl = downloadUrl.trim();
            pluginVersion.setDownloadUrl(downloadUrl);
            pluginVersion.setIsOsgi(downloadUrl.endsWith(OSGI_URL_SUFFIX));
        }
        pluginVersion.setVersion(version.getVersion());
        pluginVersion.setSamplesDownloadUrl(version.getSamplesUrl());
        pluginVersion.setDescription(version.getDescription());
        pluginVersion.setChangelog(version.getChangelog());
        pluginVersion.setBuildId(version.getBuildId());
        pluginVersion.setMinParentVersion(version.getMinParentVersion());
        pluginVersion.setMaxParentVersion(version.getMaxParentVersion());
        DevelopmentStage dtoDevStage = version.getDevelopmentStage();
        if (dtoDevStage != null) {
            org.pentaho.marketplace.domain.model.entities.DevelopmentStage devStage = new org.pentaho.marketplace.domain.model.entities.DevelopmentStage(dtoDevStage.getLane().value(), String.valueOf(dtoDevStage.getPhase()));
            pluginVersion.setDevelopmentStage(devStage);
        }
        return pluginVersion;
    }

    private MarketEntryType toEntryType(org.pentaho.marketplace.domain.model.entities.serialization.jaxb.dto.MarketEntryType entryType) {
        return MarketEntryType.getMarketEntryType(entryType.value());
    }

    private ICategory toCategory(Category categoryDto) {
        if (categoryDto == null) {
            return null;
        }
        ICategory parent = null;
        if (categoryDto.getParent() != null) {
            parent = this.toCategory(categoryDto.getParent());
        }
        ICategory category = this.categoryFactory.create(categoryDto.getName(), parent);
        return category;
    }
}

