/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace.util.web;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpUtil {
    private static final String PROXY_HOST_PROPERTY_NAME = "http.proxyHost";
    private static final String PROXY_PORT_PROPERTY_NAME = "http.proxyPort";
    private static final String PROXY_USER_PROPERTY_NAME = "http.proxyUser";
    private static final String PROXY_PASSWORD_PROPERTY_NAME = "http.proxyPassword";
    private static Log logger = LogFactory.getLog(HttpUtil.class);

    public static HttpClient getClient() {
        int connectionTimeout = 3000;
        int pageTimeout = 7000;
        SimpleHttpConnectionManager connectionManager = new SimpleHttpConnectionManager();
        HttpConnectionManagerParams connectionParams = connectionManager.getParams();
        connectionParams.setConnectionTimeout(connectionTimeout);
        connectionParams.setSoTimeout(pageTimeout);
        HttpClient httpClient = null;
        if (connectionManager != null) {
            httpClient = new HttpClient((HttpConnectionManager)connectionManager);
        }
        try {
            HostConfiguration hostConfig = null;
            final String proxyHost = System.getProperty(PROXY_HOST_PROPERTY_NAME);
            final int proxyPort = Integer.parseInt(System.getProperty(PROXY_PORT_PROPERTY_NAME));
            if (StringUtils.isNotEmpty((String)proxyHost)) {
                hostConfig = new HostConfiguration(){

                    public synchronized String getProxyHost() {
                        return proxyHost;
                    }

                    public synchronized int getProxyPort() {
                        return proxyPort;
                    }
                };
                httpClient.setHostConfiguration(hostConfig);
                String proxyUser = System.getProperty(PROXY_USER_PROPERTY_NAME);
                String proxyPassword = System.getProperty(PROXY_PASSWORD_PROPERTY_NAME);
                if (proxyUser != null && proxyUser.trim().length() > 0) {
                    httpClient.getState().setProxyCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return httpClient;
    }

    public static boolean getURLContent(String url, StringBuffer content) {
        InputStream response = HttpUtil.getURLInputStream(url);
        if (response == null) {
            return false;
        }
        try {
            byte[] buffer = new byte[2048];
            int size = response.read(buffer);
            while (size > 0) {
                for (int idx = 0; idx < size; ++idx) {
                    content.append((char)buffer[idx]);
                }
                size = response.read(buffer);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static String getURLContent(String uri) {
        StringBuffer content = new StringBuffer();
        HttpUtil.getURLContent(uri, content);
        return content.toString();
    }

    public static InputStream getURLInputStream(String url) {
        HttpClient httpClient = HttpUtil.getClient();
        try {
            GetMethod call = new GetMethod(url);
            call.setFollowRedirects(true);
            int status = httpClient.executeMethod((HttpMethod)call);
            if (status == 200) {
                return call.getResponseBodyAsStream();
            }
            return null;
        }
        catch (Throwable e) {
            logger.debug((Object)("Unable to get input stream from " + url), e);
            return null;
        }
    }

    public static InputStream getURLInputStream(URL url) {
        return HttpUtil.getURLInputStream(url.toString());
    }

    public static Reader getURLReader(String uri) {
        InputStream inputStream = HttpUtil.getURLInputStream(uri);
        if (inputStream != null) {
            return new InputStreamReader(inputStream);
        }
        return null;
    }

    public static Map parseQueryString(String s) {
        String[] valArray = null;
        if (s == null) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String[]> rtn = new HashMap<String, String[]>();
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s, "&");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                throw new IllegalArgumentException();
            }
            String key = HttpUtil.parseName(pair.substring(0, pos), sb);
            String val = HttpUtil.parseName(pair.substring(pos + 1, pair.length()), sb);
            if (rtn.containsKey(key)) {
                String[] oldVals = (String[])rtn.get(key);
                valArray = new String[oldVals.length + 1];
                System.arraycopy(oldVals, 0, valArray, 0, oldVals.length);
                valArray[oldVals.length] = val;
            } else {
                valArray = new String[]{val};
            }
            rtn.put(key, valArray);
        }
        return rtn;
    }

    private static String parseName(String s, StringBuffer sb) {
        sb.setLength(0);
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    continue block7;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block7;
                    }
                    catch (NumberFormatException numberformatexception) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException oob) {
                        String rest = s.substring(i);
                        sb.append(rest);
                        if (rest.length() != 2) continue block7;
                        ++i;
                        continue block7;
                    }
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

