/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model.datatype;

import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import com.infobright.etl.model.datatype.AbstractColumnType;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

abstract class DateType
extends AbstractColumnType {
    private final SimpleDateFormat format;
    private Date zero;
    private Date data;
    private byte[] buf;

    DateType(String datePattern) {
        this.data = this.zero = new Date(0L);
        this.format = new SimpleDateFormat(datePattern);
        this.buf = new byte[this.format.toPattern().length()];
    }

    public void setData(ByteBuffer byteBuffer) throws AbstractColumnType.InvalidDataException {
        byteBuffer.get(this.buf);
        try {
            if (this.getIsNull()) {
                return;
            }
            String str = new String(this.buf, "ISO-8859-1");
            this.setData(str);
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
    }

    public void getData(ByteBuffer byteBuffer) {
        byteBuffer.put(this.getDataAsString().getBytes());
    }

    public String getDataAsString() {
        return this.format.format(this.data);
    }

    public void setData(String string) {
        try {
            this.data = this.format.parse(string);
        }
        catch (ParseException e2) {
            throw new RuntimeException(e2);
        }
    }

    protected void zeroOutData() {
        this.data = this.zero;
    }

    public void setData(Date d) {
        this.data = d;
    }

    protected Date getData() {
        return this.data;
    }

    public void setData(Object value, ValueConverter meta) throws ValueConverterException {
        if (value == null) {
            this.setIsNull(true);
        } else {
            Date date = meta.getDate(value);
            if (date == null) {
                this.setIsNull(true);
            } else {
                this.setIsNull(false);
                this.setData(date);
            }
        }
    }

    public final boolean isNeedsEnclosures() {
        return false;
    }
}

