/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model.datatype;

import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import com.infobright.etl.model.datatype.AbstractColumnType;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

class VarcharType
extends AbstractColumnType {
    private byte[] data = new byte[0];
    private final int length;
    private final Charset charset;

    VarcharType(int len, Charset charset) {
        this.length = len;
        this.charset = charset;
    }

    public void setData(ByteBuffer byteBuffer) throws AbstractColumnType.InvalidDataException {
        short len = byteBuffer.getShort();
        this.data = new byte[len];
        byteBuffer.get(this.data);
    }

    public String getDataAsString() {
        try {
            return new String(this.data, this.charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void getData(ByteBuffer byteBuffer) {
        byteBuffer.putShort((short)this.data.length);
        byteBuffer.put(this.data);
    }

    public void setData(String string) throws ValueConverterException {
        if (string == null) {
            this.setIsNull(true);
        } else {
            if (this.isCheckValues() && string.length() > this.length) {
                throw new ValueConverterException("data is too big for this column");
            }
            this.setIsNull(false);
            try {
                this.data = string.getBytes(this.charset.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void zeroOutData() {
        this.data = new byte[0];
    }

    public void setData(Object value, ValueConverter meta) throws ValueConverterException {
        if (value == null) {
            this.setIsNull(true);
        } else {
            String val = meta.getString(value);
            if (val == null) {
                this.setIsNull(true);
            } else {
                this.setIsNull(false);
                this.setData(val);
            }
        }
    }

    public final boolean isNeedsEnclosures() {
        return true;
    }
}

