/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import org.apache.hive.jdbc.JdbcColumn;
import org.apache.hive.jdbc.JdbcColumnAttributes;

public class HiveResultSetMetaData
implements ResultSetMetaData {
    private final List<String> columnNames;
    private final List<String> columnTypes;
    private final List<JdbcColumnAttributes> columnAttributes;

    public HiveResultSetMetaData(List<String> columnNames, List<String> columnTypes, List<JdbcColumnAttributes> columnAttributes) {
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
        this.columnAttributes = columnAttributes;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        int columnType = this.getColumnType(column);
        return JdbcColumn.columnClassName(columnType, this.columnAttributes.get(this.toZeroIndex(column)));
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnNames.size();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        int columnType = this.getColumnType(column);
        return JdbcColumn.columnDisplaySize(columnType, this.columnAttributes.get(this.toZeroIndex(column)));
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.columnNames.get(this.toZeroIndex(column));
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columnNames.get(this.toZeroIndex(column));
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        String type = this.columnTypes.get(this.toZeroIndex(column));
        return JdbcColumn.hiveTypeToSqlType(type);
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return JdbcColumn.getColumnTypeName(this.columnTypes.get(this.toZeroIndex(column)));
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        int columnType = this.getColumnType(column);
        return JdbcColumn.columnPrecision(columnType, this.columnAttributes.get(this.toZeroIndex(column)));
    }

    @Override
    public int getScale(int column) throws SQLException {
        int columnType = this.getColumnType(column);
        return JdbcColumn.columnScale(columnType, this.columnAttributes.get(this.toZeroIndex(column)));
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getTableName(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        String type = this.columnTypes.get(this.toZeroIndex(column));
        return "string".equalsIgnoreCase(type);
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    protected int toZeroIndex(int column) throws SQLException {
        if (this.columnTypes == null) {
            throw new SQLException("Could not determine column type name for ResultSet");
        }
        if (column < 1 || column > this.columnTypes.size()) {
            throw new SQLException("Invalid column value: " + column);
        }
        return column - 1;
    }
}

