/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppProxyServer
extends CompositeService {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final Logger LOG = LoggerFactory.getLogger(WebAppProxyServer.class);
    private WebAppProxy proxy = null;
    private JvmPauseMonitor pauseMonitor;

    public WebAppProxyServer() {
        super(WebAppProxyServer.class.getName());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        YarnConfiguration config = new YarnConfiguration(conf);
        this.doSecureLogin(conf);
        this.proxy = new WebAppProxy();
        this.addService((Service)this.proxy);
        DefaultMetricsSystem.initialize((String)"WebAppProxyServer");
        JvmMetrics jm = JvmMetrics.initSingleton((String)"WebAppProxyServer", null);
        this.pauseMonitor = new JvmPauseMonitor();
        this.addService((Service)this.pauseMonitor);
        jm.setPauseMonitor(this.pauseMonitor);
        super.serviceInit((Configuration)config);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        super.serviceStop();
        DefaultMetricsSystem.shutdown();
    }

    protected void doSecureLogin(Configuration conf) throws IOException {
        InetSocketAddress socAddr = WebAppProxyServer.getBindAddress(conf);
        SecurityUtil.login((Configuration)conf, (String)"yarn.web-proxy.keytab", (String)"yarn.web-proxy.principal", (String)socAddr.getHostName());
    }

    public static InetSocketAddress getBindAddress(Configuration conf) {
        return conf.getSocketAddr("yarn.web-proxy.address", "0.0.0.0:9099", 9099);
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(WebAppProxyServer.class, (String[])args, (Logger)LOG);
        try {
            YarnConfiguration configuration = new YarnConfiguration();
            WebAppProxyServer proxyServer = WebAppProxyServer.startServer((Configuration)configuration);
            proxyServer.proxy.join();
        }
        catch (Throwable t) {
            ExitUtil.terminate((int)-1, (Throwable)t);
        }
    }

    protected static WebAppProxyServer startServer(Configuration configuration) throws Exception {
        WebAppProxyServer proxy = new WebAppProxyServer();
        ShutdownHookManager.get().addShutdownHook((Runnable)new CompositeService.CompositeServiceShutdownHook((CompositeService)proxy), 30);
        proxy.init(configuration);
        proxy.start();
        return proxy;
    }
}

