/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.security.userroledao.jackrabbit;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.collections.map.LRUMap;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.authentication.CryptedSimpleCredentials;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.user.PentahoUserManagerImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoUser;
import org.pentaho.platform.api.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.api.engine.security.userroledao.NotFoundException;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantedPrincipleNameResolver;
import org.pentaho.platform.api.repository2.unified.IRepositoryDefaultAclHandler;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.TenantUtils;
import org.pentaho.platform.repository2.unified.IRepositoryFileAclDao;
import org.pentaho.platform.repository2.unified.IRepositoryFileDao;
import org.pentaho.platform.repository2.unified.ServerRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.ILockHelper;
import org.pentaho.platform.repository2.unified.jcr.IPathConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileAclUtils;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.repository2.unified.jcr.JcrTenantUtils;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.pentaho.platform.repository2.unified.jcr.sejcr.CredentialsStrategySessionFactory;
import org.pentaho.platform.security.userroledao.PentahoRole;
import org.pentaho.platform.security.userroledao.PentahoUser;
import org.pentaho.platform.security.userroledao.messages.Messages;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.core.userdetails.cache.NullUserCache;

public abstract class AbstractJcrBackedUserRoleDao
implements IUserRoleDao {
    static NameFactory NF = NameFactoryImpl.getInstance();
    static Name P_PRINCIPAL_NAME = NF.create("internal", "principalName");
    protected ITenantedPrincipleNameResolver tenantedUserNameUtils;
    protected ITenantedPrincipleNameResolver tenantedRoleNameUtils;
    String pPrincipalName = "rep:principalName";
    IRepositoryFileAclDao repositoryFileAclDao;
    IRepositoryFileDao repositoryFileDao;
    String defaultTenant;
    String authenticatedRoleName;
    String tenantAdminRoleName;
    String repositoryAdminUsername;
    IPathConversionHelper pathConversionHelper;
    IRepositoryDefaultAclHandler defaultAclHandler;
    ILockHelper lockHelper;
    List<String> systemRoles;
    List<String> extraRoles;
    HashMap<String, PentahoUserManagerImpl> userMgrMap = new HashMap();
    private LRUMap userCache = new LRUMap(4096);
    private UserCache userDetailsCache = new NullUserCache();
    private boolean useJackrabbitUserCache = true;

    public AbstractJcrBackedUserRoleDao(ITenantedPrincipleNameResolver userNameUtils, ITenantedPrincipleNameResolver roleNameUtils, String authenticatedRoleName, String tenantAdminRoleName, String repositoryAdminUsername, IRepositoryFileAclDao repositoryFileAclDao, IRepositoryFileDao repositoryFileDao, IPathConversionHelper pathConversionHelper, ILockHelper lockHelper, IRepositoryDefaultAclHandler defaultAclHandler, List<String> systemRoles, List<String> extraRoles, UserCache userDetailsCache) throws NamespaceException {
        this.tenantedUserNameUtils = userNameUtils;
        this.tenantedRoleNameUtils = roleNameUtils;
        this.authenticatedRoleName = authenticatedRoleName;
        this.tenantAdminRoleName = tenantAdminRoleName;
        this.repositoryAdminUsername = repositoryAdminUsername;
        this.repositoryFileAclDao = repositoryFileAclDao;
        this.repositoryFileDao = repositoryFileDao;
        this.pathConversionHelper = pathConversionHelper;
        this.lockHelper = lockHelper;
        this.defaultAclHandler = defaultAclHandler;
        this.systemRoles = systemRoles;
        this.extraRoles = extraRoles;
        this.userDetailsCache = userDetailsCache;
    }

    public void setRoleMembers(Session session, ITenant theTenant, String roleName, String[] memberUserNames) throws RepositoryException, NotFoundException {
        List<IPentahoUser> currentRoleMembers = this.getRoleMembers(session, theTenant, roleName);
        String[] usersToBeRemoved = this.findRemovedUsers(currentRoleMembers, memberUserNames);
        if ((this.oneOfUserIsMySelf(usersToBeRemoved) || this.oneOfUserIsDefaultAdminUser(usersToBeRemoved)) && this.tenantAdminRoleName.equals(roleName)) {
            throw new RepositoryException(Messages.getInstance().getString("AbstractJcrBackedUserRoleDao.ERROR_0009_USER_REMOVE_FAILED_YOURSELF_OR_DEFAULT_ADMIN_USER"));
        }
        if (this.tenantAdminRoleName.equals(roleName) && currentRoleMembers != null && currentRoleMembers.size() > 0 && memberUserNames.length == 0) {
            throw new RepositoryException(Messages.getInstance().getString("AbstractJcrBackedUserRoleDao.ERROR_0001_LAST_ADMIN_ROLE", new Object[]{this.tenantAdminRoleName}));
        }
        Group jackrabbitGroup = this.getJackrabbitGroup(theTenant, roleName, session);
        if (jackrabbitGroup == null || !TenantUtils.isAccessibleTenant((ITenant)(theTenant == null ? this.tenantedRoleNameUtils.getTenant(jackrabbitGroup.getID()) : theTenant))) {
            throw new NotFoundException(Messages.getInstance().getString("AbstractJcrBackedUserRoleDao.ERROR_0002_ROLE_NOT_FOUND"));
        }
        HashMap<String, User> currentlyAssignedUsers = new HashMap<String, User>();
        Iterator currentMembers = jackrabbitGroup.getMembers();
        while (currentMembers.hasNext()) {
            Authorizable member = (Authorizable)currentMembers.next();
            if (!(member instanceof User)) continue;
            currentlyAssignedUsers.put(member.getID(), (User)member);
        }
        HashMap<String, User> finalCollectionOfAssignedUsers = new HashMap<String, User>();
        if (memberUserNames != null) {
            ITenant tenant = theTenant == null ? JcrTenantUtils.getTenant(roleName, false) : theTenant;
            for (String user : memberUserNames) {
                User jackrabbitUser = this.getJackrabbitUser(tenant, user, session);
                if (jackrabbitUser == null) continue;
                finalCollectionOfAssignedUsers.put(this.getTenantedUserNameUtils().getPrincipleId(tenant, user), jackrabbitUser);
            }
        }
        ArrayList usersToRemove = new ArrayList(currentlyAssignedUsers.keySet());
        usersToRemove.removeAll(finalCollectionOfAssignedUsers.keySet());
        ArrayList usersToAdd = new ArrayList(finalCollectionOfAssignedUsers.keySet());
        usersToAdd.removeAll(currentlyAssignedUsers.keySet());
        for (String userId : usersToRemove) {
            jackrabbitGroup.removeMember((Authorizable)currentlyAssignedUsers.get(userId));
            this.purgeUserFromCache(userId);
        }
        for (String userId : usersToAdd) {
            jackrabbitGroup.addMember((Authorizable)finalCollectionOfAssignedUsers.get(userId));
            this.purgeUserFromCache(userId);
        }
    }

    private void setUserRolesForNewUser(Session session, ITenant theTenant, String userName, String[] roles) throws RepositoryException, NotFoundException {
        HashSet<String> roleSet = new HashSet<String>();
        if (roles != null) {
            roleSet.addAll(Arrays.asList(roles));
        }
        roleSet.add(this.authenticatedRoleName);
        User jackrabbitUser = this.getJackrabbitUser(theTenant, userName, session);
        if (jackrabbitUser == null || !TenantUtils.isAccessibleTenant((ITenant)(theTenant == null ? this.tenantedUserNameUtils.getTenant(jackrabbitUser.getID()) : theTenant))) {
            throw new NotFoundException(Messages.getInstance().getString("AbstractJcrBackedUserRoleDao.ERROR_0003_USER_NOT_FOUND"));
        }
        HashMap<String, Group> finalCollectionOfAssignedGroups = new HashMap<String, Group>();
        ITenant tenant = theTenant == null ? JcrTenantUtils.getTenant(userName, true) : theTenant;
        for (String role : roleSet) {
            Group jackrabbitGroup = this.getJackrabbitGroup(tenant, role, session);
            if (jackrabbitGroup == null) continue;
            finalCollectionOfAssignedGroups.put(this.tenantedRoleNameUtils.getPrincipleId(tenant, role), jackrabbitGroup);
        }
        ArrayList groupsToAdd = new ArrayList(finalCollectionOfAssignedGroups.keySet());
        for (String groupId : groupsToAdd) {
            ((Group)finalCollectionOfAssignedGroups.get(groupId)).addMember((Authorizable)jackrabbitUser);
            this.purgeUserFromCache(userName);
        }
    }

    private void purgeUserFromCache(String userName) {
        this.userDetailsCache.removeUserFromCache(this.getTenantedUserNameUtils().getPrincipleName(userName));
    }

    private boolean oneOfUserIsMySelf(String[] users) {
        for (int i = 0; i < users.length; ++i) {
            if (!this.isMyself(users[i])) continue;
            return true;
        }
        return false;
    }

    private boolean oneOfUserIsDefaultAdminUser(String[] users) {
        for (int i = 0; i < users.length; ++i) {
            if (!this.isDefaultAdminUser(users[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isMyself(String userName) {
        return PentahoSessionHolder.getSession().getName().equals(userName);
    }

    private boolean isDefaultAdminUser(String userName) {
        String defaultAdminUser = (String)PentahoSystem.get(String.class, (String)"singleTenantAdminUserName", (IPentahoSession)PentahoSessionHolder.getSession());
        if (defaultAdminUser != null) {
            return defaultAdminUser.equals(userName);
        }
        return false;
    }

    private boolean adminRoleExist(String[] newRoles) {
        return Arrays.asList(newRoles).contains(this.tenantAdminRoleName);
    }

    public void setUserRoles(Session session, ITenant theTenant, String userName, String[] roles) throws RepositoryException, NotFoundException {
        if ((this.isMyself(userName) || this.isDefaultAdminUser(userName)) && !this.adminRoleExist(roles)) {
            throw new RepositoryException(Messages.getInstance().getString("AbstractJcrBackedUserRoleDao.ERROR_0005_YOURSELF_OR_DEFAULT_ADMIN_USER"));
        }
        HashSet<String> roleSet = new HashSet<String>();
        if (roles != null) {
            roleSet.addAll(Arrays.asList(roles));
        }
        roleSet.add(this.authenticatedRoleName);
        User jackrabbitUser = this.getJackrabbitUser(theTenant, userName, session);
        if (jackrabbitUser == null || !TenantUtils.isAccessibleTenant((ITenant)(theTenant == null ? this.tenantedUserNameUtils.getTenant(jackrabbitUser.getID()) : theTenant))) {
            throw new NotFoundException(Messages.getInstance().getString("AbstractJcrBackedUserRoleDao.ERROR_0003_USER_NOT_FOUND"));
        }
        HashMap<String, Group> currentlyAssignedGroups = new HashMap<String, Group>();
        Iterator currentGroups = jackrabbitUser.memberOf();
        while (currentGroups.hasNext()) {
            Group currentGroup = (Group)currentGroups.next();
            currentlyAssignedGroups.put(currentGroup.getID(), currentGroup);
        }
        HashMap<String, Group> finalCollectionOfAssignedGroups = new HashMap<String, Group>();
        ITenant tenant = theTenant == null ? JcrTenantUtils.getTenant(userName, true) : theTenant;
        for (String role : roleSet) {
            Group jackrabbitGroup = this.getJackrabbitGroup(tenant, role, session);
            if (jackrabbitGroup == null) continue;
            finalCollectionOfAssignedGroups.put(this.tenantedRoleNameUtils.getPrincipleId(tenant, role), jackrabbitGroup);
        }
        ArrayList groupsToRemove = new ArrayList(currentlyAssignedGroups.keySet());
        groupsToRemove.removeAll(finalCollectionOfAssignedGroups.keySet());
        ArrayList groupsToAdd = new ArrayList(finalCollectionOfAssignedGroups.keySet());
        groupsToAdd.removeAll(currentlyAssignedGroups.keySet());
        for (String groupId : groupsToRemove) {
            ((Group)currentlyAssignedGroups.get(groupId)).removeMember((Authorizable)jackrabbitUser);
        }
        for (String groupId : groupsToAdd) {
            ((Group)finalCollectionOfAssignedGroups.get(groupId)).addMember((Authorizable)jackrabbitUser);
        }
        this.purgeUserFromCache(userName);
    }

    public IPentahoRole createRole(Session session, ITenant theTenant, String roleName, String description, String[] memberUserNames) throws AuthorizableExistsException, RepositoryException {
        ITenant tenant = theTenant;
        String role = roleName;
        if (tenant == null) {
            tenant = JcrTenantUtils.getTenant(roleName, false);
            role = JcrTenantUtils.getPrincipalName(roleName, false);
        }
        if (tenant == null || tenant.getId() == null) {
            tenant = JcrTenantUtils.getCurrentTenant();
        }
        if (!TenantUtils.isAccessibleTenant((ITenant)tenant)) {
            throw new NotFoundException(Messages.getInstance().getString("AbstractJcrBackedUserRoleDao.ERROR_0006_TENANT_NOT_FOUND", new Object[]{theTenant.getId()}));
        }
        String roleId = this.tenantedRoleNameUtils.getPrincipleId(tenant, role);
        PentahoUserManagerImpl tenantUserMgr = this.getUserManager(tenant, session);
        tenantUserMgr.createGroup((Principal)new PrincipalImpl(roleId), "");
        this.setRoleMembers(session, tenant, role, memberUserNames);
        this.setRoleDescription(session, tenant, role, description);
        return this.getRole(session, theTenant, roleName);
    }

    public IPentahoUser createUser(Session session, ITenant theTenant, String userName, String password, String description, String[] roles) throws AuthorizableExistsException, RepositoryException {
        ITenant tenant = theTenant;
        String user = userName;
        if (tenant == null) {
            tenant = JcrTenantUtils.getTenant(userName, true);
            user = JcrTenantUtils.getPrincipalName(userName, true);
        }
        if (tenant == null || tenant.getId() == null) {
            tenant = JcrTenantUtils.getCurrentTenant();
        }
        if (!TenantUtils.isAccessibleTenant((ITenant)tenant)) {
            throw new NotFoundException(Messages.getInstance().getString("AbstractJcrBackedUserRoleDao.ERROR_0006_TENANT_NOT_FOUND", new Object[]{theTenant.getId()}));
        }
        String userId = this.tenantedUserNameUtils.getPrincipleId(tenant, user);
        PentahoUserManagerImpl tenantUserMgr = this.getUserManager(tenant, session);
        tenantUserMgr.createUser(userId, password, (Principal)new PrincipalImpl(userId), "");
        session.save();
        this.setUserRolesForNewUser(session, tenant, user, roles);
        this.setUserDescription(session, tenant, user, description);
        session.save();
        this.createUserHomeFolder(tenant, user, session);
        session.save();
        this.userDetailsCache.removeUserFromCache(userName);
        return this.getUser(session, tenant, userName);
    }

    public void deleteRole(Session session, IPentahoRole role) throws NotFoundException, RepositoryException {
        if (this.canDeleteRole(session, role)) {
            List<IPentahoUser> roleMembers = this.getRoleMembers(session, role.getTenant(), role.getName());
            Group jackrabbitGroup = this.getJackrabbitGroup(role.getTenant(), role.getName(), session);
            if (jackrabbitGroup == null || !TenantUtils.isAccessibleTenant((ITenant)this.tenantedRoleNameUtils.getTenant(jackrabbitGroup.getID()))) {
                throw new NotFoundException("");
            }
            jackrabbitGroup.remove();
            for (IPentahoUser roleMember : roleMembers) {
                this.purgeUserFromCache(roleMember.getUsername());
            }
        } else {
            throw new RepositoryException(Messages.getInstance().getString("AbstractJcrBackedUserRoleDao.ERROR_0007_ATTEMPTED_SYSTEM_ROLE_DELETE"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteUser(Session session, IPentahoUser user) throws NotFoundException, RepositoryException {
        if (!this.canDeleteUser(session, user)) throw new RepositoryException(Messages.getInstance().getString("AbstractJcrBackedUserRoleDao.ERROR_0004_LAST_USER_NEEDED_IN_ROLE", new Object[]{this.tenantAdminRoleName}));
        User jackrabbitUser = this.getJackrabbitUser(user.getTenant(), user.getUsername(), session);
        if (jackrabbitUser == null || !TenantUtils.isAccessibleTenant((ITenant)this.tenantedUserNameUtils.getTenant(jackrabbitUser.getID()))) throw new NotFoundException("");
        Iterator currentGroups = jackrabbitUser.memberOf();
        while (currentGroups.hasNext()) {
            ((Group)currentGroups.next()).removeMember((Authorizable)jackrabbitUser);
        }
        this.purgeUserFromCache(user.getUsername());
        jackrabbitUser.remove();
    }

    public List<IPentahoRole> getRoles(Session session) throws RepositoryException {
        return this.getRoles(session, JcrTenantUtils.getCurrentTenant());
    }

    @VisibleForTesting
    IPentahoUser convertToPentahoUser(User jackrabbitUser) throws RepositoryException {
        if (this.getUserCache().containsKey((Object)jackrabbitUser.getID())) {
            return (IPentahoUser)this.getUserCache().get((Object)jackrabbitUser.getID());
        }
        PentahoUser pentahoUser = null;
        Value[] propertyValues = null;
        String description = null;
        try {
            propertyValues = jackrabbitUser.getProperty("description");
            description = propertyValues.length > 0 ? propertyValues[0].getString() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Credentials credentials = jackrabbitUser.getCredentials();
        String password = null;
        if (credentials instanceof CryptedSimpleCredentials) {
            password = new String(((CryptedSimpleCredentials)credentials).getPassword());
        }
        pentahoUser = new PentahoUser(this.getTenantedUserNameUtils().getTenant(jackrabbitUser.getID()), this.getTenantedUserNameUtils().getPrincipleName(jackrabbitUser.getID()), password, description, !jackrabbitUser.isDisabled());
        if (this.isUseJackrabbitUserCache()) {
            this.getUserCache().put((Object)jackrabbitUser.getID(), (Object)pentahoUser);
        }
        return pentahoUser;
    }

    private IPentahoRole convertToPentahoRole(Group jackrabbitGroup) throws RepositoryException {
        PentahoRole role = null;
        Value[] propertyValues = null;
        String description = null;
        try {
            propertyValues = jackrabbitGroup.getProperty("description");
            description = propertyValues.length > 0 ? propertyValues[0].getString() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        role = new PentahoRole(this.tenantedRoleNameUtils.getTenant(jackrabbitGroup.getID()), this.tenantedRoleNameUtils.getPrincipleName(jackrabbitGroup.getID()), description);
        return role;
    }

    public List<IPentahoUser> getUsers(Session session) throws RepositoryException {
        return this.getUsers(session, JcrTenantUtils.getCurrentTenant());
    }

    public void setRoleDescription(Session session, ITenant theTenant, String roleName, String description) throws NotFoundException, RepositoryException {
        Group jackrabbitGroup = this.getJackrabbitGroup(theTenant, roleName, session);
        if (jackrabbitGroup != null && TenantUtils.isAccessibleTenant((ITenant)(theTenant == null ? this.tenantedRoleNameUtils.getTenant(jackrabbitGroup.getID()) : theTenant))) {
            if (description == null) {
                jackrabbitGroup.removeProperty("description");
            } else {
                jackrabbitGroup.setProperty("description", session.getValueFactory().createValue(description));
            }
        } else {
            throw new NotFoundException(Messages.getInstance().getString("AbstractJcrBackedUserRoleDao.ERROR_0002_ROLE_NOT_FOUND"));
        }
    }

    public void setUserDescription(Session session, ITenant theTenant, String userName, String description) throws NotFoundException, RepositoryException {
        User jackrabbitUser = this.getJackrabbitUser(theTenant, userName, session);
        if (jackrabbitUser == null || !TenantUtils.isAccessibleTenant((ITenant)(theTenant == null ? this.tenantedUserNameUtils.getTenant(jackrabbitUser.getID()) : theTenant))) {
            throw new NotFoundException(Messages.getInstance().getString("AbstractJcrBackedUserRoleDao.ERROR_0003_USER_NOT_FOUND"));
        }
        if (description == null) {
            jackrabbitUser.removeProperty("description");
        } else {
            jackrabbitUser.setProperty("description", session.getValueFactory().createValue(description));
        }
    }

    public void setPassword(Session session, ITenant theTenant, String userName, String password) throws NotFoundException, RepositoryException {
        User jackrabbitUser = this.getJackrabbitUser(theTenant, userName, session);
        if (jackrabbitUser == null || !TenantUtils.isAccessibleTenant((ITenant)(theTenant == null ? this.tenantedUserNameUtils.getTenant(jackrabbitUser.getID()) : theTenant))) {
            throw new NotFoundException(Messages.getInstance().getString("AbstractJcrBackedUserRoleDao.ERROR_0003_USER_NOT_FOUND"));
        }
        jackrabbitUser.changePassword(password);
        this.purgeUserFromCache(userName);
        this.userCache.remove((Object)jackrabbitUser.getID());
    }

    public ITenantedPrincipleNameResolver getTenantedUserNameUtils() {
        return this.tenantedUserNameUtils;
    }

    public ITenantedPrincipleNameResolver getTenantedRoleNameUtils() {
        return this.tenantedRoleNameUtils;
    }

    public List<IPentahoRole> getRoles(Session session, ITenant tenant) throws RepositoryException, NamespaceException {
        return this.getRoles(session, tenant, false);
    }

    public List<IPentahoRole> getRoles(Session session, ITenant theTenant, boolean includeSubtenants) throws RepositoryException {
        ArrayList<IPentahoRole> roles = new ArrayList<IPentahoRole>();
        if (theTenant == null || theTenant.getId() == null) {
            theTenant = JcrTenantUtils.getTenant();
        }
        if (TenantUtils.isAccessibleTenant((ITenant)theTenant)) {
            PentahoUserManagerImpl userMgr = this.getUserManager(theTenant, session);
            this.pPrincipalName = AbstractJcrBackedUserRoleDao.getJcrName(session);
            Iterator it = userMgr.findAuthorizables(this.pPrincipalName, null, 2);
            while (it.hasNext()) {
                Group group = (Group)it.next();
                IPentahoRole pentahoRole = this.convertToPentahoRole(group);
                if (this.extraRoles.contains(pentahoRole.getName())) continue;
                if (includeSubtenants) {
                    roles.add(pentahoRole);
                    continue;
                }
                if (pentahoRole.getTenant() == null || !pentahoRole.getTenant().equals(theTenant)) continue;
                roles.add(pentahoRole);
            }
        }
        return roles;
    }

    protected static SessionImpl getSessionImpl(Session session) {
        InvocationHandler invocationHandler;
        if (session instanceof SessionImpl) {
            return (SessionImpl)session;
        }
        if (Proxy.isProxyClass(session.getClass()) && (invocationHandler = Proxy.getInvocationHandler(session)) instanceof CredentialsStrategySessionFactory.LogoutSuppressingInvocationHandler) {
            return ((CredentialsStrategySessionFactory.LogoutSuppressingInvocationHandler)invocationHandler).getSession();
        }
        throw new IllegalStateException("Session is not a SessionImpl or a proxy of one.");
    }

    private static String getJcrName(Session session) throws NamespaceException {
        return AbstractJcrBackedUserRoleDao.getSessionImpl(session).getJCRName(P_PRINCIPAL_NAME);
    }

    public List<IPentahoUser> getUsers(Session session, ITenant tenant) throws RepositoryException {
        return this.getUsers(session, tenant, false);
    }

    public List<IPentahoUser> getUsers(Session session, ITenant theTenant, boolean includeSubtenants) throws RepositoryException {
        ArrayList<IPentahoUser> users = new ArrayList<IPentahoUser>();
        if (theTenant == null || theTenant.getId() == null) {
            theTenant = JcrTenantUtils.getTenant();
        }
        if (TenantUtils.isAccessibleTenant((ITenant)theTenant)) {
            PentahoUserManagerImpl userMgr = this.getUserManager(theTenant, session);
            this.pPrincipalName = AbstractJcrBackedUserRoleDao.getJcrName(session);
            Iterator it = userMgr.findAuthorizables(this.pPrincipalName, null, 1);
            while (it.hasNext()) {
                User user = (User)it.next();
                IPentahoUser pentahoUser = this.convertToPentahoUser(user);
                if (includeSubtenants) {
                    users.add(pentahoUser);
                    continue;
                }
                if (pentahoUser.getTenant() == null || !pentahoUser.getTenant().equals(theTenant)) continue;
                users.add(pentahoUser);
            }
        }
        return users;
    }

    public IPentahoRole getRole(Session session, ITenant tenant, String name) throws RepositoryException {
        Group jackrabbitGroup = this.getJackrabbitGroup(tenant, name, session);
        return jackrabbitGroup != null && TenantUtils.isAccessibleTenant((ITenant)(tenant == null ? this.tenantedRoleNameUtils.getTenant(jackrabbitGroup.getID()) : tenant)) ? this.convertToPentahoRole(jackrabbitGroup) : null;
    }

    private PentahoUserManagerImpl getUserManager(ITenant theTenant, Session session) throws RepositoryException {
        Properties tenantProperties = new Properties();
        tenantProperties.put("usersPath", "/rep:security/rep:authorizables/rep:users" + theTenant.getRootFolderAbsolutePath());
        tenantProperties.put("groupsPath", "/rep:security/rep:authorizables/rep:groups" + theTenant.getRootFolderAbsolutePath());
        return new PentahoUserManagerImpl(AbstractJcrBackedUserRoleDao.getSessionImpl(session), session.getUserID(), tenantProperties);
    }

    public IPentahoUser getUser(Session session, ITenant tenant, String name) throws RepositoryException {
        User jackrabbitUser = this.getJackrabbitUser(tenant, name, session);
        return jackrabbitUser != null && TenantUtils.isAccessibleTenant((ITenant)(tenant == null ? this.tenantedUserNameUtils.getTenant(jackrabbitUser.getID()) : tenant)) ? this.convertToPentahoUser(jackrabbitUser) : null;
    }

    private Group getJackrabbitGroup(ITenant theTenant, String name, Session session) throws RepositoryException {
        Group jackrabbitGroup = null;
        String roleId = name;
        String roleName = name;
        ITenant tenant = theTenant;
        if (tenant == null) {
            tenant = JcrTenantUtils.getTenant(roleName, false);
            roleName = JcrTenantUtils.getPrincipalName(roleName, false);
        }
        if (tenant == null || tenant.getId() == null) {
            tenant = JcrTenantUtils.getCurrentTenant();
        }
        if (tenant == null || tenant.getId() == null) {
            tenant = JcrTenantUtils.getDefaultTenant();
        }
        roleId = this.tenantedRoleNameUtils.getPrincipleId(tenant, roleName);
        PentahoUserManagerImpl userMgr = this.getUserManager(tenant, session);
        Authorizable authorizable = userMgr.getAuthorizable(roleId);
        if (authorizable instanceof Group) {
            jackrabbitGroup = (Group)authorizable;
        }
        return jackrabbitGroup;
    }

    private User getJackrabbitUser(ITenant theTenant, String name, Session session) throws RepositoryException {
        User jackrabbitUser = null;
        String userId = name;
        String userName = name;
        ITenant tenant = theTenant;
        if (tenant == null) {
            tenant = JcrTenantUtils.getTenant(userName, true);
            userName = JcrTenantUtils.getPrincipalName(userName, true);
        }
        if (tenant == null || tenant.getId() == null) {
            tenant = JcrTenantUtils.getCurrentTenant();
        }
        if (tenant == null || tenant.getId() == null) {
            tenant = JcrTenantUtils.getDefaultTenant();
        }
        if (tenant != null) {
            userId = this.tenantedUserNameUtils.getPrincipleId(tenant, userName);
            PentahoUserManagerImpl userMgr = this.getUserManager(tenant, session);
            Authorizable authorizable = userMgr.getAuthorizable(userId);
            if (authorizable instanceof User) {
                jackrabbitUser = (User)authorizable;
            }
        }
        return jackrabbitUser;
    }

    protected boolean tenantExists(String tenantName) {
        return tenantName != null && tenantName.trim().length() > 0;
    }

    public List<IPentahoUser> getRoleMembers(Session session, ITenant theTenant, String roleName) throws RepositoryException {
        ArrayList<IPentahoUser> users = new ArrayList<IPentahoUser>();
        Group jackrabbitGroup = this.getJackrabbitGroup(theTenant, roleName, session);
        if (jackrabbitGroup != null && TenantUtils.isAccessibleTenant((ITenant)(theTenant == null ? this.tenantedRoleNameUtils.getTenant(jackrabbitGroup.getID()) : theTenant))) {
            Iterator authorizables = jackrabbitGroup.getMembers();
            while (authorizables.hasNext()) {
                Authorizable authorizable = (Authorizable)authorizables.next();
                if (!(authorizable instanceof User)) continue;
                users.add(this.convertToPentahoUser((User)authorizable));
            }
        }
        return users;
    }

    public List<IPentahoRole> getUserRoles(Session session, ITenant theTenant, String userName) throws RepositoryException {
        ArrayList<IPentahoRole> roles = new ArrayList<IPentahoRole>();
        User jackrabbitUser = this.getJackrabbitUser(theTenant, userName, session);
        if (jackrabbitUser != null && TenantUtils.isAccessibleTenant((ITenant)(theTenant == null ? this.tenantedUserNameUtils.getTenant(jackrabbitUser.getID()) : theTenant))) {
            Iterator groups = jackrabbitUser.memberOf();
            while (groups.hasNext()) {
                IPentahoRole role = this.convertToPentahoRole((Group)groups.next());
                if (this.extraRoles.contains(role.getName())) continue;
                roles.add(role);
            }
        }
        return roles;
    }

    private RepositoryFile createUserHomeFolder(ITenant theTenant, String username, Session session) throws RepositoryException {
        RepositoryFileAcl.Builder aclsForUserHomeFolder = null;
        RepositoryFileAcl.Builder aclsForTenantHomeFolder = null;
        if (theTenant == null) {
            theTenant = JcrTenantUtils.getTenant(username, true);
            username = JcrTenantUtils.getPrincipalName(username, true);
        }
        if (theTenant == null || theTenant.getId() == null) {
            theTenant = JcrTenantUtils.getCurrentTenant();
        }
        if (theTenant == null || theTenant.getId() == null) {
            theTenant = JcrTenantUtils.getDefaultTenant();
        }
        RepositoryFile userHomeFolder = null;
        String userId = this.tenantedUserNameUtils.getPrincipleId(theTenant, username);
        RepositoryFileSid userSid = new RepositoryFileSid(userId);
        RepositoryFile tenantHomeFolder = null;
        RepositoryFile tenantRootFolder = null;
        RepositoryFileSid ownerSid = null;
        tenantRootFolder = JcrRepositoryFileUtils.getFileByAbsolutePath(session, ServerRepositoryPaths.getTenantRootFolderPath(theTenant), this.pathConversionHelper, this.lockHelper, false, null);
        if (tenantRootFolder != null) {
            tenantHomeFolder = JcrRepositoryFileUtils.getFileByAbsolutePath(session, ServerRepositoryPaths.getTenantHomeFolderPath(theTenant), this.pathConversionHelper, this.lockHelper, false, null);
            if (tenantHomeFolder == null) {
                String ownerId = this.tenantedUserNameUtils.getPrincipleId(theTenant, username);
                ownerSid = new RepositoryFileSid(ownerId, RepositoryFileSid.Type.USER);
                String tenantAuthenticatedRoleId = this.tenantedRoleNameUtils.getPrincipleId(theTenant, this.authenticatedRoleName);
                RepositoryFileSid tenantAuthenticatedRoleSid = new RepositoryFileSid(tenantAuthenticatedRoleId, RepositoryFileSid.Type.ROLE);
                aclsForTenantHomeFolder = new RepositoryFileAcl.Builder(userSid).ace(tenantAuthenticatedRoleSid, EnumSet.of(RepositoryFilePermission.READ));
                aclsForUserHomeFolder = new RepositoryFileAcl.Builder(userSid).ace(ownerSid, EnumSet.of(RepositoryFilePermission.ALL));
                tenantHomeFolder = this.internalCreateFolder(session, tenantRootFolder.getId(), new RepositoryFile.Builder(ServerRepositoryPaths.getTenantHomeFolderName()).folder(true).title(Messages.getInstance().getString("AbstractJcrBackedUserRoleDao.usersFolderDisplayName")).build(), aclsForTenantHomeFolder.build(), "tenant home folder");
            } else {
                String ownerId = this.tenantedUserNameUtils.getPrincipleId(theTenant, username);
                ownerSid = new RepositoryFileSid(ownerId, RepositoryFileSid.Type.USER);
                aclsForUserHomeFolder = new RepositoryFileAcl.Builder(userSid).ace(ownerSid, EnumSet.of(RepositoryFilePermission.ALL));
            }
            userHomeFolder = JcrRepositoryFileUtils.getFileByAbsolutePath(session, ServerRepositoryPaths.getUserHomeFolderPath(theTenant, username), this.pathConversionHelper, this.lockHelper, false, null);
            if (userHomeFolder == null) {
                userHomeFolder = this.internalCreateFolder(session, tenantHomeFolder.getId(), new RepositoryFile.Builder(username).folder(true).build(), aclsForUserHomeFolder.build(), "user home folder");
            }
        }
        return userHomeFolder;
    }

    private RepositoryFile internalCreateFolder(Session session, Serializable parentFolderId, RepositoryFile folder, RepositoryFileAcl acl, String versionMessage) throws RepositoryException {
        PentahoJcrConstants pentahoJcrConstants = new PentahoJcrConstants(session);
        JcrRepositoryFileUtils.checkoutNearestVersionableFileIfNecessary(session, pentahoJcrConstants, parentFolderId);
        Node folderNode = JcrRepositoryFileUtils.createFolderNode(session, pentahoJcrConstants, parentFolderId, folder);
        JcrRepositoryFileAclUtils.createAcl(session, pentahoJcrConstants, (Serializable)((Object)folderNode.getIdentifier()), acl == null ? this.defaultAclHandler.createDefaultAcl(folder) : acl);
        session.save();
        if (folder.isVersioned()) {
            JcrRepositoryFileUtils.checkinNearestVersionableNodeIfNecessary(session, pentahoJcrConstants, folderNode, versionMessage);
        }
        JcrRepositoryFileUtils.checkinNearestVersionableFileIfNecessary(session, pentahoJcrConstants, parentFolderId, Messages.getInstance().getString("JcrRepositoryFileDao.USER_0001_VER_COMMENT_ADD_FOLDER", new Object[]{folder.getName(), parentFolderId == null ? "root" : parentFolderId.toString()}));
        return JcrRepositoryFileUtils.nodeToFile(session, pentahoJcrConstants, this.pathConversionHelper, this.lockHelper, folderNode);
    }

    private boolean canDeleteUser(Session session, IPentahoUser user) throws RepositoryException {
        boolean userHasAdminRole = false;
        List roles = this.getUserRoles(null, user.getUsername());
        for (IPentahoRole role : roles) {
            if (!this.tenantAdminRoleName.equals(role.getName())) continue;
            userHasAdminRole = true;
            break;
        }
        if ((this.isMyself(user.getUsername()) || this.isDefaultAdminUser(user.getUsername())) && userHasAdminRole) {
            throw new RepositoryException(Messages.getInstance().getString("AbstractJcrBackedUserRoleDao.ERROR_0008_UNABLE_TO_DELETE_USER_IS_YOURSELF_OR_DEFAULT_ADMIN_USER"));
        }
        if (userHasAdminRole) {
            List<IPentahoUser> usersWithAdminRole = this.getRoleMembers(session, null, this.tenantAdminRoleName);
            if (usersWithAdminRole == null) {
                throw new RepositoryException(Messages.getInstance().getString("AbstractJcrBackedUserRoleDao.ERROR_0004_LAST_USER_NEEDED_IN_ROLE", new Object[]{this.tenantAdminRoleName}));
            }
            if (usersWithAdminRole.size() > 1) {
                return true;
            }
            if (usersWithAdminRole.size() == 1) {
                return false;
            }
            throw new RepositoryException(Messages.getInstance().getString("AbstractJcrBackedUserRoleDao.ERROR_0004_LAST_USER_NEEDED_IN_ROLE", new Object[]{this.tenantAdminRoleName}));
        }
        return true;
    }

    private boolean canDeleteRole(Session session, IPentahoRole role) {
        return role == null || !this.systemRoles.contains(role.getName());
    }

    private String[] findRemovedUsers(List<IPentahoUser> savedUsers, String[] toBeSaved) {
        ArrayList<String> usersToBeRemoved = new ArrayList<String>();
        List<String> toBeSavedUsers = Arrays.asList(toBeSaved);
        for (int i = 0; i < savedUsers.size(); ++i) {
            if (toBeSavedUsers != null && toBeSaved.length > 0) {
                if (toBeSavedUsers.contains(savedUsers.get(i).getUsername())) continue;
                usersToBeRemoved.add(savedUsers.get(i).getUsername());
                continue;
            }
            usersToBeRemoved.add(savedUsers.get(i).getUsername());
        }
        return usersToBeRemoved.toArray(new String[0]);
    }

    public boolean isUseJackrabbitUserCache() {
        return this.useJackrabbitUserCache;
    }

    public void setUseJackrabbitUserCache(boolean useJackrabbitUserCache) {
        this.useJackrabbitUserCache = useJackrabbitUserCache;
    }

    @VisibleForTesting
    LRUMap getUserCache() {
        return this.userCache;
    }
}

