/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.util;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalRelationship;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.model.concept.types.TargetTableType;
import org.pentaho.metadata.model.olap.OlapAnnotation;
import org.pentaho.metadata.model.olap.OlapCalculatedMember;
import org.pentaho.metadata.model.olap.OlapCube;
import org.pentaho.metadata.model.olap.OlapDimension;
import org.pentaho.metadata.model.olap.OlapDimensionUsage;
import org.pentaho.metadata.model.olap.OlapHierarchy;
import org.pentaho.metadata.model.olap.OlapHierarchyLevel;
import org.pentaho.metadata.model.olap.OlapMeasure;
import org.pentaho.metadata.model.olap.OlapRole;
import org.pentaho.metadata.util.Util;

public class MondrianModelExporter {
    private LogicalModel businessModel;
    private String locale;

    public MondrianModelExporter(LogicalModel businessModel, String locale) {
        this.businessModel = businessModel;
        this.locale = locale;
    }

    public String createMondrianModelXML() throws Exception {
        List roles;
        List olapCubes;
        StringBuilder xml = new StringBuilder(10000);
        xml.append("<Schema ");
        xml.append("name=\"");
        String name = this.businessModel.getName(this.locale);
        if (this.businessModel.getProperty("AGILE_BI_GENERATED_SCHEMA") != null) {
            name = name.replace("_OLAP", "");
        }
        XMLHandler.appendReplacedChars((StringBuilder)xml, (String)name);
        xml.append("\">");
        xml.append(Util.CR);
        List olapDimensions = (List)this.businessModel.getProperty("olap_dimensions");
        if (olapDimensions != null) {
            for (int d = 0; d < olapDimensions.size(); ++d) {
                OlapDimension olapDimension = (OlapDimension)olapDimensions.get(d);
                xml.append("  <Dimension");
                xml.append(" name=\"");
                XMLHandler.appendReplacedChars((StringBuilder)xml, (String)olapDimension.getName());
                xml.append("\"");
                if (olapDimension.isTimeDimension()) {
                    xml.append(" type=\"");
                    XMLHandler.appendReplacedChars((StringBuilder)xml, (String)"TimeDimension");
                    xml.append("\"");
                }
                xml.append(">");
                xml.append(Util.CR);
                List<OlapHierarchy> olapHierarchies = olapDimension.getHierarchies();
                for (int h = 0; h < olapHierarchies.size(); ++h) {
                    OlapHierarchy olapHierarchy = olapHierarchies.get(h);
                    xml.append("    <Hierarchy");
                    if (StringUtils.isNotEmpty((String)olapHierarchy.getName()) && !StringUtils.equals((String)olapHierarchy.getName(), (String)olapDimension.getName())) {
                        xml.append(" name=\"");
                        xml.append(olapHierarchy.getName());
                        xml.append("\"");
                    }
                    xml.append(" hasAll=\"");
                    xml.append(olapHierarchy.isHavingAll() ? "true" : "false");
                    xml.append("\"");
                    if (olapHierarchy.getPrimaryKey() != null) {
                        xml.append(" primaryKey=\"");
                        xml.append(olapHierarchy.getPrimaryKey().getProperty("target_column"));
                        xml.append("\"");
                    }
                    xml.append(">");
                    xml.append(Util.CR);
                    if (olapHierarchy.getLogicalTable().getProperty("target_table_type") == TargetTableType.INLINE_SQL) {
                        xml.append("    <View alias=\"FACT\">").append(Util.CR);
                        xml.append("        <SQL dialect=\"generic\">").append(Util.CR);
                        xml.append("         <![CDATA[" + olapHierarchy.getLogicalTable().getProperty("target_table") + "]]>").append(Util.CR);
                        xml.append("        </SQL>").append(Util.CR);
                        xml.append("    </View>").append(Util.CR);
                    } else {
                        xml.append("      <Table");
                        xml.append(" name=\"");
                        XMLHandler.appendReplacedChars((StringBuilder)xml, (String)this.cleanseDbName((String)olapHierarchy.getLogicalTable().getProperty("target_table")));
                        xml.append("\"");
                        if (!StringUtils.isBlank((String)((String)olapHierarchy.getLogicalTable().getProperty("target_schema")))) {
                            xml.append(" schema=\"");
                            XMLHandler.appendReplacedChars((StringBuilder)xml, (String)this.cleanseDbName((String)olapHierarchy.getLogicalTable().getProperty("target_schema")));
                            xml.append("\"");
                        }
                        xml.append("/>");
                        xml.append(Util.CR);
                    }
                    List<OlapHierarchyLevel> hierarchyLevels = olapHierarchy.getHierarchyLevels();
                    for (int hl = 0; hl < hierarchyLevels.size(); ++hl) {
                        String levelType;
                        OlapHierarchyLevel olapHierarchyLevel = hierarchyLevels.get(hl);
                        xml.append("      <Level");
                        xml.append(" name=\"");
                        XMLHandler.appendReplacedChars((StringBuilder)xml, (String)olapHierarchyLevel.getName());
                        xml.append("\"");
                        xml.append(" uniqueMembers=\"");
                        XMLHandler.appendReplacedChars((StringBuilder)xml, (String)(olapHierarchyLevel.isHavingUniqueMembers() ? "true" : "false"));
                        xml.append("\"");
                        LogicalColumn column = olapHierarchyLevel.getReferenceColumn();
                        xml.append(" column=\"");
                        XMLHandler.appendReplacedChars((StringBuilder)xml, (String)((String)column.getProperty("target_column")));
                        xml.append("\"");
                        column = olapHierarchyLevel.getReferenceOrdinalColumn();
                        if (column != null) {
                            xml.append(" ordinalColumn=\"");
                            XMLHandler.appendReplacedChars((StringBuilder)xml, (String)((String)column.getProperty("target_column")));
                            xml.append("\"");
                        }
                        if ((column = olapHierarchyLevel.getReferenceCaptionColumn()) != null) {
                            xml.append(" captionColumn=\"");
                            XMLHandler.appendReplacedChars((StringBuilder)xml, (String)((String)column.getProperty("target_column")));
                            xml.append("\"");
                        }
                        if ((levelType = olapHierarchyLevel.getLevelType()) != null && !levelType.equals("")) {
                            xml.append(" levelType=\"");
                            XMLHandler.appendReplacedChars((StringBuilder)xml, (String)levelType);
                            xml.append("\"");
                        }
                        DataType dataTypeLevel = olapHierarchyLevel.getReferenceColumn().getDataType();
                        String typeDescLevel = null;
                        switch (dataTypeLevel) {
                            case STRING: {
                                typeDescLevel = "String";
                                break;
                            }
                            case NUMERIC: {
                                typeDescLevel = "Numeric";
                                break;
                            }
                            case BOOLEAN: {
                                typeDescLevel = "Boolean";
                                break;
                            }
                            case DATE: {
                                typeDescLevel = "Date";
                            }
                        }
                        if (typeDescLevel != null) {
                            xml.append(" type=\"");
                            XMLHandler.appendReplacedChars((StringBuilder)xml, (String)typeDescLevel);
                            xml.append("\"");
                        }
                        if (olapHierarchyLevel.isHidden()) {
                            xml.append(" visible=\"");
                            XMLHandler.appendReplacedChars((StringBuilder)xml, (String)(!olapHierarchyLevel.isHidden() + ""));
                            xml.append("\"");
                        }
                        if (!StringUtils.isBlank((String)olapHierarchyLevel.getFormatter())) {
                            xml.append(" formatter=\"");
                            XMLHandler.appendReplacedChars((StringBuilder)xml, (String)olapHierarchyLevel.getFormatter());
                            xml.append("\"");
                        }
                        xml.append(">");
                        xml.append(Util.CR);
                        if (olapHierarchyLevel.getAnnotations().size() > 0) {
                            xml.append("        <Annotations>");
                            for (OlapAnnotation annotation : olapHierarchyLevel.getAnnotations()) {
                                xml.append(Util.CR);
                                OlapAnnotation escapedAnnotation = this.escapeAnnotationValue(annotation);
                                xml.append(escapedAnnotation.asXml());
                            }
                            xml.append(Util.CR);
                            xml.append("        </Annotations>");
                            xml.append(Util.CR);
                        }
                        List<LogicalColumn> businessColumns = olapHierarchyLevel.getLogicalColumns();
                        for (int i = 0; i < businessColumns.size(); ++i) {
                            LogicalColumn businessColumn = businessColumns.get(i);
                            xml.append("        <Property");
                            xml.append(" name=\"");
                            XMLHandler.appendReplacedChars((StringBuilder)xml, (String)businessColumn.getName(this.locale));
                            xml.append("\"");
                            xml.append(" column=\"");
                            XMLHandler.appendReplacedChars((StringBuilder)xml, (String)((String)businessColumn.getProperty("target_column")));
                            xml.append("\"");
                            DataType dataType = businessColumn.getDataType();
                            String typeDesc = null;
                            switch (dataType) {
                                case STRING: {
                                    typeDesc = "String";
                                    break;
                                }
                                case NUMERIC: {
                                    typeDesc = "Numeric";
                                    break;
                                }
                                case BOOLEAN: {
                                    typeDesc = "Boolean";
                                    break;
                                }
                                case DATE: {
                                    typeDesc = "Date";
                                }
                            }
                            if (typeDesc != null) {
                                xml.append(" type=\"");
                                XMLHandler.appendReplacedChars((StringBuilder)xml, (String)typeDesc);
                                xml.append("\"");
                            }
                            if (businessColumn.getDescription() != null) {
                                xml.append(" description=\"");
                                XMLHandler.appendReplacedChars((StringBuilder)xml, (String)businessColumn.getDescription(this.locale));
                                xml.append("\"");
                            }
                            xml.append("/>");
                            xml.append(Util.CR);
                        }
                        xml.append("      </Level>").append(Util.CR);
                    }
                    xml.append("    </Hierarchy>").append(Util.CR);
                }
                xml.append("  </Dimension>").append(Util.CR);
            }
        }
        if ((olapCubes = (List)this.businessModel.getProperty("olap_cubes")) != null) {
            for (int c = 0; c < olapCubes.size(); ++c) {
                OlapCube olapCube = (OlapCube)olapCubes.get(c);
                xml.append("  <Cube");
                xml.append(" name=\"");
                XMLHandler.appendReplacedChars((StringBuilder)xml, (String)olapCube.getName());
                xml.append("\"");
                xml.append(">").append(Util.CR);
                if (olapCube.getLogicalTable().getProperty("target_table_type") == TargetTableType.INLINE_SQL) {
                    xml.append("    <View alias=\"FACT\">").append(Util.CR);
                    xml.append("        <SQL dialect=\"generic\">").append(Util.CR);
                    xml.append("         <![CDATA[" + olapCube.getLogicalTable().getProperty("target_table") + "]]>").append(Util.CR);
                    xml.append("        </SQL>").append(Util.CR);
                    xml.append("    </View>").append(Util.CR);
                } else {
                    xml.append("    <Table");
                    xml.append(" name=\"");
                    XMLHandler.appendReplacedChars((StringBuilder)xml, (String)this.cleanseDbName((String)olapCube.getLogicalTable().getProperty("target_table")));
                    xml.append("\"");
                    if (!StringUtils.isBlank((String)((String)olapCube.getLogicalTable().getProperty("target_schema")))) {
                        xml.append(" schema=\"");
                        XMLHandler.appendReplacedChars((StringBuilder)xml, (String)this.cleanseDbName((String)olapCube.getLogicalTable().getProperty("target_schema")));
                        xml.append("\"");
                    }
                    xml.append("/>").append(Util.CR);
                }
                List<OlapDimensionUsage> usages = olapCube.getOlapDimensionUsages();
                for (int u = 0; u < usages.size(); ++u) {
                    OlapDimensionUsage usage = usages.get(u);
                    xml.append("    <DimensionUsage");
                    xml.append(" name=\"");
                    XMLHandler.appendReplacedChars((StringBuilder)xml, (String)usage.getName());
                    xml.append("\"");
                    xml.append(" source=\"");
                    XMLHandler.appendReplacedChars((StringBuilder)xml, (String)usage.getOlapDimension().getName());
                    xml.append("\"");
                    LogicalTable dimTable = usage.getOlapDimension().findLogicalTable();
                    LogicalTable cubeTable = olapCube.getLogicalTable();
                    LogicalRelationship relationshipMeta = this.businessModel.findRelationshipUsing(dimTable, cubeTable);
                    if (!dimTable.equals(cubeTable) || relationshipMeta != null) {
                        if (relationshipMeta != null) {
                            LogicalColumn keyColumn = relationshipMeta.getFromTable().equals(dimTable) ? relationshipMeta.getToColumn() : relationshipMeta.getFromColumn();
                            xml.append(" foreignKey=\"");
                            XMLHandler.appendReplacedChars((StringBuilder)xml, (String)((String)keyColumn.getProperty("target_column")));
                            xml.append("\"");
                        } else {
                            throw new Exception(Messages.getString("MondrianModelExporter.ERROR_0001_ERROR_NO_RELATIONSHIP", dimTable.getName(this.locale), cubeTable.toString()));
                        }
                    }
                    xml.append("/>").append(Util.CR);
                }
                List<OlapMeasure> measures = olapCube.getOlapMeasures();
                for (int m = 0; m < measures.size(); ++m) {
                    String desc;
                    LocalizedString description;
                    String formatString;
                    OlapMeasure measure = measures.get(m);
                    LogicalColumn businessColumn = measure.getLogicalColumn();
                    xml.append("    <Measure");
                    xml.append(" name=\"");
                    XMLHandler.appendReplacedChars((StringBuilder)xml, (String)businessColumn.getName(this.locale));
                    xml.append("\"");
                    xml.append(" column=\"");
                    XMLHandler.appendReplacedChars((StringBuilder)xml, (String)((String)businessColumn.getProperty("target_column")));
                    xml.append("\"");
                    String typeDesc = MondrianModelExporter.convertToMondrian(businessColumn.getAggregationType());
                    if (typeDesc != null) {
                        xml.append(" aggregator=\"");
                        XMLHandler.appendReplacedChars((StringBuilder)xml, (String)typeDesc);
                        xml.append("\"");
                    }
                    if (!StringUtils.isEmpty((String)(formatString = (String)businessColumn.getProperty("mask")))) {
                        xml.append(" formatString=\"");
                        XMLHandler.appendReplacedChars((StringBuilder)xml, (String)formatString);
                        xml.append("\"");
                    }
                    if ((description = businessColumn.getDescription()) != null && !StringUtils.isEmpty((String)(desc = description.getLocalizedString(this.locale)))) {
                        xml.append(" description=\"");
                        XMLHandler.appendReplacedChars((StringBuilder)xml, (String)desc);
                        xml.append("\"");
                    }
                    if (measure.isHidden()) {
                        xml.append(" visible=\"");
                        XMLHandler.appendReplacedChars((StringBuilder)xml, (String)(!measure.isHidden() + ""));
                        xml.append("\"");
                    }
                    xml.append("/>").append(Util.CR);
                }
                if (olapCube.getOlapCalculatedMembers() != null) {
                    for (OlapCalculatedMember member : olapCube.getOlapCalculatedMembers()) {
                        xml.append("    <CalculatedMember");
                        xml.append(" name=\"");
                        XMLHandler.appendReplacedChars((StringBuilder)xml, (String)member.getName());
                        xml.append("\"");
                        xml.append(" dimension=\"");
                        XMLHandler.appendReplacedChars((StringBuilder)xml, (String)member.getDimension());
                        xml.append("\"");
                        String formatString = member.getFormatString();
                        if (!StringUtils.isEmpty((String)formatString)) {
                            xml.append(" formatString=\"");
                            XMLHandler.appendReplacedChars((StringBuilder)xml, (String)formatString);
                            xml.append("\"");
                        }
                        if (member.isHidden()) {
                            xml.append(" visible=\"");
                            XMLHandler.appendReplacedChars((StringBuilder)xml, (String)(!member.isHidden() + ""));
                            xml.append("\"");
                        }
                        xml.append(">").append(Util.CR);
                        xml.append("<Formula><![CDATA[").append(member.getFormula());
                        xml.append("]]>").append("</Formula>").append(Util.CR);
                        String solveOrder = member.isCalculateSubtotals() ? "200" : "0";
                        xml.append("<CalculatedMemberProperty name=\"SOLVE_ORDER\" value=\"").append(solveOrder).append("\"/>").append(Util.CR);
                        xml.append("</CalculatedMember>").append(Util.CR);
                    }
                }
                xml.append("  </Cube>").append(Util.CR);
            }
        }
        if ((roles = (List)this.businessModel.getProperty("olap_roles")) != null && roles.size() > 0) {
            for (OlapRole role : roles) {
                xml.append("  <Role name=\">");
                XMLHandler.appendReplacedChars((StringBuilder)xml, (String)role.getName());
                xml.append("\">").append(Util.CR);
                xml.append(role.getDefinition());
                xml.append("  </Role>").append(Util.CR);
            }
        }
        xml.append("</Schema>");
        return xml.toString();
    }

    private String cleanseDbName(String name) {
        return name.replaceAll("^[`'\"]|[`'\"]$", "");
    }

    private OlapAnnotation escapeAnnotationValue(OlapAnnotation annotation) {
        StringBuilder escapedValue = new StringBuilder();
        XMLHandler.appendReplacedChars((StringBuilder)escapedValue, (String)annotation.getValue());
        return new OlapAnnotation(annotation.getName(), escapedValue.toString());
    }

    public LogicalModel getLogicalModel() {
        return this.businessModel;
    }

    public void setLogicalModel(LogicalModel businessModel) {
        this.businessModel = businessModel;
    }

    public static String convertToMondrian(AggregationType aggregationType) {
        String typeDesc = null;
        switch (aggregationType) {
            case NONE: {
                typeDesc = "none";
                break;
            }
            case SUM: {
                typeDesc = "sum";
                break;
            }
            case AVERAGE: {
                typeDesc = "avg";
                break;
            }
            case COUNT: {
                typeDesc = "count";
                break;
            }
            case COUNT_DISTINCT: {
                typeDesc = "distinct count";
                break;
            }
            case MINIMUM: {
                typeDesc = "min";
                break;
            }
            case MAXIMUM: {
                typeDesc = "max";
            }
        }
        return typeDesc;
    }
}

