/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.concept.types.font;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.pentaho.pms.util.Const;

public class FontSettings {
    private String name;
    private int height;
    private boolean bold;
    private boolean italic;
    private static final String SEPARATOR = "-";
    private static final String BOLD = "bold";
    private static final String ITALIC = "italic";

    public FontSettings() {
    }

    public FontSettings(String name, int size, boolean bold, boolean italic) {
        this.name = name;
        this.height = size;
        this.bold = bold;
        this.italic = italic;
    }

    public String toString() {
        return this.name + SEPARATOR + this.height + (this.bold ? "-bold" : "") + (this.italic ? "-italic" : "");
    }

    public static FontSettings fromString(String value) {
        String[] pieces = value.split(SEPARATOR);
        switch (pieces.length) {
            case 0: {
                return null;
            }
            case 1: {
                return new FontSettings(pieces[0], 10, false, false);
            }
            case 2: {
                return new FontSettings(pieces[0], Const.toInt(pieces[1], 10), false, false);
            }
            case 3: {
                return new FontSettings(pieces[0], Const.toInt(pieces[1], 10), BOLD.equalsIgnoreCase(pieces[2]), ITALIC.equalsIgnoreCase(pieces[2]));
            }
            case 4: {
                return new FontSettings(pieces[0], Const.toInt(pieces[1], 10), true, true);
            }
        }
        return null;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int size) {
        this.height = size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FontSettings)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        FontSettings rhs = (FontSettings)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)rhs.name).append(this.height, rhs.height).append(this.bold, rhs.bold).append(this.italic, rhs.italic).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(89, 211).append((Object)this.name).append(this.height).append(this.bold).append(this.italic).toHashCode();
    }
}

