/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockCollection;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoUnderConstruction;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.util.LightWeightGSet;

@InterfaceAudience.Private
public class BlockInfo
extends Block
implements LightWeightGSet.LinkedElement {
    public static final BlockInfo[] EMPTY_ARRAY = new BlockInfo[0];
    private BlockCollection bc;
    private LightWeightGSet.LinkedElement nextLinkedElement;
    private DatanodeStorageInfo[] storages;

    public BlockInfo(short replication) {
        this.storages = new DatanodeStorageInfo[replication];
        this.bc = null;
    }

    public BlockInfo(Block blk, short replication) {
        super(blk);
        this.storages = new DatanodeStorageInfo[replication];
        this.bc = null;
    }

    protected BlockInfo(BlockInfo from) {
        this(from, from.bc.getBlockReplication());
        this.bc = from.bc;
    }

    public BlockCollection getBlockCollection() {
        return this.bc;
    }

    public void setBlockCollection(BlockCollection bc) {
        this.bc = bc;
    }

    public boolean isDeleted() {
        return this.bc == null;
    }

    public DatanodeDescriptor getDatanode(int index) {
        DatanodeStorageInfo storage = this.getStorageInfo(index);
        return storage == null ? null : storage.getDatanodeDescriptor();
    }

    DatanodeStorageInfo getStorageInfo(int index) {
        assert (this.storages != null) : "BlockInfo is not initialized";
        return this.storages[index];
    }

    public Iterator<DatanodeStorageInfo> getStorageInfos() {
        return new Iterator<DatanodeStorageInfo>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < BlockInfo.this.storages.length && BlockInfo.this.storages[this.index] != null;
            }

            @Override
            public DatanodeStorageInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return BlockInfo.this.storages[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Sorry. can't remove.");
            }
        };
    }

    private void setStorageInfo(int index, DatanodeStorageInfo storage) {
        assert (this.storages != null) : "BlockInfo is not initialized";
        this.storages[index] = storage;
    }

    public int getCapacity() {
        assert (this.storages != null) : "BlockInfo is not initialized";
        return this.storages.length;
    }

    private int ensureCapacity(int num) {
        assert (this.storages != null) : "BlockInfo is not initialized";
        int last = this.numNodes();
        if (this.storages.length >= last + num) {
            return last;
        }
        DatanodeStorageInfo[] old = this.storages;
        this.storages = new DatanodeStorageInfo[last + num];
        System.arraycopy(old, 0, this.storages, 0, last);
        return last;
    }

    public int numNodes() {
        assert (this.storages != null) : "BlockInfo is not initialized";
        for (int idx = this.getCapacity() - 1; idx >= 0; --idx) {
            if (this.getDatanode(idx) == null) continue;
            return idx + 1;
        }
        return 0;
    }

    boolean addStorage(DatanodeStorageInfo storage) {
        int lastNode = this.ensureCapacity(1);
        this.setStorageInfo(lastNode, storage);
        return true;
    }

    boolean removeStorage(DatanodeStorageInfo storage) {
        int dnIndex = this.findStorageInfo(storage);
        if (dnIndex < 0) {
            return false;
        }
        int lastNode = this.numNodes() - 1;
        this.setStorageInfo(dnIndex, this.getStorageInfo(lastNode));
        this.setStorageInfo(lastNode, null);
        return true;
    }

    DatanodeStorageInfo findStorageInfo(DatanodeDescriptor dn) {
        DatanodeStorageInfo cur;
        int len = this.getCapacity();
        for (int idx = 0; idx < len && (cur = this.getStorageInfo(idx)) != null; ++idx) {
            if (cur.getDatanodeDescriptor() != dn) continue;
            return cur;
        }
        return null;
    }

    int findStorageInfo(DatanodeStorageInfo storageInfo) {
        int len = this.getCapacity();
        for (int idx = 0; idx < len; ++idx) {
            DatanodeStorageInfo cur = this.getStorageInfo(idx);
            if (cur == storageInfo) {
                return idx;
            }
            if (cur == null) break;
        }
        return -1;
    }

    public HdfsServerConstants.BlockUCState getBlockUCState() {
        return HdfsServerConstants.BlockUCState.COMPLETE;
    }

    public boolean isComplete() {
        return this.getBlockUCState().equals((Object)HdfsServerConstants.BlockUCState.COMPLETE);
    }

    public BlockInfoUnderConstruction convertToBlockUnderConstruction(HdfsServerConstants.BlockUCState s, DatanodeStorageInfo[] targets) {
        if (this.isComplete()) {
            return new BlockInfoUnderConstruction(this, this.getBlockCollection().getBlockReplication(), s, targets);
        }
        BlockInfoUnderConstruction ucBlock = (BlockInfoUnderConstruction)this;
        ucBlock.setBlockUCState(s);
        ucBlock.setExpectedLocations(targets);
        return ucBlock;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }

    public LightWeightGSet.LinkedElement getNext() {
        return this.nextLinkedElement;
    }

    public void setNext(LightWeightGSet.LinkedElement next) {
        this.nextLinkedElement = next;
    }
}

