/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.cloudera.org.codehaus.jackson.map.ObjectMapper;
import com.cloudera.org.codehaus.jackson.map.type.TypeFactory;
import com.cloudera.org.codehaus.jackson.type.JavaType;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.datanode.DiskBalancerWorkItem;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DiskBalancerWorkStatus {
    private final List<DiskBalancerWorkEntry> currentState;
    private Result result;
    private String planID;

    public DiskBalancerWorkStatus() {
        this.currentState = new LinkedList<DiskBalancerWorkEntry>();
    }

    public DiskBalancerWorkStatus(Result result, String planID) {
        this();
        this.result = result;
        this.planID = planID;
    }

    public DiskBalancerWorkStatus(Result result, String planID, List<DiskBalancerWorkEntry> currentState) {
        this.result = result;
        this.planID = planID;
        this.currentState = currentState;
    }

    public DiskBalancerWorkStatus(Result result, String planID, String currentState) throws IOException {
        this.result = result;
        this.planID = planID;
        ObjectMapper mapper = new ObjectMapper();
        this.currentState = (List)mapper.readValue(currentState, (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, DiskBalancerWorkEntry.class));
    }

    public Result getResult() {
        return this.result;
    }

    public String getPlanID() {
        return this.planID;
    }

    public List<DiskBalancerWorkEntry> getCurrentState() {
        return this.currentState;
    }

    public String currentStateString() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(this.currentState);
    }

    public String toJsonString() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(this);
    }

    public static DiskBalancerWorkStatus parseJson(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readValue(json, DiskBalancerWorkStatus.class);
    }

    public void addWorkEntry(DiskBalancerWorkEntry entry) {
        Preconditions.checkNotNull((Object)entry);
        this.currentState.add(entry);
    }

    public static class DiskBalancerWorkEntry {
        private String sourcePath;
        private String destPath;
        private DiskBalancerWorkItem workItem;

        public DiskBalancerWorkEntry() {
        }

        public DiskBalancerWorkEntry(String workItem) throws IOException {
            this.workItem = DiskBalancerWorkItem.parseJson(workItem);
        }

        public DiskBalancerWorkEntry(String sourcePath, String destPath, DiskBalancerWorkItem workItem) {
            this.sourcePath = sourcePath;
            this.destPath = destPath;
            this.workItem = workItem;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        public String getDestPath() {
            return this.destPath;
        }

        public void setDestPath(String destPath) {
            this.destPath = destPath;
        }

        public DiskBalancerWorkItem getWorkItem() {
            return this.workItem;
        }

        public void setWorkItem(DiskBalancerWorkItem workItem) {
            this.workItem = workItem;
        }
    }

    public static enum Result {
        NO_PLAN(0),
        PLAN_UNDER_PROGRESS(1),
        PLAN_DONE(2),
        PLAN_CANCELLED(3);

        private int result;

        private Result(int result) {
            this.result = result;
        }

        public int getIntResult() {
            return this.result;
        }
    }
}

