/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.util.FoldedTreeSet;

class ReplicaMap {
    private final Object mutex;
    private final Map<String, FoldedTreeSet<ReplicaInfo>> map = new HashMap<String, FoldedTreeSet<ReplicaInfo>>();
    private static final Comparator<Object> LONG_AND_BLOCK_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            long stored;
            long lookup = (Long)o1;
            return lookup > (stored = ((Block)o2).getBlockId()) ? 1 : (lookup < stored ? -1 : 0);
        }
    };

    ReplicaMap(Object mutex) {
        if (mutex == null) {
            throw new HadoopIllegalArgumentException("Object to synchronize on cannot be null");
        }
        this.mutex = mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getBlockPoolList() {
        Object object = this.mutex;
        synchronized (object) {
            return this.map.keySet().toArray(new String[this.map.keySet().size()]);
        }
    }

    private void checkBlockPool(String bpid) {
        if (bpid == null) {
            throw new IllegalArgumentException("Block Pool Id is null");
        }
    }

    private void checkBlock(Block b) {
        if (b == null) {
            throw new IllegalArgumentException("Block is null");
        }
    }

    ReplicaInfo get(String bpid, Block block) {
        this.checkBlockPool(bpid);
        this.checkBlock(block);
        ReplicaInfo replicaInfo = this.get(bpid, block.getBlockId());
        if (replicaInfo != null && block.getGenerationStamp() == replicaInfo.getGenerationStamp()) {
            return replicaInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReplicaInfo get(String bpid, long blockId) {
        this.checkBlockPool(bpid);
        Object object = this.mutex;
        synchronized (object) {
            FoldedTreeSet<ReplicaInfo> set = this.map.get(bpid);
            if (set == null) {
                return null;
            }
            return set.get(blockId, LONG_AND_BLOCK_COMPARATOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReplicaInfo add(String bpid, ReplicaInfo replicaInfo) {
        this.checkBlockPool(bpid);
        this.checkBlock(replicaInfo);
        Object object = this.mutex;
        synchronized (object) {
            FoldedTreeSet<ReplicaInfo> set = this.map.get(bpid);
            if (set == null) {
                set = new FoldedTreeSet();
                this.map.put(bpid, set);
            }
            return set.addOrReplace(replicaInfo);
        }
    }

    void addAll(ReplicaMap other) {
        this.map.putAll(other.map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReplicaInfo remove(String bpid, Block block) {
        this.checkBlockPool(bpid);
        this.checkBlock(block);
        Object object = this.mutex;
        synchronized (object) {
            ReplicaInfo replicaInfo;
            FoldedTreeSet<ReplicaInfo> set = this.map.get(bpid);
            if (set != null && (replicaInfo = set.get(block.getBlockId(), LONG_AND_BLOCK_COMPARATOR)) != null && block.getGenerationStamp() == replicaInfo.getGenerationStamp()) {
                return set.removeAndGet(replicaInfo);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReplicaInfo remove(String bpid, long blockId) {
        this.checkBlockPool(bpid);
        Object object = this.mutex;
        synchronized (object) {
            FoldedTreeSet<ReplicaInfo> set = this.map.get(bpid);
            if (set != null) {
                return set.removeAndGet(blockId, LONG_AND_BLOCK_COMPARATOR);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size(String bpid) {
        Object object = this.mutex;
        synchronized (object) {
            FoldedTreeSet<ReplicaInfo> set = this.map.get(bpid);
            return set != null ? set.size() : 0;
        }
    }

    Collection<ReplicaInfo> replicas(String bpid) {
        return this.map.get(bpid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initBlockPool(String bpid) {
        this.checkBlockPool(bpid);
        Object object = this.mutex;
        synchronized (object) {
            FoldedTreeSet<ReplicaInfo> set = this.map.get(bpid);
            if (set == null) {
                set = new FoldedTreeSet();
                this.map.put(bpid, set);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUpBlockPool(String bpid) {
        this.checkBlockPool(bpid);
        Object object = this.mutex;
        synchronized (object) {
            this.map.remove(bpid);
        }
    }

    Object getMutex() {
        return this.mutex;
    }
}

