/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.command;

import com.google.common.base.Preconditions;
import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.server.datanode.DiskBalancerWorkStatus;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerException;
import org.apache.hadoop.hdfs.server.diskbalancer.command.Command;

public class QueryCommand
extends Command {
    public QueryCommand(Configuration conf) {
        super(conf);
        this.addValidCommandParameters("query", "Queries the status of disk plan running on a given datanode.");
        this.addValidCommandParameters("v", "Prints verbose results.");
    }

    @Override
    public void execute(CommandLine cmd) throws Exception {
        LOG.info("Executing \"query plan\" command.");
        Preconditions.checkState((boolean)cmd.hasOption("query"));
        this.verifyCommandOptions("query", cmd);
        String nodeName = cmd.getOptionValue("query");
        Preconditions.checkNotNull((Object)nodeName);
        ClientDatanodeProtocol dataNode = this.getDataNodeProxy(nodeName);
        try {
            DiskBalancerWorkStatus workStatus = dataNode.queryDiskBalancerPlan();
            System.out.printf("Plan ID: %s Result: %s%n", workStatus.getPlanID(), workStatus.getResult().toString());
            if (cmd.hasOption("v")) {
                System.out.printf("%s", workStatus.currentStateString());
            }
        }
        catch (DiskBalancerException ex) {
            LOG.error("Query plan failed. ex: {}", (Throwable)ex);
            throw ex;
        }
    }

    @Override
    protected String getHelp() {
        return "Gets the status of disk balancing on a given node";
    }
}

