/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.diskbalancer.command.Command;
import org.apache.hadoop.hdfs.server.diskbalancer.command.ExecuteCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.command.PlanCommand;
import org.apache.hadoop.hdfs.server.diskbalancer.command.QueryCommand;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskBalancer
extends Configured
implements Tool {
    public static final String NAMENODEURI = "uri";
    public static final String PLAN = "plan";
    public static final String OUTFILE = "out";
    public static final String HELP = "help";
    public static final String THRESHOLD = "thresholdPercentage";
    public static final String BANDWIDTH = "bandwidth";
    public static final String MAXERROR = "maxerror";
    public static final String EXECUTE = "execute";
    public static final String NODE = "node";
    public static final String VERBOSE = "v";
    public static final int PLAN_VERSION = 1;
    public static final String QUERY = "query";
    public static final String BEFORE_TEMPLATE = "%s.before.json";
    public static final String PLAN_TEMPLATE = "%s.plan.json";
    private static final Logger LOG = LoggerFactory.getLogger(DiskBalancer.class);

    public DiskBalancer(Configuration conf) {
        super(conf);
    }

    public static void main(String[] argv) throws Exception {
        DiskBalancer shell = new DiskBalancer(new HdfsConfiguration());
        int res = 0;
        try {
            res = ToolRunner.run((Tool)shell, (String[])argv);
        }
        catch (Exception ex) {
            LOG.error(ex.toString());
            System.exit(1);
        }
        System.exit(res);
    }

    public int run(String[] args) throws Exception {
        Options opts = this.getOpts();
        CommandLine cmd = this.parseArgs(args, opts);
        return this.dispatch(cmd, opts);
    }

    private Options getOpts() {
        Options opts = new Options();
        this.addPlanCommands(opts);
        this.addExecuteCommands(opts);
        this.addQueryCommands(opts);
        return opts;
    }

    private void addPlanCommands(Options opt) {
        Option nameNodeUri = new Option(NAMENODEURI, true, "NameNode URI. e.g http://namenode.mycluster.com or file:///myCluster.json");
        opt.addOption(nameNodeUri);
        Option outFile = new Option(OUTFILE, true, "File to write output to, if not specified defaults will be used.e.g -out outfile.txt");
        opt.addOption(outFile);
        Option plan = new Option(PLAN, true, "create a plan for the given node. e.g -plan <nodename> | <nodeIP> | <nodeUUID>");
        opt.addOption(plan);
        Option bandwidth = new Option(BANDWIDTH, true, "Maximum disk bandwidth to be consumed by diskBalancer. Expressed as MBs per second.");
        opt.addOption(bandwidth);
        Option threshold = new Option(THRESHOLD, true, "Percentage skew that we tolerate before diskbalancer starts working or stops when reaching that range.");
        opt.addOption(threshold);
        Option maxErrors = new Option(MAXERROR, true, "Describes how many errors can be tolerated while copying between a pair of disks.");
        opt.addOption(maxErrors);
        Option help = new Option(HELP, true, "Help about a command or this message");
        opt.addOption(help);
        Option verbose = new Option(VERBOSE, "Print out the summary of the plan");
        opt.addOption(verbose);
    }

    private void addExecuteCommands(Options opt) {
        Option execute = new Option(EXECUTE, true, "Takes a plan file and submits it for execution to the datanode. e.g -execute <planfile>");
        opt.addOption(execute);
    }

    private void addQueryCommands(Options opt) {
        Option query = new Option(QUERY, true, "Queries the disk balancer status of a given datanode. e.g. -query <nodename>");
        opt.addOption(query);
    }

    private CommandLine parseArgs(String[] argv, Options opts) throws ParseException {
        BasicParser parser = new BasicParser();
        return parser.parse(opts, argv);
    }

    private int dispatch(CommandLine cmd, Options opts) throws IOException, URISyntaxException {
        Command currentCommand = null;
        try {
            if (cmd.hasOption(PLAN)) {
                currentCommand = new PlanCommand(this.getConf());
            }
            if (cmd.hasOption(EXECUTE)) {
                currentCommand = new ExecuteCommand(this.getConf());
            }
            if (cmd.hasOption(QUERY)) {
                currentCommand = new QueryCommand(this.getConf());
            }
            if (currentCommand == null) {
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp(80, "hdfs diskbalancer -uri [args]", "disk balancer commands", opts, "Please correct your command and try again.");
                return 1;
            }
            currentCommand.execute(cmd);
        }
        catch (Exception ex) {
            System.err.printf(ex.getMessage(), new Object[0]);
            return 1;
        }
        return 0;
    }
}

