/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gis.shapefiles;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.steps.xbaseinput.XBase;
import org.pentaho.gis.shapefiles.Converter;
import org.pentaho.gis.shapefiles.GisException;
import org.pentaho.gis.shapefiles.Shape;
import org.pentaho.gis.shapefiles.ShapeFileHeader;
import org.pentaho.gis.shapefiles.ShapeInterface;
import org.pentaho.gis.shapefiles.ShapeNull;
import org.pentaho.gis.shapefiles.ShapePoint;
import org.pentaho.gis.shapefiles.ShapePolyLine;
import org.pentaho.gis.shapefiles.ShapePolyLineM;
import org.pentaho.gis.shapefiles.ShapePolygon;
import org.pentaho.gis.shapefiles.ShapeRecordHeader;

public class ShapeFile {
    private List<ShapeInterface> shapes;
    private ShapeFileHeader fileheader;
    private LogChannelInterface log;
    private String dbfFilename;
    private String shapeFilename;

    public ShapeFile(LogChannelInterface log, String name) {
        this.log = log;
        this.dbfFilename = name + ".dbf";
        this.shapeFilename = name + ".shp";
        this.shapes = new ArrayList<ShapeInterface>();
    }

    public ShapeFile(LogChannelInterface log, String shapeFilename, String dbfFilename) {
        this.log = log;
        this.shapeFilename = shapeFilename;
        this.dbfFilename = dbfFilename;
        this.shapes = new ArrayList<ShapeInterface>();
    }

    public String getShapeFilename() {
        return this.shapeFilename;
    }

    public String getDbfFilename() {
        return this.dbfFilename;
    }

    public void readFile() throws GisException, KettleException {
        File file = new File(this.shapeFilename);
        try {
            DataInputStream dis = new DataInputStream(new FileInputStream(file));
            XBase xbase = new XBase(this.log, this.dbfFilename);
            xbase.open();
            RowMetaInterface fields = xbase.getFields();
            byte[] header = new byte[100];
            dis.read(header);
            this.fileheader = new ShapeFileHeader(header);
            int id = 0;
            while (dis.available() > 0) {
                byte[] record_header = new byte[8];
                dis.read(record_header);
                ShapeRecordHeader erh = new ShapeRecordHeader(record_header);
                if (erh.length > dis.available()) continue;
                byte[] content = new byte[erh.length];
                dis.read(content);
                int btype = Converter.getIntegerLittle(content, 0);
                Shape esi = null;
                switch (btype) {
                    case 0: {
                        esi = new ShapeNull(content);
                        break;
                    }
                    case 1: {
                        esi = new ShapePoint(content);
                        break;
                    }
                    case 3: {
                        esi = new ShapePolyLine(content);
                        break;
                    }
                    case 5: {
                        esi = new ShapePolygon(content);
                        break;
                    }
                    case 23: {
                        esi = new ShapePolyLineM(content);
                        break;
                    }
                    default: {
                        throw new GisException("shape type : " + btype + " not recognized! (" + Shape.getEsriTypeDesc(btype) + ")");
                    }
                }
                Object[] row = xbase.getRow(fields);
                if (row != null) {
                    esi.setDbfData(row);
                    esi.setDbfMeta(xbase.getFields());
                }
                this.shapes.add((ShapeInterface)((Object)esi));
                ++id;
            }
            dis.close();
            xbase.close();
        }
        catch (IOException e) {
            throw new GisException("Error reading shape file", e);
        }
    }

    public int getNrShapes() {
        return this.shapes.size();
    }

    public ShapeInterface getShape(int i) {
        return this.shapes.get(i);
    }

    public void addShape(ShapeInterface esi) {
        this.shapes.add(esi);
    }

    public ShapeFileHeader getFileHeader() {
        return this.fileheader;
    }

    public String getFilename() {
        return this.shapeFilename;
    }
}

