/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public abstract class SharedClassObject
implements Externalizable {
    private static final long serialVersionUID = 4527891234589143259L;
    private static final Object PROP_SUPPORT;
    private static final Map values;
    private static final Map instancesBeingCreated;
    private static final Set alreadyWarnedAboutDupes;
    private static final ErrorManager err;
    private final DataEntry dataEntry;
    private Object lock;
    private final SharedClassObject first;
    private Throwable firstTrace = null;
    private boolean systemOption = false;
    private boolean waitingOnSystemOption = false;
    private IllegalStateException prematureSystemOptionMutation = null;
    private boolean inReadExternal = false;
    private boolean addNotifySuper;
    private boolean removeNotifySuper;
    private boolean initializeSuper;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$io$ObjectStreamException;
    static /* synthetic */ Class class$java$lang$Object;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SharedClassObject() {
        Object object = this.getLock();
        synchronized (object) {
            DataEntry dataEntry = (DataEntry)values.get(this.getClass());
            if (dataEntry == null) {
                dataEntry = new DataEntry();
                values.put(this.getClass(), dataEntry);
            }
            this.dataEntry = dataEntry;
            dataEntry.increase();
            this.first = dataEntry.first(this);
        }
        if (this.first != null) {
            if (this.first == this) {
                if (err != null && err.isLoggable(1)) {
                    object = new Throwable("First instance created here");
                    ((Throwable)object).fillInStackTrace();
                    this.first.firstTrace = object;
                }
            } else {
                boolean bl;
                object = this.getClass().getName();
                Object object2 = instancesBeingCreated;
                synchronized (object2) {
                    bl = instancesBeingCreated.containsKey(object);
                }
                if (!bl && !alreadyWarnedAboutDupes.contains(object)) {
                    alreadyWarnedAboutDupes.add(object);
                    object2 = new IllegalStateException("Warning: multiple instances of shared class " + (String)object + " created.");
                    if (this.first.firstTrace != null) {
                        err.annotate((Throwable)object2, this.first.firstTrace);
                    } else {
                        err.annotate((Throwable)object2, "(Run with -J-Dorg.openide.util.SharedClassObject=0 for more details.)");
                    }
                    err.notify(1, (Throwable)object2);
                }
            }
        }
    }

    protected final void finalize() throws Throwable {
        this.referenceLost();
    }

    protected boolean clearSharedData() {
        return true;
    }

    public final boolean equals(Object object) {
        return object instanceof SharedClassObject && this.getClass().equals(object.getClass());
    }

    public final int hashCode() {
        return this.getClass().hashCode();
    }

    protected final Object getLock() {
        if (this.lock == null) {
            this.lock = this.getClass().getName().intern();
        }
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void referenceLost() {
        Object object = this.getLock();
        synchronized (object) {
            if ((this.dataEntry == null || this.dataEntry.decrease() == 0) && this.clearSharedData()) {
                values.remove(this.getClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object putProperty(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException("Tried to pass null key (value=" + object2 + ") to putProperty");
        }
        Object object3 = this.getLock();
        synchronized (object3) {
            if (this.waitingOnSystemOption && object != PROP_SUPPORT && this.prematureSystemOptionMutation == null && !this.dataEntry.isInInitialize() && !this.inReadExternal) {
                this.prematureSystemOptionMutation = new IllegalStateException("...setting property here...");
            }
            return this.dataEntry.getMap(this).put(object, object2);
        }
    }

    protected final Object putProperty(String string, Object object, boolean bl) {
        Object object2 = this.putProperty(string, object);
        if (bl) {
            this.firePropertyChange(string, object2, object);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object getProperty(Object object) {
        Object object2 = this.getLock();
        synchronized (object2) {
            if ("org.openide.util.SharedClassObject.initialize".equals(object)) {
                return this.dataEntry.isInInitialize() ? Boolean.TRUE : null;
            }
            return this.dataEntry.get(this, object);
        }
    }

    protected void initialize() {
        this.initializeSuper = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        boolean bl;
        Object object = this.getLock();
        synchronized (object) {
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)this.getProperty(PROP_SUPPORT);
            if (propertyChangeSupport == null) {
                propertyChangeSupport = new PropertyChangeSupport(this);
                this.putProperty(PROP_SUPPORT, propertyChangeSupport);
            }
            bl = !propertyChangeSupport.hasListeners(null);
            propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }
        if (bl) {
            this.addNotifySuper = false;
            this.addNotify();
            if (!this.addNotifySuper) {
                object = "You must call super.addNotify() from " + this.getClass().getName() + ".addNotify()";
                err.log(16, (String)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        boolean bl;
        Object object = this.getLock();
        synchronized (object) {
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)this.getProperty(PROP_SUPPORT);
            if (propertyChangeSupport == null) {
                return;
            }
            boolean bl2 = propertyChangeSupport.hasListeners(null);
            propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
            bl = bl2 && !propertyChangeSupport.hasListeners(null);
        }
        if (bl) {
            this.putProperty(PROP_SUPPORT, null);
            this.removeNotifySuper = false;
            this.removeNotify();
            if (!this.removeNotifySuper) {
                object = "You must call super.removeNotify() from " + this.getClass().getName() + ".removeNotify()";
                err.log(16, (String)object);
            }
        }
    }

    protected void addNotify() {
        this.addNotifySuper = true;
    }

    protected void removeNotify() {
        this.removeNotifySuper = true;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)this.getProperty(PROP_SUPPORT);
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    protected Object writeReplace() {
        return new WriteReplace(this);
    }

    public static SharedClassObject findObject(Class clazz) {
        return SharedClassObject.findObject(clazz, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedClassObject findObject(Class clazz, boolean bl) {
        String string = clazz.getName().intern();
        synchronized (string) {
            Object object;
            DataEntry dataEntry = (DataEntry)values.get(clazz);
            SharedClassObject sharedClassObject = dataEntry == null ? null : dataEntry.get();
            boolean bl2 = false;
            if (sharedClassObject == null && bl) {
                object = new SetAccessibleAction(clazz);
                try {
                    sharedClassObject = (SharedClassObject)AccessController.doPrivileged(object);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(exception.toString());
                    illegalArgumentException.initCause(exception);
                    throw illegalArgumentException;
                }
                bl2 = true;
            }
            if ((dataEntry = (DataEntry)values.get(clazz)) != null) {
                object = dataEntry.get();
                if (sharedClassObject != null && sharedClassObject != object) {
                    if (object == null && bl) {
                        throw new IllegalStateException("Inconsistent state: " + clazz);
                    }
                    return object;
                }
            }
            if (bl2 && sharedClassObject.isSystemOption() && ((Lookup.Result)(object = Lookup.getDefault().lookup(new Lookup.Template(clazz)))).allInstances().isEmpty()) {
                sharedClassObject.waitingOnSystemOption = true;
                SharedClassObject sharedClassObject2 = sharedClassObject;
                IllegalStateException illegalStateException = new IllegalStateException("Making a SystemOption here that is not in lookup...");
                class SOLoader
                implements LookupListener {
                    private final /* synthetic */ Lookup.Result val$r;
                    private final /* synthetic */ SharedClassObject val$_obj;
                    private final /* synthetic */ IllegalStateException val$start;

                    SOLoader(Lookup.Result result, SharedClassObject sharedClassObject, IllegalStateException illegalStateException) {
                        this.val$r = result;
                        this.val$_obj = sharedClassObject;
                        this.val$start = illegalStateException;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void resultChanged(LookupEvent lookupEvent) {
                        if (!this.val$r.allInstances().isEmpty()) {
                            this.val$r.removeLookupListener(this);
                            Object object = this.val$_obj.getLock();
                            synchronized (object) {
                                this.val$_obj.waitingOnSystemOption = false;
                                if (this.val$_obj.prematureSystemOptionMutation != null) {
                                    SharedClassObject.warn(this.val$start);
                                    SharedClassObject.warn(this.val$_obj.prematureSystemOptionMutation);
                                    SharedClassObject.warn(new IllegalStateException("...and maybe getting clobbered here, see #17711."));
                                    this.val$_obj.prematureSystemOptionMutation = null;
                                }
                            }
                        }
                    }
                }
                ((Lookup.Result)object).addLookupListener(new SOLoader((Lookup.Result)object, sharedClassObject2, illegalStateException));
            }
            if (sharedClassObject == null && bl) {
                throw new IllegalStateException("Inconsistent state: " + clazz);
            }
            return sharedClassObject;
        }
    }

    private boolean isSystemOption() {
        for (Class<?> clazz = this.getClass(); clazz != (class$org$openide$util$SharedClassObject == null ? SharedClassObject.class$("org.openide.util.SharedClassObject") : class$org$openide$util$SharedClassObject); clazz = clazz.getSuperclass()) {
            if (!"org.openide.options.SystemOption".equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    private static void warn(Throwable throwable) {
        err.notify(1, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object createInstancePrivileged(Class clazz) throws Exception {
        Map map;
        Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        String string = clazz.getName();
        if (!$assertionsDisabled && instancesBeingCreated == null) {
            throw new AssertionError();
        }
        Map map2 = instancesBeingCreated;
        synchronized (map2) {
            Integer n = (Integer)instancesBeingCreated.get(string);
            instancesBeingCreated.put(string, n == null ? new Integer(1) : new Integer(n + 1));
        }
        try {
            map2 = constructor.newInstance(new Object[0]);
            Object var7_6 = null;
            map = instancesBeingCreated;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Map map3 = instancesBeingCreated;
            synchronized (map3) {
                Integer n = (Integer)instancesBeingCreated.get(string);
                if (n == 1) {
                    instancesBeingCreated.remove(string);
                } else {
                    instancesBeingCreated.put(string, new Integer(n - 1));
                }
            }
            constructor.setAccessible(false);
            throw throwable;
        }
        synchronized (map) {
            Integer n = (Integer)instancesBeingCreated.get(string);
            if (n == 1) {
                instancesBeingCreated.remove(string);
            } else {
                instancesBeingCreated.put(string, new Integer(n - 1));
            }
        }
        constructor.setAccessible(false);
        return map2;
    }

    protected void reset() {
    }

    static {
        $assertionsDisabled = !SharedClassObject.class.desiredAssertionStatus();
        PROP_SUPPORT = new Object();
        values = new WeakHashMap(4);
        instancesBeingCreated = new HashMap(3);
        alreadyWarnedAboutDupes = new HashSet();
        err = ErrorManager.getDefault().getInstance("org.openide.util.SharedClassObject");
    }

    static final class SetAccessibleAction
    implements PrivilegedExceptionAction {
        Class klass;

        SetAccessibleAction(Class clazz) {
            this.klass = clazz;
        }

        public Object run() throws Exception {
            return SharedClassObject.createInstancePrivileged(this.klass);
        }
    }

    static final class DataEntry {
        private HashMap map;
        private int count = 0;
        private WeakReference ref = new WeakReference<Object>(null);
        private boolean initialized = false;
        private boolean initializeInProgress = false;
        private Throwable invalid = null;

        DataEntry() {
        }

        public String toString() {
            return "SCO.DataEntry[ref=" + this.ref.get() + ",count=" + this.count + ",initialized=" + this.initialized + ",invalid=" + this.invalid + ",map=" + this.map + "]";
        }

        boolean isInInitialize() {
            return this.initializeInProgress;
        }

        Map getMap(SharedClassObject sharedClassObject) {
            this.ensureValid(sharedClassObject);
            if (this.map == null) {
                this.map = new HashMap();
            }
            if (!this.initialized) {
                this.initialized = true;
                this.tryToInitialize(sharedClassObject);
            }
            return this.map;
        }

        Object get(SharedClassObject sharedClassObject, Object object) {
            Object v;
            this.ensureValid(sharedClassObject);
            if (this.map == null) {
                this.map = new HashMap();
                v = null;
            } else {
                v = this.map.get(object);
            }
            if (v == null && !this.initialized) {
                if (object == PROP_SUPPORT) {
                    return null;
                }
                this.initialized = true;
                this.tryToInitialize(sharedClassObject);
                v = this.map.get(object);
            }
            return v;
        }

        Map getMap() {
            this.ensureValid(this.get());
            if (this.map == null) {
                this.map = new HashMap();
            }
            return this.map;
        }

        private void ensureValid(SharedClassObject sharedClassObject) throws IllegalStateException {
            if (this.invalid != null) {
                String string = sharedClassObject != null ? sharedClassObject.toString() : "<unknown object>";
                IllegalStateException illegalStateException = new IllegalStateException(string);
                err.annotate((Throwable)illegalStateException, this.invalid);
                throw illegalStateException;
            }
        }

        private void tryToInitialize(SharedClassObject sharedClassObject) throws IllegalStateException {
            this.initializeInProgress = true;
            sharedClassObject.initializeSuper = false;
            try {
                sharedClassObject.initialize();
            }
            catch (Exception exception) {
                this.invalid = exception;
                IllegalStateException illegalStateException = new IllegalStateException(this.invalid.toString() + " from " + sharedClassObject);
                err.annotate((Throwable)illegalStateException, this.invalid);
                throw illegalStateException;
            }
            catch (LinkageError linkageError) {
                this.invalid = linkageError;
                IllegalStateException illegalStateException = new IllegalStateException(this.invalid.toString() + " from " + sharedClassObject);
                err.annotate((Throwable)illegalStateException, this.invalid);
                throw illegalStateException;
            }
            finally {
                this.initializeInProgress = false;
            }
            if (!sharedClassObject.initializeSuper) {
                String string = "You must call super.initialize() from " + sharedClassObject.getClass().getName() + ".initialize()";
                err.log(16, string);
            }
        }

        int increase() {
            return ++this.count;
        }

        int decrease() {
            return --this.count;
        }

        SharedClassObject first(SharedClassObject sharedClassObject) {
            SharedClassObject sharedClassObject2 = (SharedClassObject)this.ref.get();
            if (sharedClassObject2 == null) {
                this.ref = new WeakReference<SharedClassObject>(sharedClassObject);
                return sharedClassObject;
            }
            return sharedClassObject2;
        }

        public SharedClassObject get() {
            return (SharedClassObject)this.ref.get();
        }

        public void reset(SharedClassObject sharedClassObject) {
            SharedClassObject sharedClassObject2 = this.get();
            if (sharedClassObject2 != null && sharedClassObject2 != sharedClassObject) {
                return;
            }
            this.invalid = null;
            this.getMap().clear();
            this.initialized = true;
            this.tryToInitialize(sharedClassObject);
        }
    }

    static final class WriteReplace
    implements Serializable {
        static final long serialVersionUID = 1327893248974327640L;
        private Class clazz;
        private String name;
        private transient SharedClassObject object;

        public WriteReplace(SharedClassObject sharedClassObject) {
            this.object = sharedClassObject;
            this.clazz = sharedClassObject.getClass();
            this.name = this.clazz.getName();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            this.object.writeExternal(objectOutputStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.clazz == null) {
                if (this.name != null) {
                    throw new ClassNotFoundException(this.name);
                }
                throw new ClassNotFoundException();
            }
            this.object = SharedClassObject.findObject(this.clazz, true);
            this.object.inReadExternal = true;
            try {
                this.object.readExternal(objectInputStream);
            }
            finally {
                this.object.inReadExternal = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object readResolve() throws ObjectStreamException {
            SharedClassObject sharedClassObject = this.object;
            Method method = WriteReplace.findReadResolveMethod(this.object.getClass());
            if (method != null) {
                try {
                    method.setAccessible(true);
                    Object object = method.invoke((Object)this.object, null);
                    return object;
                }
                catch (Exception exception) {
                    String string = "Skipping " + this.object.getClass() + " resolution:";
                    err.annotate(exception, 0, string, null, null, null);
                    err.notify(1, exception);
                }
                finally {
                    method.setAccessible(false);
                }
            }
            return sharedClassObject;
        }

        private static Method findReadResolveMethod(Class clazz) {
            Method method = null;
            for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                try {
                    method = WriteReplace.accept(clazz2.getDeclaredMethod("readResolve", new Class[0]));
                    if (method == null) continue;
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return method;
        }

        private static Method accept(Method method) {
            Class<?>[] classArray;
            if (method != null && (classArray = method.getExceptionTypes()).length == 1 && (class$java$io$ObjectStreamException == null ? (class$java$io$ObjectStreamException = SharedClassObject.class$("java.io.ObjectStreamException")) : class$java$io$ObjectStreamException).equals(classArray[0]) && (class$java$lang$Object == null ? (class$java$lang$Object = SharedClassObject.class$("java.lang.Object")) : class$java$lang$Object).equals(method.getReturnType())) {
                return method;
            }
            return null;
        }
    }
}

